/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Population;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.StoppingCondition;
import java.util.concurrent.TimeUnit;

public class FixedElapsedTime
implements StoppingCondition {
    private final long maxTimePeriod;
    private long endTime = -1L;

    public FixedElapsedTime(long l) {
        this(l, TimeUnit.SECONDS);
    }

    public FixedElapsedTime(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new NumberIsTooSmallException(l, (Number)0, true);
        }
        this.maxTimePeriod = timeUnit.toNanos(l);
    }

    public boolean isSatisfied(Population population) {
        if (this.endTime < 0L) {
            this.endTime = System.nanoTime() + this.maxTimePeriod;
        }
        return System.nanoTime() >= this.endTime;
    }
}

