/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Chromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.ListPopulation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Population;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElitisticListPopulation
extends ListPopulation {
    private double elitismRate = 0.9;

    public ElitisticListPopulation(List<Chromosome> list, int n, double d2) {
        super(list, n);
        this.setElitismRate(d2);
    }

    public ElitisticListPopulation(int n, double d2) {
        super(n);
        this.setElitismRate(d2);
    }

    @Override
    public Population nextGeneration() {
        ElitisticListPopulation elitisticListPopulation = new ElitisticListPopulation(this.getPopulationLimit(), this.getElitismRate());
        List<Chromosome> list = this.getChromosomeList();
        Collections.sort(list);
        int n = (int)FastMath.ceil((1.0 - this.getElitismRate()) * (double)list.size());
        while (n < list.size()) {
            elitisticListPopulation.addChromosome(list.get(n));
            ++n;
        }
        return elitisticListPopulation;
    }

    public void setElitismRate(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ELITISM_RATE, (Number)d2, 0, 1);
        }
        this.elitismRate = d2;
    }

    public double getElitismRate() {
        return this.elitismRate;
    }
}

