/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.AbstractListChromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Chromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.ChromosomePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.CrossoverPolicy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.GeneticAlgorithm;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleCrossover<T>
implements CrossoverPolicy {
    private final boolean randomStart;

    public CycleCrossover() {
        this(false);
    }

    public CycleCrossover(boolean bl) {
        this.randomStart = bl;
    }

    public boolean isRandomStart() {
        return this.randomStart;
    }

    @Override
    public ChromosomePair crossover(Chromosome chromosome, Chromosome chromosome2) {
        if (!(chromosome instanceof AbstractListChromosome) || !(chromosome2 instanceof AbstractListChromosome)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INVALID_FIXED_LENGTH_CHROMOSOME, new Object[0]);
        }
        return this.mate((AbstractListChromosome)chromosome, (AbstractListChromosome)chromosome2);
    }

    protected ChromosomePair mate(AbstractListChromosome<T> abstractListChromosome, AbstractListChromosome<T> abstractListChromosome2) {
        int n = abstractListChromosome.getLength();
        if (n != abstractListChromosome2.getLength()) {
            throw new DimensionMismatchException(abstractListChromosome2.getLength(), n);
        }
        List<T> list = abstractListChromosome.getRepresentation();
        List<T> list2 = abstractListChromosome2.getRepresentation();
        ArrayList<T> arrayList = new ArrayList<T>(abstractListChromosome2.getRepresentation());
        ArrayList<T> arrayList2 = new ArrayList<T>(abstractListChromosome.getRepresentation());
        HashSet hashSet = new HashSet(n);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n);
        int n2 = this.randomStart ? GeneticAlgorithm.getRandomGenerator().nextInt(n) : 0;
        int n3 = 1;
        while (hashSet.size() < n) {
            arrayList3.add(n2);
            T t = list2.get(n2);
            int n4 = list.indexOf(t);
            while (n4 != (Integer)arrayList3.get(0)) {
                arrayList3.add(n4);
                T t2 = list2.get(n4);
                n4 = list.indexOf(t2);
            }
            if (n3++ % 2 != 0) {
                Iterator iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    int n5 = (Integer)iterator.next();
                    Object e2 = arrayList.get(n5);
                    arrayList.set(n5, arrayList2.get(n5));
                    arrayList2.set(n5, e2);
                }
            }
            hashSet.addAll(arrayList3);
            n2 = ((Integer)arrayList3.get(0) + 1) % n;
            while (hashSet.contains(n2) && hashSet.size() < n) {
                if (++n2 < n) continue;
                n2 = 0;
            }
            arrayList3.clear();
        }
        return new ChromosomePair(abstractListChromosome.newFixedLengthChromosome(arrayList), abstractListChromosome2.newFixedLengthChromosome(arrayList2));
    }
}

