/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.AbstractListChromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Chromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.GeneticAlgorithm;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.InvalidRepresentationException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryChromosome
extends AbstractListChromosome<Integer> {
    public BinaryChromosome(List<Integer> list) {
        super(list);
    }

    public BinaryChromosome(Integer[] integerArray) {
        super(integerArray);
    }

    @Override
    protected void checkValidity(List<Integer> object) {
        object = object.iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            if (n >= 0 && n <= 1) continue;
            throw new InvalidRepresentationException(LocalizedFormats.INVALID_BINARY_DIGIT, n);
        }
    }

    public static List<Integer> randomBinaryRepresentation(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            arrayList.add(GeneticAlgorithm.getRandomGenerator().nextInt(2));
        }
        return arrayList;
    }

    @Override
    protected boolean isSame(Chromosome chromosome) {
        if (!(chromosome instanceof BinaryChromosome)) {
            return false;
        }
        chromosome = (BinaryChromosome)chromosome;
        if (this.getLength() != ((AbstractListChromosome)chromosome).getLength()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getRepresentation().size(); ++i2) {
            if (((Integer)this.getRepresentation().get(i2)).equals(((AbstractListChromosome)chromosome).getRepresentation().get(i2))) continue;
            return false;
        }
        return true;
    }
}

