/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.Fraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.FractionFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ProperFractionFormat
extends FractionFormat {
    private static final long serialVersionUID = 760934726031766749L;
    private NumberFormat wholeFormat;

    public ProperFractionFormat() {
        this(ProperFractionFormat.getDefaultNumberFormat());
    }

    public ProperFractionFormat(NumberFormat numberFormat) {
        NumberFormat numberFormat2 = numberFormat;
        this(numberFormat2, (NumberFormat)numberFormat2.clone(), (NumberFormat)numberFormat.clone());
    }

    public ProperFractionFormat(NumberFormat numberFormat, NumberFormat numberFormat2, NumberFormat numberFormat3) {
        super(numberFormat2, numberFormat3);
        this.setWholeFormat(numberFormat);
    }

    public StringBuffer format(Fraction fraction, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        int n = fraction.getNumerator();
        int n2 = fraction.getDenominator();
        int n3 = n / n2;
        n %= n2;
        if (n3 != 0) {
            this.getWholeFormat().format(n3, stringBuffer, fieldPosition);
            stringBuffer.append(' ');
            n = FastMath.abs(n);
        }
        this.getNumeratorFormat().format(n, stringBuffer, fieldPosition);
        stringBuffer.append(" / ");
        this.getDenominatorFormat().format(n2, stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public NumberFormat getWholeFormat() {
        return this.wholeFormat;
    }

    public Fraction parse(String object, ParsePosition parsePosition) {
        Fraction fraction = super.parse((String)object, parsePosition);
        if (fraction != null) {
            return fraction;
        }
        int n = parsePosition.getIndex();
        ProperFractionFormat.parseAndIgnoreWhitespace((String)object, parsePosition);
        Number number = this.getWholeFormat().parse((String)object, parsePosition);
        if (number == null) {
            parsePosition.setIndex(n);
            return null;
        }
        ProperFractionFormat.parseAndIgnoreWhitespace((String)object, parsePosition);
        Number number2 = this.getNumeratorFormat().parse((String)object, parsePosition);
        if (number2 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (number2.intValue() < 0) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c2 = ProperFractionFormat.parseNextCharacter((String)object, parsePosition);
        switch (c2) {
            case '\u0000': {
                return new Fraction(number2.intValue(), 1);
            }
            case '/': {
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        ProperFractionFormat.parseAndIgnoreWhitespace((String)object, parsePosition);
        object = this.getDenominatorFormat().parse((String)object, parsePosition);
        if (object == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (((Number)object).intValue() < 0) {
            parsePosition.setIndex(n);
            return null;
        }
        int n3 = number.intValue();
        n = number2.intValue();
        int n4 = ((Number)object).intValue();
        return new Fraction((FastMath.abs(n3) * n4 + n) * MathUtils.copySign(1, n3), n4);
    }

    public void setWholeFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.WHOLE_FORMAT, new Object[0]);
        }
        this.wholeFormat = numberFormat;
    }
}

