/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFractionFormat;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ProperBigFractionFormat
extends BigFractionFormat {
    private static final long serialVersionUID = -6337346779577272307L;
    private NumberFormat wholeFormat;

    public ProperBigFractionFormat() {
        this(ProperBigFractionFormat.getDefaultNumberFormat());
    }

    public ProperBigFractionFormat(NumberFormat numberFormat) {
        NumberFormat numberFormat2 = numberFormat;
        this(numberFormat2, (NumberFormat)numberFormat2.clone(), (NumberFormat)numberFormat.clone());
    }

    public ProperBigFractionFormat(NumberFormat numberFormat, NumberFormat numberFormat2, NumberFormat numberFormat3) {
        super(numberFormat2, numberFormat3);
        this.setWholeFormat(numberFormat);
    }

    public StringBuffer format(BigFraction number, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        BigInteger bigInteger = number.getNumerator();
        number = number.getDenominator();
        BigInteger bigInteger2 = bigInteger.divide((BigInteger)number);
        bigInteger = bigInteger.remainder((BigInteger)number);
        if (!BigInteger.ZERO.equals(bigInteger2)) {
            this.getWholeFormat().format(bigInteger2, stringBuffer, fieldPosition);
            stringBuffer.append(' ');
            if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                bigInteger = bigInteger.negate();
            }
        }
        this.getNumeratorFormat().format(bigInteger, stringBuffer, fieldPosition);
        stringBuffer.append(" / ");
        this.getDenominatorFormat().format(number, stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public NumberFormat getWholeFormat() {
        return this.wholeFormat;
    }

    public BigFraction parse(String object, ParsePosition parsePosition) {
        BigFraction bigFraction = super.parse((String)object, parsePosition);
        if (bigFraction != null) {
            return bigFraction;
        }
        int n = parsePosition.getIndex();
        ProperBigFractionFormat.parseAndIgnoreWhitespace((String)object, parsePosition);
        BigInteger bigInteger = this.parseNextBigInteger((String)object, parsePosition);
        if (bigInteger == null) {
            parsePosition.setIndex(n);
            return null;
        }
        ProperBigFractionFormat.parseAndIgnoreWhitespace((String)object, parsePosition);
        BigInteger bigInteger2 = this.parseNextBigInteger((String)object, parsePosition);
        if (bigInteger2 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c2 = ProperBigFractionFormat.parseNextCharacter((String)object, parsePosition);
        switch (c2) {
            case '\u0000': {
                return new BigFraction(bigInteger2);
            }
            case '/': {
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        ProperBigFractionFormat.parseAndIgnoreWhitespace((String)object, parsePosition);
        object = this.parseNextBigInteger((String)object, parsePosition);
        if (object == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (((BigInteger)object).compareTo(BigInteger.ZERO) < 0) {
            parsePosition.setIndex(n);
            return null;
        }
        boolean bl = bigInteger.compareTo(BigInteger.ZERO) < 0;
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        bigInteger2 = bigInteger.multiply((BigInteger)object).add(bigInteger2);
        if (bl) {
            bigInteger2 = bigInteger2.negate();
        }
        return new BigFraction(bigInteger2, (BigInteger)object);
    }

    public void setWholeFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.WHOLE_FORMAT, new Object[0]);
        }
        this.wholeFormat = numberFormat;
    }
}

