/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathParseException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.AbstractFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.Fraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.ProperFractionFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class FractionFormat
extends AbstractFormat {
    private static final long serialVersionUID = 3008655719530972611L;

    public FractionFormat() {
    }

    public FractionFormat(NumberFormat numberFormat) {
        super(numberFormat);
    }

    public FractionFormat(NumberFormat numberFormat, NumberFormat numberFormat2) {
        super(numberFormat, numberFormat2);
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public static String formatFraction(Fraction fraction) {
        return FractionFormat.getImproperInstance().format(fraction);
    }

    public static FractionFormat getImproperInstance() {
        return FractionFormat.getImproperInstance(Locale.getDefault());
    }

    public static FractionFormat getImproperInstance(Locale locale) {
        return new FractionFormat(FractionFormat.getDefaultNumberFormat(locale));
    }

    public static FractionFormat getProperInstance() {
        return FractionFormat.getProperInstance(Locale.getDefault());
    }

    public static FractionFormat getProperInstance(Locale locale) {
        return new ProperFractionFormat(FractionFormat.getDefaultNumberFormat(locale));
    }

    protected static NumberFormat getDefaultNumberFormat() {
        return FractionFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    public StringBuffer format(Fraction fraction, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        this.getNumeratorFormat().format(fraction.getNumerator(), stringBuffer, fieldPosition);
        stringBuffer.append(" / ");
        this.getDenominatorFormat().format(fraction.getDenominator(), stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Fraction) {
            object = this.format((Fraction)object, stringBuffer, fieldPosition);
        } else if (object instanceof Number) {
            object = this.format(new Fraction(((Number)object).doubleValue()), stringBuffer, fieldPosition);
        } else {
            throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_FORMAT_OBJECT_TO_FRACTION, new Object[0]);
        }
        return object;
    }

    public Fraction parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Fraction fraction = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), Fraction.class);
        }
        return fraction;
    }

    public Fraction parse(String object, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        FractionFormat.parseAndIgnoreWhitespace((String)object, parsePosition);
        Number number = this.getNumeratorFormat().parse((String)object, parsePosition);
        if (number == null) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c2 = FractionFormat.parseNextCharacter((String)object, parsePosition);
        switch (c2) {
            case '\u0000': {
                return new Fraction(number.intValue(), 1);
            }
            case '/': {
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        FractionFormat.parseAndIgnoreWhitespace((String)object, parsePosition);
        object = this.getDenominatorFormat().parse((String)object, parsePosition);
        if (object == null) {
            parsePosition.setIndex(n);
            return null;
        }
        return new Fraction(number.intValue(), ((Number)object).intValue());
    }
}

