/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.FractionConversionException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.FractionField;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ArithmeticUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fraction
extends Number
implements FieldElement<Fraction>,
Serializable,
Comparable<Fraction> {
    public static final Fraction TWO = new Fraction(2, 1);
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ZERO = new Fraction(0, 1);
    public static final Fraction FOUR_FIFTHS = new Fraction(4, 5);
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction THREE_FIFTHS = new Fraction(3, 5);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    public static final Fraction TWO_FIFTHS = new Fraction(2, 5);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction MINUS_ONE = new Fraction(-1, 1);
    private static final long serialVersionUID = 3698073679419233275L;
    private static final double DEFAULT_EPSILON = 1.0E-5;
    private final int denominator;
    private final int numerator;

    public Fraction(double d2) {
        this(d2, 1.0E-5, 100);
    }

    public Fraction(double d2, double d3, int n) {
        this(d2, d3, Integer.MAX_VALUE, n);
    }

    public Fraction(double d2, int n) {
        this(d2, 0.0, n, 100);
    }

    private Fraction(double d2, double d3, int n, int n2) {
        long l;
        long l2;
        double d4 = d2;
        long l3 = (long)FastMath.floor(d4);
        if (FastMath.abs(l3) > Integer.MAX_VALUE) {
            throw new FractionConversionException(d2, l3, 1L);
        }
        if (FastMath.abs((double)l3 - d2) < d3) {
            this.numerator = (int)l3;
            this.denominator = 1;
            return;
        }
        long l4 = 1L;
        long l5 = 0L;
        long l6 = l3;
        long l7 = 1L;
        int n3 = 0;
        boolean bl = false;
        do {
            ++n3;
            double d5 = 1.0 / (d4 - (double)l3);
            long l8 = (long)FastMath.floor(d5);
            l2 = l8 * l6 + l4;
            l = l8 * l7 + l5;
            if (FastMath.abs(l2) > Integer.MAX_VALUE || FastMath.abs(l) > Integer.MAX_VALUE) {
                if (d3 == 0.0 && FastMath.abs(l7) < (long)n) break;
                throw new FractionConversionException(d2, l2, l);
            }
            double d6 = (double)l2 / (double)l;
            if (n3 < n2 && FastMath.abs(d6 - d2) > d3 && l < (long)n) {
                l4 = l6;
                l6 = l2;
                l5 = l7;
                l7 = l;
                l3 = l8;
                d4 = d5;
                continue;
            }
            bl = true;
        } while (!bl);
        if (n3 >= n2) {
            throw new FractionConversionException(d2, n2);
        }
        if (l < (long)n) {
            this.numerator = (int)l2;
            this.denominator = (int)l;
            return;
        }
        this.numerator = (int)l6;
        this.denominator = (int)l7;
    }

    public Fraction(int n) {
        this(n, 1);
    }

    public Fraction(int n, int n2) {
        int n3;
        if (n2 == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR_IN_FRACTION, n, n2);
        }
        if (n2 < 0) {
            if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_FRACTION, n, n2);
            }
            n = -n;
            n2 = -n2;
        }
        if ((n3 = ArithmeticUtils.gcd(n, n2)) > 1) {
            n /= n3;
            n2 /= n3;
        }
        if (n2 < 0) {
            n = -n;
            n2 = -n2;
        }
        this.numerator = n;
        this.denominator = n2;
    }

    public Fraction abs() {
        Fraction fraction = this.numerator >= 0 ? this : this.negate();
        return fraction;
    }

    @Override
    public int compareTo(Fraction fraction) {
        long l = (long)this.numerator * (long)fraction.denominator;
        long l2 = (long)this.denominator * (long)fraction.numerator;
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Fraction) {
            object = (Fraction)object;
            return this.numerator == ((Fraction)object).numerator && this.denominator == ((Fraction)object).denominator;
        }
        return false;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        return 37 * (629 + this.numerator) + this.denominator;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_FRACTION, this.numerator, this.denominator);
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    @Override
    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.numerator);
    }

    @Override
    public Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    @Override
    public Fraction add(int n) {
        return new Fraction(this.numerator + n * this.denominator, this.denominator);
    }

    @Override
    public Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    @Override
    public Fraction subtract(int n) {
        return new Fraction(this.numerator - n * this.denominator, this.denominator);
    }

    private Fraction addSub(Fraction fraction, boolean bl) {
        if (fraction == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (this.numerator == 0) {
            if (bl) {
                return fraction;
            }
            return fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int n = ArithmeticUtils.gcd(this.denominator, fraction.denominator);
        if (n == 1) {
            int n2 = ArithmeticUtils.mulAndCheck(this.numerator, fraction.denominator);
            int n3 = ArithmeticUtils.mulAndCheck(fraction.numerator, this.denominator);
            return new Fraction(bl ? ArithmeticUtils.addAndCheck(n2, n3) : ArithmeticUtils.subAndCheck(n2, n3), ArithmeticUtils.mulAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger bigInteger = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / n));
        BigInteger bigInteger2 = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / n));
        BigInteger bigInteger3 = bl ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2);
        int n4 = bigInteger3.mod(BigInteger.valueOf(n)).intValue();
        if ((bigInteger3 = bigInteger3.divide(BigInteger.valueOf(n4 = n4 == 0 ? n : ArithmeticUtils.gcd(n4, n)))).bitLength() > 31) {
            throw new MathArithmeticException(LocalizedFormats.NUMERATOR_OVERFLOW_AFTER_MULTIPLY, bigInteger3);
        }
        return new Fraction(bigInteger3.intValue(), ArithmeticUtils.mulAndCheck(this.denominator / n, fraction.denominator / n4));
    }

    @Override
    public Fraction multiply(Fraction fraction) {
        if (fraction == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int n = ArithmeticUtils.gcd(this.numerator, fraction.denominator);
        int n2 = ArithmeticUtils.gcd(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(ArithmeticUtils.mulAndCheck(this.numerator / n, fraction.numerator / n2), ArithmeticUtils.mulAndCheck(this.denominator / n2, fraction.denominator / n));
    }

    @Override
    public Fraction multiply(int n) {
        return this.multiply(new Fraction(n));
    }

    @Override
    public Fraction divide(Fraction fraction) {
        if (fraction == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (fraction.numerator == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_FRACTION_TO_DIVIDE_BY, fraction.numerator, fraction.denominator);
        }
        return this.multiply(fraction.reciprocal());
    }

    @Override
    public Fraction divide(int n) {
        return this.divide(new Fraction(n));
    }

    public double percentageValue() {
        return 100.0 * this.doubleValue();
    }

    public static Fraction getReducedFraction(int n, int n2) {
        if (n2 == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR_IN_FRACTION, n, n2);
        }
        if (n == 0) {
            return ZERO;
        }
        if (n2 == Integer.MIN_VALUE && (n & 1) == 0) {
            n /= 2;
            n2 /= 2;
        }
        if (n2 < 0) {
            if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_FRACTION, n, n2);
            }
            n = -n;
            n2 = -n2;
        }
        int n3 = ArithmeticUtils.gcd(n, n2);
        return new Fraction(n /= n3, n2 /= n3);
    }

    public String toString() {
        String string = this.denominator == 1 ? Integer.toString(this.numerator) : (this.numerator == 0 ? "0" : this.numerator + " / " + this.denominator);
        return string;
    }

    public FractionField getField() {
        return FractionField.getInstance();
    }
}

