/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFractionField;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.FractionConversionException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ArithmeticUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigFraction
extends Number
implements FieldElement<BigFraction>,
Serializable,
Comparable<BigFraction> {
    public static final BigFraction TWO = new BigFraction(2);
    public static final BigFraction ONE = new BigFraction(1);
    public static final BigFraction ZERO = new BigFraction(0);
    public static final BigFraction MINUS_ONE = new BigFraction(-1);
    public static final BigFraction FOUR_FIFTHS = new BigFraction(4, 5);
    public static final BigFraction ONE_FIFTH = new BigFraction(1, 5);
    public static final BigFraction ONE_HALF = new BigFraction(1, 2);
    public static final BigFraction ONE_QUARTER = new BigFraction(1, 4);
    public static final BigFraction ONE_THIRD = new BigFraction(1, 3);
    public static final BigFraction THREE_FIFTHS = new BigFraction(3, 5);
    public static final BigFraction THREE_QUARTERS = new BigFraction(3, 4);
    public static final BigFraction TWO_FIFTHS = new BigFraction(2, 5);
    public static final BigFraction TWO_QUARTERS = new BigFraction(2, 4);
    public static final BigFraction TWO_THIRDS = new BigFraction(2, 3);
    private static final long serialVersionUID = -5630213147331578515L;
    private static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    private final BigInteger numerator;
    private final BigInteger denominator;

    public BigFraction(BigInteger bigInteger) {
        this(bigInteger, BigInteger.ONE);
    }

    public BigFraction(BigInteger bigInteger, BigInteger bigInteger2) {
        MathUtils.checkNotNull(bigInteger, LocalizedFormats.NUMERATOR, new Object[0]);
        MathUtils.checkNotNull(bigInteger2, LocalizedFormats.DENOMINATOR, new Object[0]);
        if (bigInteger2.signum() == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (bigInteger.signum() == 0) {
            this.numerator = BigInteger.ZERO;
            this.denominator = BigInteger.ONE;
            return;
        }
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        if (BigInteger.ONE.compareTo(bigInteger3) < 0) {
            bigInteger = bigInteger.divide(bigInteger3);
            bigInteger2 = bigInteger2.divide(bigInteger3);
        }
        if (bigInteger2.signum() == -1) {
            bigInteger = bigInteger.negate();
            bigInteger2 = bigInteger2.negate();
        }
        this.numerator = bigInteger;
        this.denominator = bigInteger2;
    }

    public BigFraction(double d2) {
        if (Double.isNaN(d2)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NAN_VALUE_CONVERSION, new Object[0]);
        }
        if (Double.isInfinite(d2)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_VALUE_CONVERSION, new Object[0]);
        }
        long l = Double.doubleToLongBits(d2);
        long l2 = l & Long.MIN_VALUE;
        long l3 = l & 0x7FF0000000000000L;
        long l4 = l & 0xFFFFFFFFFFFFFL;
        if (l3 != 0L) {
            l4 |= 0x10000000000000L;
        }
        if (l2 != 0L) {
            l4 = -l4;
        }
        int n = (int)(l3 >> 52) - 1075;
        while ((l4 & 0x1FFFFFFFFFFFFEL) != 0L && (l4 & 1L) == 0L) {
            l4 >>= 1;
            ++n;
        }
        if (n < 0) {
            this.numerator = BigInteger.valueOf(l4);
            this.denominator = BigInteger.ZERO.flipBit(-n);
            return;
        }
        this.numerator = BigInteger.valueOf(l4).multiply(BigInteger.ZERO.flipBit(n));
        this.denominator = BigInteger.ONE;
    }

    public BigFraction(double d2, double d3, int n) {
        this(d2, d3, Integer.MAX_VALUE, n);
    }

    private BigFraction(double d2, double d3, int n, int n2) {
        long l;
        long l2;
        double d4 = d2;
        long l3 = (long)FastMath.floor(d4);
        if (FastMath.abs(l3) > Integer.MAX_VALUE) {
            throw new FractionConversionException(d2, l3, 1L);
        }
        if (FastMath.abs((double)l3 - d2) < d3) {
            this.numerator = BigInteger.valueOf(l3);
            this.denominator = BigInteger.ONE;
            return;
        }
        long l4 = 1L;
        long l5 = 0L;
        long l6 = l3;
        long l7 = 1L;
        int n3 = 0;
        boolean bl = false;
        do {
            ++n3;
            double d5 = 1.0 / (d4 - (double)l3);
            long l8 = (long)FastMath.floor(d5);
            l2 = l8 * l6 + l4;
            l = l8 * l7 + l5;
            if (l2 > Integer.MAX_VALUE || l > Integer.MAX_VALUE) {
                if (d3 == 0.0 && FastMath.abs(l7) < (long)n) break;
                throw new FractionConversionException(d2, l2, l);
            }
            double d6 = (double)l2 / (double)l;
            if (n3 < n2 && FastMath.abs(d6 - d2) > d3 && l < (long)n) {
                l4 = l6;
                l6 = l2;
                l5 = l7;
                l7 = l;
                l3 = l8;
                d4 = d5;
                continue;
            }
            bl = true;
        } while (!bl);
        if (n3 >= n2) {
            throw new FractionConversionException(d2, n2);
        }
        if (l < (long)n) {
            this.numerator = BigInteger.valueOf(l2);
            this.denominator = BigInteger.valueOf(l);
            return;
        }
        this.numerator = BigInteger.valueOf(l6);
        this.denominator = BigInteger.valueOf(l7);
    }

    public BigFraction(double d2, int n) {
        this(d2, 0.0, n, 100);
    }

    public BigFraction(int n) {
        this(BigInteger.valueOf(n), BigInteger.ONE);
    }

    public BigFraction(int n, int n2) {
        this(BigInteger.valueOf(n), BigInteger.valueOf(n2));
    }

    public BigFraction(long l) {
        this(BigInteger.valueOf(l), BigInteger.ONE);
    }

    public BigFraction(long l, long l2) {
        this(BigInteger.valueOf(l), BigInteger.valueOf(l2));
    }

    public static BigFraction getReducedFraction(int n, int n2) {
        if (n == 0) {
            return ZERO;
        }
        return new BigFraction(n, n2);
    }

    public BigFraction abs() {
        if (this.numerator.signum() == 1) {
            return this;
        }
        return this.negate();
    }

    @Override
    public BigFraction add(BigInteger bigInteger) {
        MathUtils.checkNotNull(bigInteger);
        if (this.numerator.signum() == 0) {
            return new BigFraction(bigInteger);
        }
        if (bigInteger.signum() == 0) {
            return this;
        }
        return new BigFraction(this.numerator.add(this.denominator.multiply(bigInteger)), this.denominator);
    }

    @Override
    public BigFraction add(int n) {
        return this.add(BigInteger.valueOf(n));
    }

    @Override
    public BigFraction add(long l) {
        return this.add(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction add(BigFraction number) {
        BigInteger bigInteger;
        if (number == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (number.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return number;
        }
        if (this.denominator.equals(number.denominator)) {
            bigInteger = this.numerator.add(number.numerator);
            number = this.denominator;
        } else {
            bigInteger = this.numerator.multiply(number.denominator).add(number.numerator.multiply(this.denominator));
            number = this.denominator.multiply(number.denominator);
        }
        if (bigInteger.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(bigInteger, (BigInteger)number);
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator));
    }

    public BigDecimal bigDecimalValue(int n) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), n);
    }

    public BigDecimal bigDecimalValue(int n, int n2) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), n, n2);
    }

    @Override
    public int compareTo(BigFraction number) {
        int n;
        int n2 = this.numerator.signum();
        if (n2 != (n = number.numerator.signum())) {
            if (n2 > n) {
                return 1;
            }
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        BigInteger bigInteger = this.numerator.multiply(number.denominator);
        number = this.denominator.multiply(number.numerator);
        return bigInteger.compareTo((BigInteger)number);
    }

    @Override
    public BigFraction divide(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (bigInteger.signum() == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator, this.denominator.multiply(bigInteger));
    }

    @Override
    public BigFraction divide(int n) {
        return this.divide(BigInteger.valueOf(n));
    }

    @Override
    public BigFraction divide(long l) {
        return this.divide(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction divide(BigFraction bigFraction) {
        if (bigFraction == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (bigFraction.numerator.signum() == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(bigFraction.reciprocal());
    }

    @Override
    public double doubleValue() {
        double d2 = this.numerator.doubleValue() / this.denominator.doubleValue();
        if (Double.isNaN(d2)) {
            int n = FastMath.max(this.numerator.bitLength(), this.denominator.bitLength()) - FastMath.getExponent(Double.MAX_VALUE);
            d2 = this.numerator.shiftRight(n).doubleValue() / this.denominator.shiftRight(n).doubleValue();
        }
        return d2;
    }

    public boolean equals(Object object) {
        boolean bl;
        block4: {
            boolean bl2;
            block3: {
                block2: {
                    bl = false;
                    if (this != object) break block2;
                    bl2 = true;
                    break block3;
                }
                if (!(object instanceof BigFraction)) break block4;
                object = ((BigFraction)object).reduce();
                BigFraction bigFraction = this.reduce();
                bl2 = bigFraction.numerator.equals(((BigFraction)object).numerator) && bigFraction.denominator.equals(((BigFraction)object).denominator);
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public float floatValue() {
        float f2 = this.numerator.floatValue() / this.denominator.floatValue();
        if (Double.isNaN(f2)) {
            int n = FastMath.max(this.numerator.bitLength(), this.denominator.bitLength()) - FastMath.getExponent(Float.MAX_VALUE);
            f2 = this.numerator.shiftRight(n).floatValue() / this.denominator.shiftRight(n).floatValue();
        }
        return f2;
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public int getDenominatorAsInt() {
        return this.denominator.intValue();
    }

    public long getDenominatorAsLong() {
        return this.denominator.longValue();
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public int getNumeratorAsInt() {
        return this.numerator.intValue();
    }

    public long getNumeratorAsLong() {
        return this.numerator.longValue();
    }

    public int hashCode() {
        return 37 * (629 + this.numerator.hashCode()) + this.denominator.hashCode();
    }

    @Override
    public int intValue() {
        return this.numerator.divide(this.denominator).intValue();
    }

    @Override
    public long longValue() {
        return this.numerator.divide(this.denominator).longValue();
    }

    @Override
    public BigFraction multiply(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullArgumentException();
        }
        if (this.numerator.signum() == 0 || bigInteger.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(bigInteger.multiply(this.numerator), this.denominator);
    }

    @Override
    public BigFraction multiply(int n) {
        if (n == 0 || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(n));
    }

    @Override
    public BigFraction multiply(long l) {
        if (l == 0L || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction multiply(BigFraction bigFraction) {
        if (bigFraction == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (this.numerator.signum() == 0 || bigFraction.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator.multiply(bigFraction.numerator), this.denominator.multiply(bigFraction.denominator));
    }

    @Override
    public BigFraction negate() {
        return new BigFraction(this.numerator.negate(), this.denominator);
    }

    public double percentageValue() {
        return this.multiply(ONE_HUNDRED).doubleValue();
    }

    public BigFraction pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (n < 0) {
            return new BigFraction(this.denominator.pow(-n), this.numerator.pow(-n));
        }
        return new BigFraction(this.numerator.pow(n), this.denominator.pow(n));
    }

    public BigFraction pow(long l) {
        if (l == 0L) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (l < 0L) {
            return new BigFraction(ArithmeticUtils.pow(this.denominator, -l), ArithmeticUtils.pow(this.numerator, -l));
        }
        return new BigFraction(ArithmeticUtils.pow(this.numerator, l), ArithmeticUtils.pow(this.denominator, l));
    }

    public BigFraction pow(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (bigInteger.signum() == -1) {
            bigInteger = bigInteger.negate();
            return new BigFraction(ArithmeticUtils.pow(this.denominator, bigInteger), ArithmeticUtils.pow(this.numerator, bigInteger));
        }
        return new BigFraction(ArithmeticUtils.pow(this.numerator, bigInteger), ArithmeticUtils.pow(this.denominator, bigInteger));
    }

    public double pow(double d2) {
        return FastMath.pow(this.numerator.doubleValue(), d2) / FastMath.pow(this.denominator.doubleValue(), d2);
    }

    @Override
    public BigFraction reciprocal() {
        return new BigFraction(this.denominator, this.numerator);
    }

    public BigFraction reduce() {
        BigInteger bigInteger = this.numerator.gcd(this.denominator);
        if (BigInteger.ONE.compareTo(bigInteger) < 0) {
            return new BigFraction(this.numerator.divide(bigInteger), this.denominator.divide(bigInteger));
        }
        return this;
    }

    @Override
    public BigFraction subtract(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullArgumentException();
        }
        if (bigInteger.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return new BigFraction(bigInteger.negate());
        }
        return new BigFraction(this.numerator.subtract(this.denominator.multiply(bigInteger)), this.denominator);
    }

    @Override
    public BigFraction subtract(int n) {
        return this.subtract(BigInteger.valueOf(n));
    }

    @Override
    public BigFraction subtract(long l) {
        return this.subtract(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction subtract(BigFraction number) {
        BigInteger bigInteger;
        if (number == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (number.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return number.negate();
        }
        if (this.denominator.equals(number.denominator)) {
            bigInteger = this.numerator.subtract(number.numerator);
            number = this.denominator;
        } else {
            bigInteger = this.numerator.multiply(number.denominator).subtract(number.numerator.multiply(this.denominator));
            number = this.denominator.multiply(number.denominator);
        }
        return new BigFraction(bigInteger, (BigInteger)number);
    }

    public String toString() {
        String string = BigInteger.ONE.equals(this.denominator) ? this.numerator.toString() : (BigInteger.ZERO.equals(this.numerator) ? "0" : this.numerator + " / " + this.denominator);
        return string;
    }

    public BigFractionField getField() {
        return BigFractionField.getInstance();
    }
}

