/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class AbstractFormat
extends NumberFormat
implements Serializable {
    private static final long serialVersionUID = -6981118387974191891L;
    private NumberFormat denominatorFormat;
    private NumberFormat numeratorFormat;

    protected AbstractFormat() {
        this(AbstractFormat.getDefaultNumberFormat());
    }

    protected AbstractFormat(NumberFormat numberFormat) {
        NumberFormat numberFormat2 = numberFormat;
        this(numberFormat2, (NumberFormat)numberFormat2.clone());
    }

    protected AbstractFormat(NumberFormat numberFormat, NumberFormat numberFormat2) {
        this.numeratorFormat = numberFormat;
        this.denominatorFormat = numberFormat2;
    }

    protected static NumberFormat getDefaultNumberFormat() {
        return AbstractFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    protected static NumberFormat getDefaultNumberFormat(Locale cloneable) {
        cloneable = NumberFormat.getNumberInstance((Locale)cloneable);
        ((NumberFormat)cloneable).setMaximumFractionDigits(0);
        ((NumberFormat)cloneable).setParseIntegerOnly(true);
        return cloneable;
    }

    public NumberFormat getDenominatorFormat() {
        return this.denominatorFormat;
    }

    public NumberFormat getNumeratorFormat() {
        return this.numeratorFormat;
    }

    public void setDenominatorFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.DENOMINATOR_FORMAT, new Object[0]);
        }
        this.denominatorFormat = numberFormat;
    }

    public void setNumeratorFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.NUMERATOR_FORMAT, new Object[0]);
        }
        this.numeratorFormat = numberFormat;
    }

    protected static void parseAndIgnoreWhitespace(String string, ParsePosition parsePosition) {
        AbstractFormat.parseNextCharacter(string, parsePosition);
        ParsePosition parsePosition2 = parsePosition;
        parsePosition2.setIndex(parsePosition2.getIndex() - 1);
    }

    protected static char parseNextCharacter(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = string.length();
        char c2 = '\u0000';
        if (n < n2) {
            char c3;
            while (Character.isWhitespace(c3 = string.charAt(n++)) && n < n2) {
            }
            parsePosition.setIndex(n);
            if (n < n2) {
                c2 = c3;
            }
        }
        return c2;
    }

    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((Object)d2, stringBuffer, fieldPosition);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((Object)l, stringBuffer, fieldPosition);
    }
}

