/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer$Optimum;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem$Evaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer$InternalData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.OptimumImpl;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Incrementor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.util.Arrays;

public class LevenbergMarquardtOptimizer
implements LeastSquaresOptimizer {
    private static final double TWO_EPS = 2.0 * Precision.EPSILON;
    private final double initialStepBoundFactor;
    private final double costRelativeTolerance;
    private final double parRelativeTolerance;
    private final double orthoTolerance;
    private final double qrRankingThreshold;

    public LevenbergMarquardtOptimizer() {
        this(100.0, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double d2, double d3, double d4, double d5, double d6) {
        this.initialStepBoundFactor = d2;
        this.costRelativeTolerance = d3;
        this.parRelativeTolerance = d4;
        this.orthoTolerance = d5;
        this.qrRankingThreshold = d6;
    }

    public LevenbergMarquardtOptimizer withInitialStepBoundFactor(double d2) {
        return new LevenbergMarquardtOptimizer(d2, this.costRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withCostRelativeTolerance(double d2) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, d2, this.parRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withParameterRelativeTolerance(double d2) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, d2, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withOrthoTolerance(double d2) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, d2, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withRankingThreshold(double d2) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, d2);
    }

    public double getInitialStepBoundFactor() {
        return this.initialStepBoundFactor;
    }

    public double getCostRelativeTolerance() {
        return this.costRelativeTolerance;
    }

    public double getParameterRelativeTolerance() {
        return this.parRelativeTolerance;
    }

    public double getOrthoTolerance() {
        return this.orthoTolerance;
    }

    public double getRankingThreshold() {
        return this.qrRankingThreshold;
    }

    public LeastSquaresOptimizer$Optimum optimize(LeastSquaresProblem leastSquaresProblem) {
        int n = leastSquaresProblem.getObservationSize();
        int n2 = leastSquaresProblem.getParameterSize();
        Incrementor incrementor = leastSquaresProblem.getIterationCounter();
        Incrementor incrementor2 = leastSquaresProblem.getEvaluationCounter();
        ConvergenceChecker<LeastSquaresProblem$Evaluation> convergenceChecker = leastSquaresProblem.getConvergenceChecker();
        int n3 = FastMath.min(n, n2);
        double[] dArray = new double[n2];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] cfr_ignored_0 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        incrementor2.incrementCount();
        LeastSquaresProblem leastSquaresProblem2 = leastSquaresProblem;
        LeastSquaresProblem$Evaluation leastSquaresProblem$Evaluation = leastSquaresProblem2.evaluate(leastSquaresProblem2.getStart());
        double[] dArray8 = leastSquaresProblem$Evaluation.getResiduals().toArray();
        double d5 = leastSquaresProblem$Evaluation.getCost();
        double[] dArray9 = leastSquaresProblem$Evaluation.getPoint().toArray();
        boolean bl = true;
        block0: while (true) {
            double d6;
            int n4;
            int n5;
            incrementor.incrementCount();
            LeastSquaresProblem$Evaluation leastSquaresProblem$Evaluation2 = leastSquaresProblem$Evaluation;
            LevenbergMarquardtOptimizer$InternalData levenbergMarquardtOptimizer$InternalData = this.qrDecomposition(leastSquaresProblem$Evaluation.getJacobian(), n3);
            double[][] dArray10 = LevenbergMarquardtOptimizer$InternalData.access$000(levenbergMarquardtOptimizer$InternalData);
            int[] nArray = LevenbergMarquardtOptimizer$InternalData.access$100(levenbergMarquardtOptimizer$InternalData);
            double[] dArray11 = LevenbergMarquardtOptimizer$InternalData.access$200(levenbergMarquardtOptimizer$InternalData);
            double[] dArray12 = LevenbergMarquardtOptimizer$InternalData.access$300(levenbergMarquardtOptimizer$InternalData);
            double[] dArray13 = dArray8;
            for (n5 = 0; n5 < n; ++n5) {
                dArray4[n5] = dArray13[n5];
            }
            this.qTy(dArray4, levenbergMarquardtOptimizer$InternalData);
            for (n5 = 0; n5 < n3; ++n5) {
                int n6 = nArray[n5];
                dArray10[n5][n6] = dArray11[n6];
            }
            if (bl) {
                d4 = 0.0;
                for (n5 = 0; n5 < n2; ++n5) {
                    double d7;
                    double d8 = dArray12[n5];
                    if (d8 == 0.0) {
                        d8 = 1.0;
                    }
                    double d9 = d7 = d8 * dArray9[n5];
                    d4 += d9 * d9;
                    dArray2[n5] = d8;
                }
                d3 = (d4 = FastMath.sqrt(d4)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * d4;
            }
            double d10 = 0.0;
            if (d5 != 0.0) {
                for (n4 = 0; n4 < n3; ++n4) {
                    int n7 = nArray[n4];
                    d6 = dArray12[n7];
                    if (d6 == 0.0) continue;
                    double d11 = 0.0;
                    for (int i2 = 0; i2 <= n4; ++i2) {
                        d11 += dArray10[i2][n7] * dArray4[i2];
                    }
                    d10 = FastMath.max(d10, FastMath.abs(d11) / (d6 * d5));
                }
            }
            if (d10 <= this.orthoTolerance) {
                return new OptimumImpl(leastSquaresProblem$Evaluation, incrementor2.getCount(), incrementor.getCount());
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray2[n4] = FastMath.max(dArray2[n4], dArray12[n4]);
            }
            double d12 = 0.0;
            do {
                int n8;
                double d13;
                double d14;
                if (!(d12 < 1.0E-4)) continue block0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n9 = nArray[i3];
                    dArray3[n9] = dArray9[n9];
                }
                d6 = d5;
                d2 = this.determineLMParameter(dArray4, d3, dArray2, levenbergMarquardtOptimizer$InternalData, n3, dArray5, dArray6, dArray7, dArray, d2);
                double d15 = 0.0;
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n10 = nArray[i4];
                    dArray[n10] = -dArray[n10];
                    dArray9[n10] = dArray3[n10] + dArray[n10];
                    double d16 = d14 = dArray2[n10] * dArray[n10];
                    d15 += d16 * d16;
                }
                d15 = FastMath.sqrt(d15);
                if (bl) {
                    d3 = FastMath.min(d3, d15);
                }
                incrementor2.incrementCount();
                leastSquaresProblem$Evaluation = leastSquaresProblem.evaluate(new ArrayRealVector(dArray9));
                dArray8 = leastSquaresProblem$Evaluation.getResiduals().toArray();
                d5 = leastSquaresProblem$Evaluation.getCost();
                dArray9 = leastSquaresProblem$Evaluation.getPoint().toArray();
                double d17 = -1.0;
                if (d5 * 0.1 < d6) {
                    double d18 = d14 = d5 / d6;
                    d17 = 1.0 - d18 * d18;
                }
                for (int i5 = 0; i5 < n3; ++i5) {
                    int n11 = nArray[i5];
                    d13 = dArray[n11];
                    dArray5[i5] = 0.0;
                    for (int i6 = 0; i6 <= i5; ++i6) {
                        int n12 = i6;
                        dArray5[n12] = dArray5[n12] + dArray10[i6][n11] * d13;
                    }
                }
                d14 = 0.0;
                for (int i7 = 0; i7 < n3; ++i7) {
                    d14 += dArray5[i7] * dArray5[i7];
                }
                double d19 = d6;
                d13 = d19 * d19;
                double d20 = d2 * d15 * d15 / d13;
                double d21 = (d14 /= d13) + d20 * 2.0;
                double d22 = -(d14 + d20);
                double d23 = d12 = d21 == 0.0 ? 0.0 : d17 / d21;
                if (d23 <= 0.25) {
                    double d24;
                    double d25 = d24 = d17 < 0.0 ? d22 * 0.5 / (d22 + d17 * 0.5) : 0.5;
                    if (d5 * 0.1 >= d6 || d24 < 0.1) {
                        d24 = 0.1;
                    }
                    d3 = d24 * FastMath.min(d3, d15 * 10.0);
                    d2 /= d24;
                } else if (d2 == 0.0 || d12 >= 0.75) {
                    d3 = d15 * 2.0;
                    d2 *= 0.5;
                }
                if (d12 >= 1.0E-4) {
                    bl = false;
                    d4 = 0.0;
                    for (n8 = 0; n8 < n2; ++n8) {
                        double d26;
                        double d27 = d26 = dArray2[n8] * dArray9[n8];
                        d4 += d27 * d27;
                    }
                    d4 = FastMath.sqrt(d4);
                    if (convergenceChecker != null && convergenceChecker.converged(incrementor.getCount(), leastSquaresProblem$Evaluation2, leastSquaresProblem$Evaluation)) {
                        return new OptimumImpl(leastSquaresProblem$Evaluation, incrementor2.getCount(), incrementor.getCount());
                    }
                } else {
                    d5 = d6;
                    for (n8 = 0; n8 < n3; ++n8) {
                        int n13 = nArray[n8];
                        dArray9[n13] = dArray3[n13];
                    }
                    leastSquaresProblem$Evaluation = leastSquaresProblem$Evaluation2;
                }
                if (FastMath.abs(d17) <= this.costRelativeTolerance && d21 <= this.costRelativeTolerance && d12 <= 2.0 || d3 <= this.parRelativeTolerance * d4) {
                    return new OptimumImpl(leastSquaresProblem$Evaluation, incrementor2.getCount(), incrementor.getCount());
                }
                if (FastMath.abs(d17) <= TWO_EPS && d21 <= TWO_EPS && d12 <= 2.0) {
                    throw new ConvergenceException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(d3 <= TWO_EPS * d4)) continue;
                throw new ConvergenceException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(d10 <= TWO_EPS));
            break;
        }
        throw new ConvergenceException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private double determineLMParameter(double[] dArray, double d2, double[] dArray2, LevenbergMarquardtOptimizer$InternalData levenbergMarquardtOptimizer$InternalData, int n, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double d3) {
        double d4;
        int n2;
        int n3;
        double d5;
        int n4;
        double[][] dArray7 = LevenbergMarquardtOptimizer$InternalData.access$000(levenbergMarquardtOptimizer$InternalData);
        int[] nArray = LevenbergMarquardtOptimizer$InternalData.access$100(levenbergMarquardtOptimizer$InternalData);
        int n5 = LevenbergMarquardtOptimizer$InternalData.access$400(levenbergMarquardtOptimizer$InternalData);
        double[] dArray8 = LevenbergMarquardtOptimizer$InternalData.access$200(levenbergMarquardtOptimizer$InternalData);
        int n6 = dArray7[0].length;
        for (n4 = 0; n4 < n5; ++n4) {
            dArray6[nArray[n4]] = dArray[n4];
        }
        for (n4 = n5; n4 < n6; ++n4) {
            dArray6[nArray[n4]] = 0.0;
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            int n7 = nArray[n4];
            double d6 = dArray6[n7] / dArray8[n7];
            for (int i2 = 0; i2 < n4; ++i2) {
                int n8 = nArray[i2];
                dArray6[n8] = dArray6[n8] - d6 * dArray7[i2][n7];
            }
            dArray6[n7] = d6;
        }
        double d7 = 0.0;
        for (int i3 = 0; i3 < n; ++i3) {
            double d8;
            int n9 = nArray[i3];
            dArray3[n9] = d8 = dArray2[n9] * dArray6[n9];
            double d9 = d8;
            d7 += d9 * d9;
        }
        d7 = FastMath.sqrt(d7);
        double d10 = d7 - d2;
        if (d5 <= d2 * 0.1) {
            return 0.0;
        }
        double d11 = 0.0;
        if (n5 == n) {
            for (n3 = 0; n3 < n; ++n3) {
                int n10 = n2 = nArray[n3];
                dArray3[n10] = dArray3[n10] * (dArray2[n2] / d7);
            }
            double d12 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                double d13;
                n2 = nArray[n3];
                d4 = 0.0;
                for (int i4 = 0; i4 < n3; ++i4) {
                    d4 += dArray7[i4][n2] * dArray3[nArray[i4]];
                }
                dArray3[n2] = d13 = (dArray3[n2] - d4) / dArray8[n2];
                double d14 = d13;
                d12 += d14 * d14;
            }
            d11 = d10 / (d2 * d12);
        }
        double d15 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            d4 = 0.0;
            for (int i5 = 0; i5 <= n3; ++i5) {
                d4 += dArray7[i5][n2] * dArray[i5];
            }
            double d16 = d4 /= dArray2[n2];
            d15 += d16 * d16;
        }
        double d17 = FastMath.sqrt(d15);
        d4 = d17 / d2;
        if (d4 == 0.0) {
            d4 = Precision.SAFE_MIN / FastMath.min(d2, 0.1);
        }
        if ((d3 = FastMath.min(d4, FastMath.max(d3, d11))) == 0.0) {
            d3 = d17 / d7;
        }
        for (int i6 = 10; i6 >= 0; --i6) {
            int n11;
            int n12;
            double d18;
            int n13;
            int n14;
            if (d3 == 0.0) {
                d3 = FastMath.max(Precision.SAFE_MIN, d4 * 0.001);
            }
            double d19 = FastMath.sqrt(d3);
            for (n14 = 0; n14 < n; ++n14) {
                n13 = nArray[n14];
                dArray3[n13] = d19 * dArray2[n13];
            }
            this.determineLMDirection(dArray, dArray3, dArray4, levenbergMarquardtOptimizer$InternalData, n, dArray5, dArray6);
            d7 = 0.0;
            for (n14 = 0; n14 < n; ++n14) {
                n13 = nArray[n14];
                dArray5[n13] = d18 = dArray2[n13] * dArray6[n13];
                double d20 = d18;
                d7 += d20 * d20;
            }
            d7 = FastMath.sqrt(d7);
            double d21 = d10;
            d10 = d7 - d2;
            if (FastMath.abs(d10) <= d2 * 0.1 || d11 == 0.0 && d10 <= d21 && d21 < 0.0) {
                return d3;
            }
            for (n12 = 0; n12 < n; ++n12) {
                n11 = nArray[n12];
                dArray3[n11] = dArray5[n11] * dArray2[n11] / d7;
            }
            for (n12 = 0; n12 < n; ++n12) {
                int n15 = n11 = nArray[n12];
                dArray3[n15] = dArray3[n15] / dArray4[n12];
                double d22 = dArray3[n11];
                for (n5 = n12 + 1; n5 < n; ++n5) {
                    int n16 = nArray[n5];
                    dArray3[n16] = dArray3[n16] - dArray7[n5][n11] * d22;
                }
            }
            d15 = 0.0;
            for (n12 = 0; n12 < n; ++n12) {
                double d23;
                double d24 = d23 = dArray3[nArray[n12]];
                d15 += d24 * d24;
            }
            d18 = d10 / (d2 * d15);
            if (d10 > 0.0) {
                d11 = FastMath.max(d11, d3);
            } else if (d10 < 0.0) {
                d4 = FastMath.min(d4, d3);
            }
            d3 = FastMath.max(d11, d3 + d18);
        }
        return d3;
    }

    private void determineLMDirection(double[] dArray, double[] dArray2, double[] dArray3, LevenbergMarquardtOptimizer$InternalData object, int n, double[] dArray4, double[] dArray5) {
        int n2;
        int n3;
        int[] nArray = LevenbergMarquardtOptimizer$InternalData.access$100((LevenbergMarquardtOptimizer$InternalData)object);
        double[][] dArray6 = LevenbergMarquardtOptimizer$InternalData.access$000((LevenbergMarquardtOptimizer$InternalData)object);
        object = LevenbergMarquardtOptimizer$InternalData.access$200((LevenbergMarquardtOptimizer$InternalData)object);
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            for (int i2 = n3 + 1; i2 < n; ++i2) {
                dArray6[i2][n2] = dArray6[n3][nArray[i2]];
            }
            dArray5[n3] = (double)object[n2];
            dArray4[n3] = dArray[n3];
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            double d2 = dArray2[n2];
            if (d2 != 0.0) {
                Arrays.fill(dArray3, n3 + 1, dArray3.length, 0.0);
            }
            dArray3[n3] = d2;
            double d3 = 0.0;
            for (int i3 = n3; i3 < n; ++i3) {
                double d4;
                double d5;
                double d6;
                double d7;
                int n4 = nArray[i3];
                if (dArray3[i3] == 0.0) continue;
                double d8 = dArray6[i3][n4];
                if (FastMath.abs(d7) < FastMath.abs(dArray3[i3])) {
                    double d9 = d6 = d8 / dArray3[i3];
                    d5 = 1.0 / FastMath.sqrt(1.0 + d9 * d9);
                    d4 = d5 * d6;
                } else {
                    double d10 = d6 = dArray3[i3] / d8;
                    d4 = 1.0 / FastMath.sqrt(1.0 + d10 * d10);
                    d5 = d4 * d6;
                }
                dArray6[i3][n4] = d4 * d8 + d5 * dArray3[i3];
                d6 = d4 * dArray4[i3] + d5 * d3;
                d3 = -d5 * dArray4[i3] + d4 * d3;
                dArray4[i3] = d6;
                for (n2 = i3 + 1; n2 < n; ++n2) {
                    double d11 = dArray6[n2][n4];
                    double d12 = d4 * d11 + d5 * dArray3[n2];
                    dArray3[n2] = -d5 * d11 + d4 * dArray3[n2];
                    dArray6[n2][n4] = d12;
                }
            }
            dArray3[n3] = dArray6[n3][nArray[n3]];
            dArray6[n3][nArray[n3]] = dArray5[n3];
        }
        n3 = n;
        for (n2 = 0; n2 < n; ++n2) {
            if (dArray3[n2] == 0.0 && n3 == n) {
                n3 = n2;
            }
            if (n3 >= n) continue;
            dArray4[n2] = 0.0;
        }
        if (n3 > 0) {
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                int n5 = nArray[n2];
                double d13 = 0.0;
                for (int i4 = n2 + 1; i4 < n3; ++i4) {
                    d13 += dArray6[i4][n5] * dArray4[i4];
                }
                dArray4[n2] = (dArray4[n2] - d13) / dArray3[n2];
            }
        }
        for (n2 = 0; n2 < dArray5.length; ++n2) {
            dArray5[nArray[n2]] = dArray4[n2];
        }
    }

    private LevenbergMarquardtOptimizer$InternalData qrDecomposition(RealMatrix object, int n) {
        int n2;
        double[][] dArray = object.scalarMultiply(-1.0).getData();
        object = dArray;
        int n3 = dArray.length;
        int n4 = ((Object)object[0]).length;
        int[] nArray = new int[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = n2;
            nArray[n5] = n5;
            double d2 = 0.0;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object2;
                Object object3 = object2 = object[i2][n2];
                d2 += object3 * object3;
            }
            dArray3[n2] = FastMath.sqrt(d2);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            double d3;
            Object object4;
            int n6;
            int n7 = -1;
            double d4 = Double.NEGATIVE_INFINITY;
            for (n6 = n2; n6 < n4; ++n6) {
                object4 = 0.0;
                for (int i3 = n2; i3 < n3; ++i3) {
                    Object object5;
                    Object object6 = object5 = object[i3][nArray[n6]];
                    object4 += object6 * object6;
                }
                if (Double.isInfinite(object4) || Double.isNaN(object4)) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, n3, n4);
                }
                if (!(object4 > d4)) continue;
                n7 = n6;
                d4 = object4;
            }
            if (d4 <= this.qrRankingThreshold) {
                return new LevenbergMarquardtOptimizer$InternalData((double[][])object, nArray, n2, dArray2, dArray3, dArray4);
            }
            n6 = nArray[n7];
            nArray[n7] = nArray[n2];
            nArray[n2] = n6;
            Object object7 = object[n2][n6];
            object4 = object7;
            double d5 = object7 > 0.0 ? -FastMath.sqrt(d4) : FastMath.sqrt(d4);
            dArray4[n6] = d3 = 1.0 / (d4 - object4 * d5);
            dArray2[n6] = d5;
            Object object8 = object[n2];
            int n8 = n6;
            object8[n8] = object8[n8] - d5;
            for (int i4 = n4 - 1 - n2; i4 > 0; --i4) {
                double d6 = 0.0;
                for (n7 = n2; n7 < n3; ++n7) {
                    d6 += object[n7][n6] * object[n7][nArray[n2 + i4]];
                }
                d6 *= d3;
                for (n7 = n2; n7 < n3; ++n7) {
                    Object object9 = object[n7];
                    int n9 = nArray[n2 + i4];
                    object9[n9] = object9[n9] - d6 * object[n7][n6];
                }
            }
        }
        return new LevenbergMarquardtOptimizer$InternalData((double[][])object, nArray, n, dArray2, dArray3, dArray4);
    }

    private void qTy(double[] dArray, LevenbergMarquardtOptimizer$InternalData object) {
        double[][] dArray2 = LevenbergMarquardtOptimizer$InternalData.access$000((LevenbergMarquardtOptimizer$InternalData)object);
        int[] nArray = LevenbergMarquardtOptimizer$InternalData.access$100((LevenbergMarquardtOptimizer$InternalData)object);
        object = LevenbergMarquardtOptimizer$InternalData.access$500((LevenbergMarquardtOptimizer$InternalData)object);
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = nArray[i2];
            double d2 = 0.0;
            for (n3 = i2; n3 < n; ++n3) {
                d2 += dArray2[n3][n4] * dArray[n3];
            }
            d2 *= object[n4];
            for (n3 = i2; n3 < n; ++n3) {
                int n5 = n3;
                dArray[n5] = dArray[n5] - d2 * dArray2[n3][n4];
            }
        }
    }
}

