/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateMatrixFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory$3;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory$LocalLeastSquaresProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory$LocalValueAndJacobianFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem$Evaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.ParameterValidator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DiagonalMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.EigenDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointVectorValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Incrementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeastSquaresFactory {
    private LeastSquaresFactory() {
    }

    public static LeastSquaresProblem create(MultivariateJacobianFunction object, RealVector realVector, RealVector realVector2, RealMatrix realMatrix, ConvergenceChecker<LeastSquaresProblem$Evaluation> convergenceChecker, int n, int n2, boolean bl, ParameterValidator parameterValidator) {
        object = new LeastSquaresFactory$LocalLeastSquaresProblem((MultivariateJacobianFunction)object, realVector, realVector2, convergenceChecker, n, n2, bl, parameterValidator);
        if (realMatrix != null) {
            return LeastSquaresFactory.weightMatrix((LeastSquaresProblem)object, realMatrix);
        }
        return object;
    }

    public static LeastSquaresProblem create(MultivariateJacobianFunction multivariateJacobianFunction, RealVector realVector, RealVector realVector2, ConvergenceChecker<LeastSquaresProblem$Evaluation> convergenceChecker, int n, int n2) {
        return LeastSquaresFactory.create(multivariateJacobianFunction, realVector, realVector2, null, convergenceChecker, n, n2, false, null);
    }

    public static LeastSquaresProblem create(MultivariateJacobianFunction multivariateJacobianFunction, RealVector realVector, RealVector realVector2, RealMatrix realMatrix, ConvergenceChecker<LeastSquaresProblem$Evaluation> convergenceChecker, int n, int n2) {
        return LeastSquaresFactory.weightMatrix(LeastSquaresFactory.create(multivariateJacobianFunction, realVector, realVector2, convergenceChecker, n, n2), realMatrix);
    }

    public static LeastSquaresProblem create(MultivariateVectorFunction multivariateVectorFunction, MultivariateMatrixFunction multivariateMatrixFunction, double[] dArray, double[] dArray2, RealMatrix realMatrix, ConvergenceChecker<LeastSquaresProblem$Evaluation> convergenceChecker, int n, int n2) {
        return LeastSquaresFactory.create(LeastSquaresFactory.model(multivariateVectorFunction, multivariateMatrixFunction), new ArrayRealVector(dArray, false), new ArrayRealVector(dArray2, false), realMatrix, convergenceChecker, n, n2);
    }

    public static LeastSquaresProblem weightMatrix(LeastSquaresProblem leastSquaresProblem, RealMatrix realMatrix) {
        realMatrix = LeastSquaresFactory.squareRoot(realMatrix);
        return new LeastSquaresFactory$1(leastSquaresProblem, realMatrix);
    }

    public static LeastSquaresProblem weightDiagonal(LeastSquaresProblem leastSquaresProblem, RealVector realVector) {
        return LeastSquaresFactory.weightMatrix(leastSquaresProblem, new DiagonalMatrix(realVector.toArray()));
    }

    public static LeastSquaresProblem countEvaluations(LeastSquaresProblem leastSquaresProblem, Incrementor incrementor) {
        return new LeastSquaresFactory$2(leastSquaresProblem, incrementor);
    }

    public static ConvergenceChecker<LeastSquaresProblem$Evaluation> evaluationChecker(ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        return new LeastSquaresFactory$3(convergenceChecker);
    }

    private static RealMatrix squareRoot(RealMatrix realMatrix) {
        if (realMatrix instanceof DiagonalMatrix) {
            int n = realMatrix.getRowDimension();
            DiagonalMatrix diagonalMatrix = new DiagonalMatrix(n);
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                int n4 = n2++;
                diagonalMatrix.setEntry(n3, n3, FastMath.sqrt(realMatrix.getEntry(n4, n4)));
            }
            return diagonalMatrix;
        }
        EigenDecomposition eigenDecomposition = new EigenDecomposition(realMatrix);
        return eigenDecomposition.getSquareRoot();
    }

    public static MultivariateJacobianFunction model(MultivariateVectorFunction multivariateVectorFunction, MultivariateMatrixFunction multivariateMatrixFunction) {
        return new LeastSquaresFactory$LocalValueAndJacobianFunction(multivariateVectorFunction, multivariateMatrixFunction);
    }
}

