/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory$LocalLeastSquaresProblem$LazyUnweightedEvaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory$LocalLeastSquaresProblem$UnweightedEvaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem$Evaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.ParameterValidator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.ValueAndJacobianFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.AbstractOptimizationProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeastSquaresFactory$LocalLeastSquaresProblem
extends AbstractOptimizationProblem<LeastSquaresProblem$Evaluation>
implements LeastSquaresProblem {
    private final RealVector target;
    private final MultivariateJacobianFunction model;
    private final RealVector start;
    private final boolean lazyEvaluation;
    private final ParameterValidator paramValidator;

    LeastSquaresFactory$LocalLeastSquaresProblem(MultivariateJacobianFunction multivariateJacobianFunction, RealVector realVector, RealVector realVector2, ConvergenceChecker<LeastSquaresProblem$Evaluation> convergenceChecker, int n, int n2, boolean bl, ParameterValidator parameterValidator) {
        super(n, n2, convergenceChecker);
        this.target = realVector;
        this.model = multivariateJacobianFunction;
        this.start = realVector2;
        this.lazyEvaluation = bl;
        this.paramValidator = parameterValidator;
        if (bl && !(multivariateJacobianFunction instanceof ValueAndJacobianFunction)) {
            throw new MathIllegalStateException(LocalizedFormats.INVALID_IMPLEMENTATION, multivariateJacobianFunction.getClass().getName());
        }
    }

    @Override
    public int getObservationSize() {
        return this.target.getDimension();
    }

    @Override
    public int getParameterSize() {
        return this.start.getDimension();
    }

    @Override
    public RealVector getStart() {
        if (this.start == null) {
            return null;
        }
        return this.start.copy();
    }

    @Override
    public LeastSquaresProblem$Evaluation evaluate(RealVector realVector) {
        RealVector realVector2 = realVector = this.paramValidator == null ? realVector.copy() : this.paramValidator.validate(realVector.copy());
        if (this.lazyEvaluation) {
            return new LeastSquaresFactory$LocalLeastSquaresProblem$LazyUnweightedEvaluation((ValueAndJacobianFunction)this.model, this.target, realVector, null);
        }
        Pair<RealVector, RealMatrix> pair = this.model.value(realVector);
        return new LeastSquaresFactory$LocalLeastSquaresProblem$UnweightedEvaluation(pair.getFirst(), pair.getSecond(), this.target, realVector, null);
    }
}

