/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateMatrixFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem$Evaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.ParameterValidator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointVectorValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeastSquaresBuilder {
    private int maxEvaluations;
    private int maxIterations;
    private ConvergenceChecker<LeastSquaresProblem$Evaluation> checker;
    private MultivariateJacobianFunction model;
    private RealVector target;
    private RealVector start;
    private RealMatrix weight;
    private boolean lazyEvaluation;
    private ParameterValidator paramValidator;

    public LeastSquaresProblem build() {
        return LeastSquaresFactory.create(this.model, this.target, this.start, this.weight, this.checker, this.maxEvaluations, this.maxIterations, this.lazyEvaluation, this.paramValidator);
    }

    public LeastSquaresBuilder maxEvaluations(int n) {
        this.maxEvaluations = n;
        return this;
    }

    public LeastSquaresBuilder maxIterations(int n) {
        this.maxIterations = n;
        return this;
    }

    public LeastSquaresBuilder checker(ConvergenceChecker<LeastSquaresProblem$Evaluation> convergenceChecker) {
        this.checker = convergenceChecker;
        return this;
    }

    public LeastSquaresBuilder checkerPair(ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        return this.checker(LeastSquaresFactory.evaluationChecker(convergenceChecker));
    }

    public LeastSquaresBuilder model(MultivariateVectorFunction multivariateVectorFunction, MultivariateMatrixFunction multivariateMatrixFunction) {
        return this.model(LeastSquaresFactory.model(multivariateVectorFunction, multivariateMatrixFunction));
    }

    public LeastSquaresBuilder model(MultivariateJacobianFunction multivariateJacobianFunction) {
        this.model = multivariateJacobianFunction;
        return this;
    }

    public LeastSquaresBuilder target(RealVector realVector) {
        this.target = realVector;
        return this;
    }

    public LeastSquaresBuilder target(double[] dArray) {
        return this.target(new ArrayRealVector(dArray, false));
    }

    public LeastSquaresBuilder start(RealVector realVector) {
        this.start = realVector;
        return this;
    }

    public LeastSquaresBuilder start(double[] dArray) {
        return this.start(new ArrayRealVector(dArray, false));
    }

    public LeastSquaresBuilder weight(RealMatrix realMatrix) {
        this.weight = realMatrix;
        return this;
    }

    public LeastSquaresBuilder lazyEvaluation(boolean bl) {
        this.lazyEvaluation = bl;
        return this;
    }

    public LeastSquaresBuilder parameterValidator(ParameterValidator parameterValidator) {
        this.paramValidator = parameterValidator;
        return this;
    }
}

