/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.GaussNewtonOptimizer$Decomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer$Optimum;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem$Evaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.OptimumImpl;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Incrementor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussNewtonOptimizer
implements LeastSquaresOptimizer {
    private static final double SINGULARITY_THRESHOLD = 1.0E-11;
    private final GaussNewtonOptimizer$Decomposition decomposition;

    public GaussNewtonOptimizer() {
        this(GaussNewtonOptimizer$Decomposition.QR);
    }

    public GaussNewtonOptimizer(GaussNewtonOptimizer$Decomposition gaussNewtonOptimizer$Decomposition) {
        this.decomposition = gaussNewtonOptimizer$Decomposition;
    }

    public GaussNewtonOptimizer$Decomposition getDecomposition() {
        return this.decomposition;
    }

    public GaussNewtonOptimizer withDecomposition(GaussNewtonOptimizer$Decomposition gaussNewtonOptimizer$Decomposition) {
        return new GaussNewtonOptimizer(gaussNewtonOptimizer$Decomposition);
    }

    @Override
    public LeastSquaresOptimizer$Optimum optimize(LeastSquaresProblem leastSquaresProblem) {
        Incrementor incrementor = leastSquaresProblem.getEvaluationCounter();
        Incrementor incrementor2 = leastSquaresProblem.getIterationCounter();
        ConvergenceChecker<LeastSquaresProblem$Evaluation> convergenceChecker = leastSquaresProblem.getConvergenceChecker();
        if (convergenceChecker == null) {
            throw new NullArgumentException();
        }
        RealVector realVector = leastSquaresProblem.getStart();
        LeastSquaresProblem$Evaluation leastSquaresProblem$Evaluation = null;
        while (true) {
            incrementor2.incrementCount();
            Object object = leastSquaresProblem$Evaluation;
            incrementor.incrementCount();
            leastSquaresProblem$Evaluation = leastSquaresProblem.evaluate(realVector);
            RealVector realVector2 = leastSquaresProblem$Evaluation.getResiduals();
            RealMatrix realMatrix = leastSquaresProblem$Evaluation.getJacobian();
            realVector = leastSquaresProblem$Evaluation.getPoint();
            if (object != null && convergenceChecker.converged(incrementor2.getCount(), (LeastSquaresProblem$Evaluation)object, leastSquaresProblem$Evaluation)) {
                return new OptimumImpl(leastSquaresProblem$Evaluation, incrementor.getCount(), incrementor2.getCount());
            }
            object = this.decomposition.solve(realMatrix, realVector2);
            realVector = realVector.add((RealVector)object);
        }
    }

    public String toString() {
        return "GaussNewtonOptimizer{decomposition=" + (Object)((Object)this.decomposition) + '}';
    }

    private static Pair<RealMatrix, RealVector> computeNormalMatrix(RealMatrix realMatrix, RealVector realVector) {
        int n;
        int n2;
        int n3 = realMatrix.getRowDimension();
        int n4 = realMatrix.getColumnDimension();
        RealMatrix realMatrix2 = MatrixUtils.createRealMatrix(n4, n4);
        ArrayRealVector arrayRealVector = new ArrayRealVector(n4);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                ((RealVector)arrayRealVector).setEntry(n, ((RealVector)arrayRealVector).getEntry(n) + realVector.getEntry(n2) * realMatrix.getEntry(n2, n));
            }
            for (n = 0; n < n4; ++n) {
                for (int i2 = n; i2 < n4; ++i2) {
                    realMatrix2.setEntry(n, i2, realMatrix2.getEntry(n, i2) + realMatrix.getEntry(n2, n) * realMatrix.getEntry(n2, i2));
                }
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n2; ++n) {
                realMatrix2.setEntry(n2, n, realMatrix2.getEntry(n, n2));
            }
        }
        return new Pair<RealMatrix, RealVector>(realMatrix2, arrayRealVector);
    }

    static /* synthetic */ Pair access$100(RealMatrix realMatrix, RealVector realVector) {
        return GaussNewtonOptimizer.computeNormalMatrix(realMatrix, realVector);
    }
}

