/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem$Evaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.QRDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public abstract class AbstractEvaluation
implements LeastSquaresProblem$Evaluation {
    private final int observationSize;

    AbstractEvaluation(int n) {
        this.observationSize = n;
    }

    public RealMatrix getCovariances(double d2) {
        RealMatrix realMatrix = this.getJacobian();
        realMatrix = realMatrix.transpose().multiply(realMatrix);
        DecompositionSolver decompositionSolver = new QRDecomposition(realMatrix, d2).getSolver();
        return decompositionSolver.getInverse();
    }

    public RealVector getSigma(double d2) {
        RealMatrix realMatrix = this.getCovariances(d2);
        int n = realMatrix.getColumnDimension();
        ArrayRealVector arrayRealVector = new ArrayRealVector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = i2;
            ((RealVector)arrayRealVector).setEntry(i2, FastMath.sqrt(realMatrix.getEntry(n2, n2)));
        }
        return arrayRealVector;
    }

    public double getRMS() {
        double d2 = this.getCost();
        return FastMath.sqrt(d2 * d2 / (double)this.observationSize);
    }

    public double getCost() {
        ArrayRealVector arrayRealVector = new ArrayRealVector(this.getResiduals());
        return FastMath.sqrt(((RealVector)arrayRealVector).dotProduct(arrayRealVector));
    }
}

