/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.ParametricUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.AbstractCurveFitter;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.AbstractCurveFitter$TheoreticalValuesFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.WeightedObservedPoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DiagonalMatrix;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCurveFitter
extends AbstractCurveFitter {
    private final ParametricUnivariateFunction function;
    private final double[] initialGuess;
    private final int maxIter;

    private SimpleCurveFitter(ParametricUnivariateFunction parametricUnivariateFunction, double[] dArray, int n) {
        this.function = parametricUnivariateFunction;
        this.initialGuess = dArray;
        this.maxIter = n;
    }

    public static SimpleCurveFitter create(ParametricUnivariateFunction parametricUnivariateFunction, double[] dArray) {
        return new SimpleCurveFitter(parametricUnivariateFunction, dArray, Integer.MAX_VALUE);
    }

    public SimpleCurveFitter withStartPoint(double[] dArray) {
        return new SimpleCurveFitter(this.function, (double[])dArray.clone(), this.maxIter);
    }

    public SimpleCurveFitter withMaxIterations(int n) {
        return new SimpleCurveFitter(this.function, this.initialGuess, n);
    }

    @Override
    protected LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> collection) {
        int n = collection.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (WeightedObservedPoint weightedObservedPoint : collection) {
            dArray[n2] = weightedObservedPoint.getY();
            dArray2[n2] = weightedObservedPoint.getWeight();
            ++n2;
        }
        AbstractCurveFitter$TheoreticalValuesFunction abstractCurveFitter$TheoreticalValuesFunction = new AbstractCurveFitter$TheoreticalValuesFunction(this.function, collection);
        return new LeastSquaresBuilder().maxEvaluations(Integer.MAX_VALUE).maxIterations(this.maxIter).start(this.initialGuess).target(dArray).weight(new DiagonalMatrix(dArray2)).model(abstractCurveFitter$TheoreticalValuesFunction.getModelFunction(), abstractCurveFitter$TheoreticalValuesFunction.getModelFunctionJacobian()).build();
    }
}

