/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialFunction$Parametric;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.AbstractCurveFitter;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.AbstractCurveFitter$TheoreticalValuesFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.WeightedObservedPoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DiagonalMatrix;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynomialCurveFitter
extends AbstractCurveFitter {
    private static final PolynomialFunction$Parametric FUNCTION = new PolynomialFunction$Parametric();
    private final double[] initialGuess;
    private final int maxIter;

    private PolynomialCurveFitter(double[] dArray, int n) {
        this.initialGuess = dArray;
        this.maxIter = n;
    }

    public static PolynomialCurveFitter create(int n) {
        return new PolynomialCurveFitter(new double[n + 1], Integer.MAX_VALUE);
    }

    public PolynomialCurveFitter withStartPoint(double[] dArray) {
        return new PolynomialCurveFitter((double[])dArray.clone(), this.maxIter);
    }

    public PolynomialCurveFitter withMaxIterations(int n) {
        return new PolynomialCurveFitter(this.initialGuess, n);
    }

    @Override
    protected LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> collection) {
        int n = collection.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (WeightedObservedPoint weightedObservedPoint : collection) {
            dArray[n2] = weightedObservedPoint.getY();
            dArray2[n2] = weightedObservedPoint.getWeight();
            ++n2;
        }
        AbstractCurveFitter$TheoreticalValuesFunction abstractCurveFitter$TheoreticalValuesFunction = new AbstractCurveFitter$TheoreticalValuesFunction(FUNCTION, collection);
        if (this.initialGuess == null) {
            throw new MathInternalError();
        }
        return new LeastSquaresBuilder().maxEvaluations(Integer.MAX_VALUE).maxIterations(this.maxIter).start(this.initialGuess).target(dArray).weight(new DiagonalMatrix(dArray2)).model(abstractCurveFitter$TheoreticalValuesFunction.getModelFunction(), abstractCurveFitter$TheoreticalValuesFunction.getModelFunctionJacobian()).build();
    }
}

