/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.WeightedObservedPoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class HarmonicFitter$ParameterGuesser {
    private final double a;
    private final double omega;
    private final double phi;

    public HarmonicFitter$ParameterGuesser(WeightedObservedPoint[] weightedObservedPointArray) {
        if (weightedObservedPointArray.length < 4) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, (Number)weightedObservedPointArray.length, 4, true);
        }
        weightedObservedPointArray = this.sortObservations(weightedObservedPointArray);
        double[] dArray = this.guessAOmega(weightedObservedPointArray);
        this.a = dArray[0];
        this.omega = dArray[1];
        this.phi = this.guessPhi(weightedObservedPointArray);
    }

    public double[] guess() {
        return new double[]{this.a, this.omega, this.phi};
    }

    private WeightedObservedPoint[] sortObservations(WeightedObservedPoint[] weightedObservedPointArray) {
        weightedObservedPointArray = (WeightedObservedPoint[])weightedObservedPointArray.clone();
        WeightedObservedPoint weightedObservedPoint = weightedObservedPointArray[0];
        for (int i2 = 1; i2 < weightedObservedPointArray.length; ++i2) {
            WeightedObservedPoint weightedObservedPoint2;
            WeightedObservedPoint weightedObservedPoint3 = weightedObservedPoint;
            weightedObservedPoint = weightedObservedPointArray[i2];
            if (!(weightedObservedPoint2.getX() < weightedObservedPoint3.getX())) continue;
            int n = i2 - 1;
            WeightedObservedPoint weightedObservedPoint4 = weightedObservedPointArray[n];
            while (n >= 0 && weightedObservedPoint.getX() < weightedObservedPoint4.getX()) {
                weightedObservedPointArray[n + 1] = weightedObservedPoint4;
                if (n-- == 0) continue;
                weightedObservedPoint4 = weightedObservedPointArray[n];
            }
            weightedObservedPointArray[n + 1] = weightedObservedPoint;
            weightedObservedPoint = weightedObservedPointArray[i2];
        }
        return weightedObservedPointArray;
    }

    private double[] guessAOmega(WeightedObservedPoint[] weightedObservedPointArray) {
        double d2;
        double d3;
        double d4;
        double[] dArray = new double[2];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = weightedObservedPointArray[0].getX();
        double d11 = weightedObservedPointArray[0].getY();
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = d10;
        for (int i2 = 1; i2 < weightedObservedPointArray.length; ++i2) {
            double d15 = d10;
            double d16 = d11;
            d10 = weightedObservedPointArray[i2].getX();
            d11 = weightedObservedPointArray[i2].getY();
            double d17 = d10 - d15;
            d4 = d11 - d16;
            double d18 = d16;
            double d19 = d11;
            d3 = d17 * (d18 * d18 + d16 * d11 + d19 * d19) / 3.0;
            double d20 = d4;
            d2 = d20 * d20 / d17;
            double d21 = d10 - d14;
            d13 += d2;
            double d22 = d21;
            d5 += d22 * d22;
            double d23 = d12 += d3;
            d6 += d23 * d23;
            d7 += d21 * d12;
            d8 += d21 * d13;
            d9 += d12 * d13;
        }
        double d24 = d6 * d8 - d7 * d9;
        double d25 = d7 * d8 - d5 * d9;
        double d26 = d7;
        double d27 = d5 * d6 - d26 * d26;
        if (d24 / d25 < 0.0 || d25 / d27 < 0.0) {
            int n = weightedObservedPointArray.length - 1;
            d4 = weightedObservedPointArray[n].getX() - weightedObservedPointArray[0].getX();
            if (d4 == 0.0) {
                throw new ZeroException();
            }
            dArray[1] = Math.PI * 2 / d4;
            d3 = Double.POSITIVE_INFINITY;
            d2 = Double.NEGATIVE_INFINITY;
            for (int i3 = 1; i3 < weightedObservedPointArray.length; ++i3) {
                double d28;
                double d29 = weightedObservedPointArray[i3].getY();
                if (d28 < d3) {
                    d3 = d29;
                }
                if (!(d29 > d2)) continue;
                d2 = d29;
            }
            dArray[0] = 0.5 * (d2 - d3);
        } else {
            if (d25 == 0.0) {
                throw new MathIllegalStateException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            dArray[0] = FastMath.sqrt(d24 / d25);
            dArray[1] = FastMath.sqrt(d25 / d27);
        }
        return dArray;
    }

    private double guessPhi(WeightedObservedPoint[] weightedObservedPointArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = weightedObservedPointArray[0].getX();
        double d5 = weightedObservedPointArray[0].getY();
        for (int i2 = 1; i2 < weightedObservedPointArray.length; ++i2) {
            double d6 = d4;
            double d7 = d5;
            d4 = weightedObservedPointArray[i2].getX();
            d5 = weightedObservedPointArray[i2].getY();
            double d8 = (d5 - d7) / (d4 - d6);
            double d9 = this.omega * d4;
            double d10 = FastMath.cos(d9);
            double d11 = FastMath.sin(d9);
            d2 += this.omega * d5 * d10 - d8 * d11;
            d3 += this.omega * d5 * d11 + d8 * d10;
        }
        return FastMath.atan2(-d3, d2);
    }
}

