/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.GaussianCurveFitter$ParameterGuesser$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fitting.WeightedObservedPoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianCurveFitter$ParameterGuesser {
    private final double norm;
    private final double mean;
    private final double sigma;

    public GaussianCurveFitter$ParameterGuesser(Collection<WeightedObservedPoint> object) {
        if (object == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (object.size() < 3) {
            throw new NumberIsTooSmallException(object.size(), (Number)3, true);
        }
        object = this.sortObservations((Collection<WeightedObservedPoint>)object);
        object = this.basicGuess(object.toArray((WeightedObservedPoint[])new WeightedObservedPoint[0]));
        this.norm = (double)object[0];
        this.mean = (double)object[1];
        this.sigma = (double)object[2];
    }

    public double[] guess() {
        return new double[]{this.norm, this.mean, this.sigma};
    }

    private List<WeightedObservedPoint> sortObservations(Collection<WeightedObservedPoint> collection) {
        collection = new ArrayList<WeightedObservedPoint>(collection);
        GaussianCurveFitter$ParameterGuesser$1 gaussianCurveFitter$ParameterGuesser$1 = new GaussianCurveFitter$ParameterGuesser$1(this);
        Collections.sort(collection, gaussianCurveFitter$ParameterGuesser$1);
        return collection;
    }

    private double[] basicGuess(WeightedObservedPoint[] weightedObservedPointArray) {
        double d2;
        double d3;
        int n = this.findMaxY(weightedObservedPointArray);
        double d4 = weightedObservedPointArray[n].getY();
        double d5 = weightedObservedPointArray[n].getX();
        try {
            d3 = d4 + (d5 - d4) / 2.0;
            double d6 = this.interpolateXAtY(weightedObservedPointArray, n, -1, d3);
            double d7 = this.interpolateXAtY(weightedObservedPointArray, n, 1, d3);
            d2 = d7 - d6;
        }
        catch (OutOfRangeException outOfRangeException) {
            d2 = weightedObservedPointArray[weightedObservedPointArray.length - 1].getX() - weightedObservedPointArray[0].getX();
        }
        d3 = d2 / (2.0 * FastMath.sqrt(2.0 * FastMath.log(2.0)));
        return new double[]{d4, d5, d3};
    }

    private int findMaxY(WeightedObservedPoint[] weightedObservedPointArray) {
        int n = 0;
        for (int i2 = 1; i2 < weightedObservedPointArray.length; ++i2) {
            if (!(weightedObservedPointArray[i2].getY() > weightedObservedPointArray[n].getY())) continue;
            n = i2;
        }
        return n;
    }

    private double interpolateXAtY(WeightedObservedPoint[] object, int n, int n2, double d2) {
        if (n2 == 0) {
            throw new ZeroException();
        }
        object = this.getInterpolationPointsForY((WeightedObservedPoint[])object, n, n2, d2);
        WeightedObservedPoint weightedObservedPoint = object[0];
        object = object[1];
        if (weightedObservedPoint.getY() == d2) {
            return weightedObservedPoint.getX();
        }
        if (((WeightedObservedPoint)object).getY() == d2) {
            return ((WeightedObservedPoint)object).getX();
        }
        return weightedObservedPoint.getX() + (d2 - weightedObservedPoint.getY()) * (((WeightedObservedPoint)object).getX() - weightedObservedPoint.getX()) / (((WeightedObservedPoint)object).getY() - weightedObservedPoint.getY());
    }

    private WeightedObservedPoint[] getInterpolationPointsForY(WeightedObservedPoint[] weightedObservedPointArray, int n, int n2, double d2) {
        if (n2 == 0) {
            throw new ZeroException();
        }
        while (n2 < 0 ? n + n2 >= 0 : n + n2 < weightedObservedPointArray.length) {
            WeightedObservedPoint weightedObservedPoint = weightedObservedPointArray[n];
            WeightedObservedPoint weightedObservedPoint2 = weightedObservedPointArray[n + n2];
            if (this.isBetween(d2, weightedObservedPoint.getY(), weightedObservedPoint2.getY())) {
                if (n2 < 0) {
                    return new WeightedObservedPoint[]{weightedObservedPoint2, weightedObservedPoint};
                }
                return new WeightedObservedPoint[]{weightedObservedPoint, weightedObservedPoint2};
            }
            n += n2;
        }
        throw new OutOfRangeException(d2, (Number)Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    private boolean isBetween(double d2, double d3, double d4) {
        return d2 >= d3 && d2 <= d4 || d2 >= d4 && d2 <= d3;
    }
}

