/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.ArgUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionContext
implements Serializable {
    private static final long serialVersionUID = -6024911025449780478L;
    private Throwable throwable;
    private List<Localizable> msgPatterns;
    private List<Object[]> msgArguments;
    private Map<String, Object> context;

    public ExceptionContext(Throwable throwable) {
        this.throwable = throwable;
        this.msgPatterns = new ArrayList<Localizable>();
        this.msgArguments = new ArrayList<Object[]>();
        this.context = new HashMap<String, Object>();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void addMessage(Localizable localizable, Object ... objectArray) {
        this.msgPatterns.add(localizable);
        this.msgArguments.add(ArgUtils.flatten(objectArray));
    }

    public void setValue(String string, Object object) {
        this.context.put(string, object);
    }

    public Object getValue(String string) {
        return this.context.get(string);
    }

    public Set<String> getKeys() {
        return this.context.keySet();
    }

    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        return this.buildMessage(locale, ": ");
    }

    public String getMessage(Locale locale, String string) {
        return this.buildMessage(locale, string);
    }

    private String buildMessage(Locale locale, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = this.msgPatterns.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Serializable serializable = this.msgPatterns.get(i2);
            Object[] objectArray = this.msgArguments.get(i2);
            serializable = new MessageFormat(serializable.getLocalizedString(locale), locale);
            stringBuilder.append(((Format)serializable).format(objectArray));
            if (++n >= n2) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.throwable);
        this.serializeMessages(objectOutputStream);
        this.serializeContext(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.throwable = (Throwable)objectInputStream.readObject();
        this.deSerializeMessages(objectInputStream);
        this.deSerializeContext(objectInputStream);
    }

    private void serializeMessages(ObjectOutputStream objectOutputStream) {
        int n = this.msgPatterns.size();
        objectOutputStream.writeInt(n);
        for (int i2 = 0; i2 < n; ++i2) {
            Object[] objectArray = this.msgPatterns.get(i2);
            objectOutputStream.writeObject(objectArray);
            objectArray = this.msgArguments.get(i2);
            int n2 = objectArray.length;
            objectOutputStream.writeInt(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                if (objectArray[i3] instanceof Serializable) {
                    objectOutputStream.writeObject(objectArray[i3]);
                    continue;
                }
                objectOutputStream.writeObject(this.nonSerializableReplacement(objectArray[i3]));
            }
        }
    }

    private void deSerializeMessages(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        this.msgPatterns = new ArrayList<Localizable>(n);
        this.msgArguments = new ArrayList<Object[]>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            Localizable localizable = (Localizable)objectInputStream.readObject();
            this.msgPatterns.add(localizable);
            int n2 = objectInputStream.readInt();
            Object[] objectArray = new Object[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                objectArray[i3] = objectInputStream.readObject();
            }
            this.msgArguments.add(objectArray);
        }
    }

    private void serializeContext(ObjectOutputStream objectOutputStream) {
        int n = this.context.size();
        objectOutputStream.writeInt(n);
        for (Map.Entry<String, Object> entry : this.context.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            Object object = entry.getValue();
            if (object instanceof Serializable) {
                objectOutputStream.writeObject(object);
                continue;
            }
            objectOutputStream.writeObject(this.nonSerializableReplacement(object));
        }
    }

    private void deSerializeContext(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        this.context = new HashMap<String, Object>();
        for (int i2 = 0; i2 < n; ++i2) {
            String string = (String)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            this.context.put(string, object);
        }
    }

    private String nonSerializableReplacement(Object object) {
        return "[Object could not be serialized: " + object.getClass().getName() + "]";
    }
}

