/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.fitting;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.MixtureMultivariateNormalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.MixtureMultivariateRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.MultivariateNormalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.fitting.MultivariateNormalMixtureExpectationMaximization$DataRow;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation.Covariance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultivariateNormalMixtureExpectationMaximization {
    private static final int DEFAULT_MAX_ITERATIONS = 1000;
    private static final double DEFAULT_THRESHOLD = 1.0E-5;
    private final double[][] data;
    private MixtureMultivariateNormalDistribution fittedModel;
    private double logLikelihood = 0.0;

    public MultivariateNormalMixtureExpectationMaximization(double[][] dArray) {
        if (dArray.length <= 0) {
            throw new NotStrictlyPositiveException(dArray.length);
        }
        this.data = new double[dArray.length][dArray[0].length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (dArray[i2].length != dArray[0].length) {
                throw new DimensionMismatchException(dArray[i2].length, dArray[0].length);
            }
            if (dArray[i2].length < 2) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_TOO_SMALL, (Number)dArray[i2].length, 2, true);
            }
            this.data[i2] = MathArrays.copyOf(dArray[i2], dArray[i2].length);
        }
    }

    public void fit(MixtureMultivariateNormalDistribution object, int n, double d2) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        if (d2 < Double.MIN_VALUE) {
            throw new NotStrictlyPositiveException(d2);
        }
        int n2 = this.data.length;
        int n3 = this.data[0].length;
        int n4 = ((MixtureMultivariateRealDistribution)object).getComponents().size();
        int n5 = ((MultivariateNormalDistribution)((MixtureMultivariateRealDistribution)object).getComponents().get(0).getSecond()).getMeans().length;
        if (n5 != n3) {
            throw new DimensionMismatchException(n5, n3);
        }
        n5 = 0;
        double d3 = 0.0;
        this.logLikelihood = Double.NEGATIVE_INFINITY;
        this.fittedModel = new MixtureMultivariateNormalDistribution(((MixtureMultivariateRealDistribution)object).getComponents());
        while (n5++ <= n && FastMath.abs(d3 - this.logLikelihood) > d2) {
            int n6;
            int n7;
            d3 = this.logLikelihood;
            double d4 = 0.0;
            object = this.fittedModel.getComponents();
            Object object2 = new double[n4];
            MultivariateNormalDistribution[] multivariateNormalDistributionArray = new MultivariateNormalDistribution[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                object2[i2] = (Double)((Pair)object.get(i2)).getFirst();
                multivariateNormalDistributionArray[i2] = (MultivariateNormalDistribution)((Pair)object.get(i2)).getSecond();
            }
            double[][] dArray = new double[n2][n4];
            object = new double[n4];
            double[][] dArray2 = new double[n4][n3];
            for (int i3 = 0; i3 < n2; ++i3) {
                double d5 = this.fittedModel.density(this.data[i3]);
                d4 += FastMath.log(d5);
                for (n7 = 0; n7 < n4; ++n7) {
                    dArray[i3][n7] = object2[n7] * multivariateNormalDistributionArray[n7].density(this.data[i3]) / d5;
                    Object object3 = object;
                    int n8 = n7;
                    object3[n8] = object3[n8] + dArray[i3][n7];
                    for (n6 = 0; n6 < n3; ++n6) {
                        double[] dArray3 = dArray2[n7];
                        int n9 = n6;
                        dArray3[n9] = dArray3[n9] + dArray[i3][n7] * this.data[i3][n6];
                    }
                }
            }
            this.logLikelihood = d4 / (double)n2;
            double[] dArray4 = new double[n4];
            double[][] dArray5 = new double[n4][n3];
            for (int i4 = 0; i4 < n4; ++i4) {
                dArray4[i4] = (double)(object[i4] / (double)n2);
                for (n7 = 0; n7 < n3; ++n7) {
                    dArray5[i4][n7] = dArray2[i4][n7] / object[i4];
                }
            }
            RealMatrix[] realMatrixArray = new RealMatrix[n4];
            for (n7 = 0; n7 < n4; ++n7) {
                int n10 = n3;
                realMatrixArray[n7] = new Array2DRowRealMatrix(n10, n10);
            }
            for (n7 = 0; n7 < n2; ++n7) {
                for (n6 = 0; n6 < n4; ++n6) {
                    Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(MathArrays.ebeSubtract(this.data[n7], dArray5[n6]));
                    object2 = array2DRowRealMatrix;
                    object2 = array2DRowRealMatrix.multiply(object2.transpose()).scalarMultiply(dArray[n7][n6]);
                    realMatrixArray[n6] = realMatrixArray[n6].add((RealMatrix)object2);
                }
            }
            int n11 = n3;
            double[][][] dArray6 = new double[n4][n11][n11];
            for (n6 = 0; n6 < n4; ++n6) {
                realMatrixArray[n6] = realMatrixArray[n6].scalarMultiply(1.0 / object[n6]);
                dArray6[n6] = realMatrixArray[n6].getData();
            }
            this.fittedModel = new MixtureMultivariateNormalDistribution(dArray4, dArray5, dArray6);
        }
        if (FastMath.abs(d3 - this.logLikelihood) > d2) {
            throw new ConvergenceException();
        }
    }

    public void fit(MixtureMultivariateNormalDistribution mixtureMultivariateNormalDistribution) {
        this.fit(mixtureMultivariateNormalDistribution, 1000, 1.0E-5);
    }

    public static MixtureMultivariateNormalDistribution estimate(double[][] object, int n) {
        if (((double[][])object).length < 2) {
            throw new NotStrictlyPositiveException(((double[][])object).length);
        }
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        if (n > ((double[][])object).length) {
            throw new NumberIsTooLargeException(n, (Number)((double[][])object).length, true);
        }
        int n2 = ((double[][])object).length;
        int n3 = object[0].length;
        Object[] objectArray = new MultivariateNormalMixtureExpectationMaximization$DataRow[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = new MultivariateNormalMixtureExpectationMaximization$DataRow(object[i2]);
        }
        Arrays.sort(objectArray);
        double d2 = 1.0 / (double)n;
        object = new ArrayList(n);
        for (int i3 = 0; i3 < n; ++i3) {
            int n4 = i3 * n2 / n;
            int n5 = (i3 + 1) * n2 / n;
            int n6 = n5 - n4;
            double[][] dArray = new double[n6][n3];
            double[] dArray2 = new double[n3];
            int n7 = 0;
            while (n4 < n5) {
                for (int i4 = 0; i4 < n3; ++i4) {
                    double d3 = ((MultivariateNormalMixtureExpectationMaximization$DataRow)objectArray[n4]).getRow()[i4];
                    int n8 = i4;
                    dArray2[n8] = dArray2[n8] + d3;
                    dArray[n7][i4] = d3;
                }
                ++n4;
                ++n7;
            }
            MathArrays.scaleInPlace(1.0 / (double)n6, dArray2);
            double[][] dArray3 = new Covariance(dArray).getCovarianceMatrix().getData();
            MultivariateNormalDistribution multivariateNormalDistribution = new MultivariateNormalDistribution(dArray2, dArray3);
            object.add(new Pair<Double, MultivariateNormalDistribution>(d2, multivariateNormalDistribution));
        }
        return new MixtureMultivariateNormalDistribution((List<Pair<Double, MultivariateNormalDistribution>>)object);
    }

    public double getLogLikelihood() {
        return this.logLikelihood;
    }

    public MixtureMultivariateNormalDistribution getFittedModel() {
        return new MixtureMultivariateNormalDistribution(this.fittedModel.getComponents());
    }
}

