/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;

public class UniformRealDistribution
extends AbstractRealDistribution {
    @Deprecated
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20120109L;
    private final double lower;
    private final double upper;

    public UniformRealDistribution() {
        this(0.0, 1.0);
    }

    public UniformRealDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    @Deprecated
    public UniformRealDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3);
    }

    @Deprecated
    public UniformRealDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        this(randomGenerator, d2, d3);
    }

    public UniformRealDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        if (d2 >= d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d2, d3, false);
        }
        this.lower = d2;
        this.upper = d3;
    }

    public double density(double d2) {
        if (d2 < this.lower || d2 > this.upper) {
            return 0.0;
        }
        return 1.0 / (this.upper - this.lower);
    }

    public double cumulativeProbability(double d2) {
        if (d2 <= this.lower) {
            return 0.0;
        }
        if (d2 >= this.upper) {
            return 1.0;
        }
        return (d2 - this.lower) / (this.upper - this.lower);
    }

    public double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        return d2 * (this.upper - this.lower) + this.lower;
    }

    public double getNumericalMean() {
        return 0.5 * (this.lower + this.upper);
    }

    public double getNumericalVariance() {
        double d2 = this.upper - this.lower;
        return d2 * d2 / 12.0;
    }

    public double getSupportLowerBound() {
        return this.lower;
    }

    public double getSupportUpperBound() {
        return this.upper;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        double d2 = this.random.nextDouble();
        return d2 * this.upper + (1.0 - d2) * this.lower;
    }
}

