/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class TriangularDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20120112L;
    private final double a;
    private final double b;
    private final double c;
    private final double solverAbsoluteAccuracy;

    public TriangularDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public TriangularDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d2 >= d4) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d2, d4, false);
        }
        if (d3 < d2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_TOO_SMALL, (Number)d3, d2, true);
        }
        if (d3 > d4) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_TOO_LARGE, (Number)d3, d4, true);
        }
        this.a = d2;
        this.c = d3;
        this.b = d4;
        this.solverAbsoluteAccuracy = FastMath.max(FastMath.ulp(d2), FastMath.ulp(d4));
    }

    public double getMode() {
        return this.c;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double density(double d2) {
        if (d2 < this.a) {
            return 0.0;
        }
        if (this.a <= d2 && d2 < this.c) {
            double d3 = 2.0 * (d2 - this.a);
            double d4 = (this.b - this.a) * (this.c - this.a);
            return d3 / d4;
        }
        if (d2 == this.c) {
            return 2.0 / (this.b - this.a);
        }
        if (this.c < d2 && d2 <= this.b) {
            double d5 = 2.0 * (this.b - d2);
            double d6 = (this.b - this.a) * (this.b - this.c);
            return d5 / d6;
        }
        return 0.0;
    }

    public double cumulativeProbability(double d2) {
        if (d2 < this.a) {
            return 0.0;
        }
        if (this.a <= d2 && d2 < this.c) {
            double d3 = (d2 - this.a) * (d2 - this.a);
            double d4 = (this.b - this.a) * (this.c - this.a);
            return d3 / d4;
        }
        if (d2 == this.c) {
            return (this.c - this.a) / (this.b - this.a);
        }
        if (this.c < d2 && d2 <= this.b) {
            double d5 = (this.b - d2) * (this.b - d2);
            double d6 = (this.b - this.a) * (this.b - this.c);
            return 1.0 - d5 / d6;
        }
        return 1.0;
    }

    public double getNumericalMean() {
        return (this.a + this.b + this.c) / 3.0;
    }

    public double getNumericalVariance() {
        return (this.a * this.a + this.b * this.b + this.c * this.c - this.a * this.b - this.a * this.c - this.b * this.c) / 18.0;
    }

    public double getSupportLowerBound() {
        return this.a;
    }

    public double getSupportUpperBound() {
        return this.b;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        if (d2 == 0.0) {
            return this.a;
        }
        if (d2 == 1.0) {
            return this.b;
        }
        if (d2 < (this.c - this.a) / (this.b - this.a)) {
            return this.a + FastMath.sqrt(d2 * (this.b - this.a) * (this.c - this.a));
        }
        return this.b - FastMath.sqrt((1.0 - d2) * (this.b - this.a) * (this.b - this.c));
    }
}

