/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractIntegerDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.ExponentialDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.NormalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.SaddlePointExpansion;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Gamma;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CombinatoricsUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class PoissonDistribution
extends AbstractIntegerDistribution {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private final NormalDistribution normal;
    private final ExponentialDistribution exponential;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double d2) {
        this(d2, 1.0E-12, 10000000);
    }

    public PoissonDistribution(double d2, double d3, int n) {
        this(new Well19937c(), d2, d3, n);
    }

    public PoissonDistribution(RandomGenerator randomGenerator, double d2, double d3, int n) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d2);
        }
        this.mean = d2;
        this.epsilon = d3;
        this.maxIterations = n;
        double d4 = d2;
        this.normal = new NormalDistribution(randomGenerator, d4, FastMath.sqrt(d4), 1.0E-9);
        this.exponential = new ExponentialDistribution(randomGenerator, 1.0, 1.0E-9);
    }

    public PoissonDistribution(double d2, double d3) {
        this(d2, d3, 10000000);
    }

    public PoissonDistribution(double d2, int n) {
        this(d2, 1.0E-12, n);
    }

    public double getMean() {
        return this.mean;
    }

    public double probability(int n) {
        double d2 = ((AbstractIntegerDistribution)this).logProbability(n);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return FastMath.exp(d2);
    }

    public double logProbability(int n) {
        double d2 = n < 0 || n == Integer.MAX_VALUE ? Double.NEGATIVE_INFINITY : (n == 0 ? -this.mean : -SaddlePointExpansion.getStirlingError(n) - SaddlePointExpansion.getDeviancePart(n, this.mean) - 0.5 * FastMath.log(Math.PI * 2) - 0.5 * FastMath.log(n));
        return d2;
    }

    public double cumulativeProbability(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)n + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int n) {
        return this.normal.cumulativeProbability((double)n + 0.5);
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        return this.getMean();
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        PoissonDistribution poissonDistribution = this;
        return (int)FastMath.min(poissonDistribution.nextPoisson(poissonDistribution.mean), Integer.MAX_VALUE);
    }

    private long nextPoisson(double d2) {
        double d3;
        long l;
        block9: {
            if (d2 < 40.0) {
                double d4 = FastMath.exp(-d2);
                long l2 = 0L;
                double d5 = 1.0;
                while ((double)l2 < d2 * 1000.0) {
                    double d6;
                    double d7 = this.random.nextDouble();
                    d5 *= d7;
                    if (d6 >= d4) {
                        ++l2;
                        continue;
                    }
                    return l2;
                }
                return l2;
            }
            double d8 = FastMath.floor(d2);
            double d9 = d2 - d8;
            double d10 = FastMath.log(d8);
            double d11 = CombinatoricsUtils.factorialLog((int)d8);
            l = d9 < Double.MIN_VALUE ? 0L : this.nextPoisson(d9);
            double d12 = FastMath.sqrt(d8 * FastMath.log(d8 * 32.0 / Math.PI + 1.0));
            double d13 = d12 / 2.0;
            double d14 = d8 * 2.0 + d12;
            double d15 = FastMath.sqrt(d14 * Math.PI) * FastMath.exp(1.0 / (d8 * 8.0));
            double d16 = d14 / d12 * FastMath.exp(-d12 * (d12 + 1.0) / d14);
            double d17 = d15 + d16 + 1.0;
            double d18 = d15 / d17;
            double d19 = d16 / d17;
            double d20 = 1.0 / (d8 * 8.0);
            while (true) {
                double d21;
                double d22;
                double d23;
                double d24 = this.random.nextDouble();
                if (d23 <= d18) {
                    double d25 = this.random.nextGaussian();
                    d22 = d25 * FastMath.sqrt(d8 + d13) - 0.5;
                    if (d22 > d12 || d22 < -d8) continue;
                    d3 = d22 < 0.0 ? FastMath.floor(d22) : FastMath.ceil(d22);
                    double d26 = ((AbstractRealDistribution)this.exponential).sample();
                    double d27 = d25;
                    d21 = -d26 - d27 * d27 / 2.0 + d20;
                } else {
                    if (d24 > d18 + d19) {
                        d3 = d8;
                        break block9;
                    }
                    d22 = d12 + d14 / d12 * ((AbstractRealDistribution)this.exponential).sample();
                    d3 = FastMath.ceil(d22);
                    d21 = -((AbstractRealDistribution)this.exponential).sample() - d12 * (d22 + 1.0) / d14;
                }
                boolean bl = d22 < 0.0;
                double d28 = d3;
                double d29 = d28 * (d28 + 1.0) / (d8 * 2.0);
                if (d21 < -d29 && !bl) {
                    d3 = d8 + d3;
                    break block9;
                }
                double d30 = d29 * ((d3 * 2.0 + 1.0) / (d8 * 6.0) - 1.0);
                double d31 = d29;
                double d32 = d30 - d31 * d31 / (3.0 * (d8 + (double)bl * (d3 + 1.0)));
                if (d21 < d32) {
                    d3 = d8 + d3;
                    break block9;
                }
                if (!(d21 > d30) && d21 < d3 * d10 - CombinatoricsUtils.factorialLog((int)(d3 + d8)) + d11) break;
            }
            d3 = d8 + d3;
        }
        return l + (long)d3;
    }
}

