/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractIntegerDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Beta;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CombinatoricsUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class PascalDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public PascalDistribution(int n, double d2) {
        this(new Well19937c(), n, d2);
    }

    public PascalDistribution(RandomGenerator randomGenerator, int n, double d2) {
        super(randomGenerator);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        this.numberOfSuccesses = n;
        this.probabilityOfSuccess = d2;
        this.logProbabilityOfSuccess = FastMath.log(d2);
        this.log1mProbabilityOfSuccess = FastMath.log1p(-d2);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public double probability(int n) {
        double d2 = n < 0 ? 0.0 : CombinatoricsUtils.binomialCoefficientDouble(n + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * FastMath.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * FastMath.pow(1.0 - this.probabilityOfSuccess, n);
        return d2;
    }

    public double logProbability(int n) {
        double d2 = n < 0 ? Double.NEGATIVE_INFINITY : CombinatoricsUtils.binomialCoefficientLog(n + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) + this.logProbabilityOfSuccess * (double)this.numberOfSuccesses + this.log1mProbabilityOfSuccess * (double)n;
        return d2;
    }

    public double cumulativeProbability(int n) {
        double d2 = n < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, (double)n + 1.0);
        return d2;
    }

    public double getNumericalMean() {
        double d2 = this.getProbabilityOfSuccess();
        double d3 = this.getNumberOfSuccesses();
        return d3 * (1.0 - d2) / d2;
    }

    public double getNumericalVariance() {
        double d2 = this.getProbabilityOfSuccess();
        double d3 = this.getNumberOfSuccesses();
        double d4 = d2;
        return d3 * (1.0 - d2) / (d4 * d4);
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

