/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class ParetoDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20130424L;
    private final double scale;
    private final double shape;
    private final double solverAbsoluteAccuracy;

    public ParetoDistribution() {
        this(1.0, 1.0);
    }

    public ParetoDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public ParetoDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public ParetoDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        this(randomGenerator, d2, d3, 1.0E-9);
    }

    public ParetoDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d2);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d3);
        }
        this.scale = d2;
        this.shape = d3;
        this.solverAbsoluteAccuracy = d4;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public double density(double d2) {
        if (d2 < this.scale) {
            return 0.0;
        }
        return FastMath.pow(this.scale, this.shape) / FastMath.pow(d2, this.shape + 1.0) * this.shape;
    }

    public double logDensity(double d2) {
        if (d2 < this.scale) {
            return Double.NEGATIVE_INFINITY;
        }
        return FastMath.log(this.scale) * this.shape - FastMath.log(d2) * (this.shape + 1.0) + FastMath.log(this.shape);
    }

    public double cumulativeProbability(double d2) {
        if (d2 <= this.scale) {
            return 0.0;
        }
        return 1.0 - FastMath.pow(this.scale / d2, this.shape);
    }

    @Deprecated
    public double cumulativeProbability(double d2, double d3) {
        return this.probability(d2, d3);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        if (this.shape <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.shape * this.scale / (this.shape - 1.0);
    }

    public double getNumericalVariance() {
        double d2;
        if (this.shape <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d3 = d2 = this.shape - 1.0;
        return this.scale * this.scale * this.shape / (d3 * d3) / (this.shape - 2.0);
    }

    public double getSupportLowerBound() {
        return this.scale;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        double d2 = this.random.nextDouble();
        return this.scale / FastMath.pow(d2, 1.0 / this.shape);
    }
}

