/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Gamma;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class NakagamiDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20141003L;
    private final double mu;
    private final double omega;
    private final double inverseAbsoluteAccuracy;

    public NakagamiDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public NakagamiDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public NakagamiDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d2 < 0.5) {
            throw new NumberIsTooSmallException(d2, (Number)0.5, true);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_SCALE, d3);
        }
        this.mu = d2;
        this.omega = d3;
        this.inverseAbsoluteAccuracy = d4;
    }

    public double getShape() {
        return this.mu;
    }

    public double getScale() {
        return this.omega;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.inverseAbsoluteAccuracy;
    }

    public double density(double d2) {
        if (d2 <= 0.0) {
            return 0.0;
        }
        return 2.0 * FastMath.pow(this.mu, this.mu) / (Gamma.gamma(this.mu) * FastMath.pow(this.omega, this.mu)) * FastMath.pow(d2, 2.0 * this.mu - 1.0) * FastMath.exp(-this.mu * d2 * d2 / this.omega);
    }

    public double cumulativeProbability(double d2) {
        return Gamma.regularizedGammaP(this.mu, this.mu * d2 * d2 / this.omega);
    }

    public double getNumericalMean() {
        return Gamma.gamma(this.mu + 0.5) / Gamma.gamma(this.mu) * FastMath.sqrt(this.omega / this.mu);
    }

    public double getNumericalVariance() {
        double d2 = Gamma.gamma(this.mu + 0.5) / Gamma.gamma(this.mu);
        return this.omega * (1.0 - 1.0 / this.mu * d2 * d2);
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

