/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractMultivariateRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.EigenDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class MultivariateNormalDistribution
extends AbstractMultivariateRealDistribution {
    private final double[] means;
    private final RealMatrix covarianceMatrix;
    private final RealMatrix covarianceMatrixInverse;
    private final double covarianceMatrixDeterminant;
    private final RealMatrix samplingMatrix;

    public MultivariateNormalDistribution(double[] dArray, double[][] dArray2) {
        this(new Well19937c(), dArray, dArray2);
    }

    public MultivariateNormalDistribution(RandomGenerator randomGenerator, double[] dArray, double[][] dArray2) {
        super(randomGenerator, dArray.length);
        int n = dArray.length;
        if (dArray2.length != n) {
            throw new DimensionMismatchException(dArray2.length, n);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            if (n == dArray2[i2].length) continue;
            throw new DimensionMismatchException(dArray2[i2].length, n);
        }
        this.means = MathArrays.copyOf(dArray);
        this.covarianceMatrix = new Array2DRowRealMatrix(dArray2);
        EigenDecomposition eigenDecomposition = new EigenDecomposition(this.covarianceMatrix);
        this.covarianceMatrixInverse = eigenDecomposition.getSolver().getInverse();
        this.covarianceMatrixDeterminant = eigenDecomposition.getDeterminant();
        dArray = eigenDecomposition.getRealEigenvalues();
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            if (!(dArray[i3] < 0.0)) continue;
            throw new NonPositiveDefiniteMatrixException(dArray[i3], i3, 0.0);
        }
        int n2 = n;
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n2, n2);
        for (int i4 = 0; i4 < n; ++i4) {
            double[] dArray3 = eigenDecomposition.getEigenvector(i4).toArray();
            array2DRowRealMatrix.setColumn(i4, dArray3);
        }
        RealMatrix realMatrix = array2DRowRealMatrix.transpose();
        for (int i5 = 0; i5 < n; ++i5) {
            double d2 = FastMath.sqrt(dArray[i5]);
            for (int i6 = 0; i6 < n; ++i6) {
                realMatrix.multiplyEntry(i5, i6, d2);
            }
        }
        this.samplingMatrix = array2DRowRealMatrix.multiply(realMatrix);
    }

    public double[] getMeans() {
        return MathArrays.copyOf(this.means);
    }

    public RealMatrix getCovariances() {
        return this.covarianceMatrix.copy();
    }

    public double density(double[] dArray) {
        int n = this.getDimension();
        if (dArray.length != n) {
            throw new DimensionMismatchException(dArray.length, n);
        }
        return FastMath.pow(Math.PI * 2, -0.5 * (double)n) * FastMath.pow(this.covarianceMatrixDeterminant, -0.5) * this.getExponentTerm(dArray);
    }

    public double[] getStandardDeviations() {
        int n = this.getDimension();
        double[] dArray = new double[n];
        double[][] dArray2 = this.covarianceMatrix.getData();
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = FastMath.sqrt(dArray2[i2][i2]);
        }
        return dArray;
    }

    public double[] sample() {
        int n = this.getDimension();
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.random.nextGaussian();
        }
        double[] dArray2 = this.samplingMatrix.operate(dArray);
        for (int i3 = 0; i3 < n; ++i3) {
            int n2 = i3;
            dArray2[n2] = dArray2[n2] + this.means[i3];
        }
        return dArray2;
    }

    private double getExponentTerm(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            dArray2[i2] = dArray[i2] - this.getMeans()[i2];
        }
        double[] dArray3 = this.covarianceMatrixInverse.preMultiply(dArray2);
        double d2 = 0.0;
        for (int i3 = 0; i3 < dArray3.length; ++i3) {
            d2 += dArray3[i3] * dArray2[i3];
        }
        return FastMath.exp(d2 * -0.5);
    }
}

