/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class LogisticDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20141003L;
    private final double mu;
    private final double s;

    public LogisticDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    public LogisticDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_SCALE, d3);
        }
        this.mu = d2;
        this.s = d3;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.s;
    }

    public double density(double d2) {
        double d3 = (d2 - this.mu) / this.s;
        double d4 = FastMath.exp(-d3);
        return 1.0 / this.s * d4 / ((d4 + 1.0) * (d4 + 1.0));
    }

    public double cumulativeProbability(double d2) {
        double d3 = 1.0 / this.s * (d2 - this.mu);
        return 1.0 / (1.0 + FastMath.exp(-d3));
    }

    public double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0.0, 1.0);
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.s * Math.log(d2 / (1.0 - d2)) + this.mu;
    }

    public double getNumericalMean() {
        return this.mu;
    }

    public double getNumericalVariance() {
        return 3.289868133696453 * (1.0 / (this.s * this.s));
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

