/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Erf;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class LogNormalDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20120112L;
    private static final double SQRT2PI = FastMath.sqrt(Math.PI * 2);
    private static final double SQRT2 = FastMath.sqrt(2.0);
    private final double scale;
    private final double shape;
    private final double logShapePlusHalfLog2Pi;
    private final double solverAbsoluteAccuracy;

    public LogNormalDistribution() {
        this(0.0, 1.0);
    }

    public LogNormalDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public LogNormalDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public LogNormalDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        this(randomGenerator, d2, d3, 1.0E-9);
    }

    public LogNormalDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d3);
        }
        this.scale = d2;
        this.shape = d3;
        this.logShapePlusHalfLog2Pi = FastMath.log(d3) + 0.5 * FastMath.log(Math.PI * 2);
        this.solverAbsoluteAccuracy = d4;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public double density(double d2) {
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d3 = FastMath.log(d2) - this.scale;
        double d4 = d3 / this.shape;
        return FastMath.exp(d4 * -0.5 * d4) / (this.shape * SQRT2PI * d2);
    }

    public double logDensity(double d2) {
        if (d2 <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d3 = FastMath.log(d2);
        double d4 = d3 - this.scale;
        double d5 = d4 / this.shape;
        return d5 * -0.5 * d5 - (this.logShapePlusHalfLog2Pi + d3);
    }

    public double cumulativeProbability(double d2) {
        double d3;
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d4 = FastMath.log(d2) - this.scale;
        if (FastMath.abs(d3) > 40.0 * this.shape) {
            if (d4 < 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        return 0.5 + 0.5 * Erf.erf(d4 / (this.shape * SQRT2));
    }

    @Deprecated
    public double cumulativeProbability(double d2, double d3) {
        return ((AbstractRealDistribution)this).probability(d2, d3);
    }

    public double probability(double d2, double d3) {
        if (d2 > d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)d2, d3, true);
        }
        if (d2 <= 0.0 || d3 <= 0.0) {
            return super.probability(d2, d3);
        }
        double d4 = this.shape * SQRT2;
        double d5 = (FastMath.log(d2) - this.scale) / d4;
        double d6 = (FastMath.log(d3) - this.scale) / d4;
        return 0.5 * Erf.erf(d5, d6);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        double d2;
        double d3 = d2 = this.shape;
        return FastMath.exp(this.scale + d3 * d3 / 2.0);
    }

    public double getNumericalVariance() {
        double d2 = this.shape;
        double d3 = d2 * d2;
        return FastMath.expm1(d3) * FastMath.exp(2.0 * this.scale + d3);
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        double d2 = this.random.nextGaussian();
        return FastMath.exp(this.scale + this.shape * d2);
    }
}

