/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Erf;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class LevyDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20130314L;
    private final double mu;
    private final double c;
    private final double halfC;

    public LevyDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    public LevyDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        this.mu = d2;
        this.c = d3;
        this.halfC = d3 * 0.5;
    }

    public double density(double d2) {
        if (d2 < this.mu) {
            return Double.NaN;
        }
        double d3 = d2 - this.mu;
        double d4 = this.halfC / d3;
        return FastMath.sqrt(d4 / Math.PI) * FastMath.exp(-d4) / d3;
    }

    public double logDensity(double d2) {
        if (d2 < this.mu) {
            return Double.NaN;
        }
        double d3 = d2 - this.mu;
        double d4 = this.halfC / d3;
        return 0.5 * FastMath.log(d4 / Math.PI) - d4 - FastMath.log(d3);
    }

    public double cumulativeProbability(double d2) {
        if (d2 < this.mu) {
            return Double.NaN;
        }
        return Erf.erfc(FastMath.sqrt(this.halfC / (d2 - this.mu)));
    }

    public double inverseCumulativeProbability(double d2) {
        double d3;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        double d4 = d3 = Erf.erfcInv(d2);
        return this.mu + this.halfC / (d4 * d4);
    }

    public double getScale() {
        return this.c;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getNumericalMean() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalVariance() {
        return Double.POSITIVE_INFINITY;
    }

    public double getSupportLowerBound() {
        return this.mu;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

