/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFractionField;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.FractionConversionException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KolmogorovSmirnovDistribution
implements Serializable {
    private static final long serialVersionUID = -4670676796862967187L;
    private int n;

    public KolmogorovSmirnovDistribution(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        this.n = n;
    }

    public double cdf(double d2) {
        return this.cdf(d2, false);
    }

    public double cdfExact(double d2) {
        return this.cdf(d2, true);
    }

    public double cdf(double d2, boolean bl) {
        double d3 = 1.0 / (double)this.n;
        double d4 = d3 * 0.5;
        if (d2 <= d4) {
            return 0.0;
        }
        if (d4 < d2 && d2 <= d3) {
            double d5 = 1.0;
            double d6 = d2 * 2.0 - d3;
            for (int i2 = 1; i2 <= this.n; ++i2) {
                d5 *= (double)i2 * d6;
            }
            return d5;
        }
        if (1.0 - d3 <= d2 && d2 < 1.0) {
            return 1.0 - 2.0 * FastMath.pow(1.0 - d2, this.n);
        }
        if (1.0 <= d2) {
            return 1.0;
        }
        if (bl) {
            return this.exactK(d2);
        }
        return this.roundedK(d2);
    }

    private double exactK(double d2) {
        int n = (int)FastMath.ceil((double)this.n * d2);
        Object object = this.createH(d2);
        object = object.power(this.n);
        object = object.getEntry(n - 1, n - 1);
        for (int i2 = 1; i2 <= this.n; ++i2) {
            object = ((BigFraction)object).multiply(i2).divide(this.n);
        }
        return ((BigFraction)object).bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d2) {
        int n;
        int n2 = (int)FastMath.ceil((double)this.n * d2);
        FieldMatrix<BigFraction> fieldMatrix = this.createH(d2);
        int n3 = n = fieldMatrix.getRowDimension();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n3, n3);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                array2DRowRealMatrix.setEntry(i2, i3, fieldMatrix.getEntry(i2, i3).doubleValue());
            }
        }
        RealMatrix realMatrix = array2DRowRealMatrix.power(this.n);
        double d3 = realMatrix.getEntry(n2 - 1, n2 - 1);
        for (int i4 = 1; i4 <= this.n; ++i4) {
            d3 *= (double)i4 / (double)this.n;
        }
        return d3;
    }

    private FieldMatrix<BigFraction> createH(double d2) {
        int n;
        BigFraction bigFraction;
        double d3;
        int n2 = (int)FastMath.ceil((double)this.n * d2);
        int n3 = 2 * n2 - 1;
        double d4 = (double)n2 - (double)this.n * d2;
        if (d3 >= 1.0) {
            throw new NumberIsTooLargeException(d4, (Number)1.0, false);
        }
        try {
            bigFraction = new BigFraction(d4, 1.0E-20, 10000);
        }
        catch (FractionConversionException fractionConversionException) {
            try {
                bigFraction = new BigFraction(d4, 1.0E-10, 10000);
            }
            catch (FractionConversionException fractionConversionException2) {
                bigFraction = new BigFraction(d4, 1.0E-5, 10000);
            }
        }
        int n4 = n3;
        FieldElement[][] fieldElementArray = new BigFraction[n4][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                fieldElementArray[n2][i2] = n2 - i2 + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] bigFractionArray = new BigFraction[n3];
        BigFraction[] bigFractionArray2 = bigFractionArray;
        bigFractionArray[0] = bigFraction;
        for (n = 1; n < n3; ++n) {
            bigFractionArray2[n] = bigFraction.multiply(bigFractionArray2[n - 1]);
        }
        for (n = 0; n < n3; ++n) {
            fieldElementArray[n][0] = fieldElementArray[n][0].subtract(bigFractionArray2[n]);
            fieldElementArray[n3 - 1][n] = ((BigFraction)fieldElementArray[n3 - 1][n]).subtract(bigFractionArray2[n3 - n - 1]);
        }
        if (bigFraction.compareTo(BigFraction.ONE_HALF) == 1) {
            fieldElementArray[n3 - 1][0] = ((BigFraction)fieldElementArray[n3 - 1][0]).add(bigFraction.multiply(2).subtract(1).pow(n3));
        }
        for (n = 0; n < n3; ++n) {
            for (int i3 = 0; i3 < n + 1; ++i3) {
                if (n - i3 + 1 <= 0) continue;
                for (int i4 = 2; i4 <= n - i3 + 1; ++i4) {
                    fieldElementArray[n][i3] = ((BigFraction)fieldElementArray[n][i3]).divide(i4);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), fieldElementArray);
    }
}

