/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class GumbelDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20141003L;
    private static final double EULER = 0.5778636748954609;
    private final double mu;
    private final double beta;

    public GumbelDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    public GumbelDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d3);
        }
        this.beta = d3;
        this.mu = d2;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    public double density(double d2) {
        double d3 = (d2 - this.mu) / this.beta;
        double d4 = FastMath.exp(-d3);
        return FastMath.exp(-d3 - d4) / this.beta;
    }

    public double cumulativeProbability(double d2) {
        double d3 = (d2 - this.mu) / this.beta;
        return FastMath.exp(-FastMath.exp(-d3));
    }

    public double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0.0, 1.0);
        }
        if (d2 == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mu - FastMath.log(-FastMath.log(d2)) * this.beta;
    }

    public double getNumericalMean() {
        return this.mu + 0.5778636748954609 * this.beta;
    }

    public double getNumericalVariance() {
        return 1.6449340668482264 * (this.beta * this.beta);
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

