/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Gamma;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class GammaDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20120524L;
    private final double shape;
    private final double scale;
    private final double shiftedShape;
    private final double densityPrefactor1;
    private final double logDensityPrefactor1;
    private final double densityPrefactor2;
    private final double logDensityPrefactor2;
    private final double minY;
    private final double maxLogY;
    private final double solverAbsoluteAccuracy;

    public GammaDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public GammaDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public GammaDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        this(randomGenerator, d2, d3, 1.0E-9);
    }

    public GammaDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d2);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d3);
        }
        this.shape = d2;
        this.scale = d3;
        this.solverAbsoluteAccuracy = d4;
        this.shiftedShape = d2 + 4.7421875 + 0.5;
        double d5 = Math.E / (Math.PI * 2 * this.shiftedShape);
        this.densityPrefactor2 = d2 * FastMath.sqrt(d5) / Gamma.lanczos(d2);
        this.logDensityPrefactor2 = FastMath.log(d2) + 0.5 * FastMath.log(d5) - FastMath.log(Gamma.lanczos(d2));
        this.densityPrefactor1 = this.densityPrefactor2 / d3 * FastMath.pow(this.shiftedShape, -d2) * FastMath.exp(d2 + 4.7421875);
        this.logDensityPrefactor1 = this.logDensityPrefactor2 - FastMath.log(d3) - FastMath.log(this.shiftedShape) * d2 + d2 + 4.7421875;
        this.minY = d2 + 4.7421875 - FastMath.log(Double.MAX_VALUE);
        this.maxLogY = FastMath.log(Double.MAX_VALUE) / (d2 - 1.0);
    }

    @Deprecated
    public double getAlpha() {
        return this.shape;
    }

    public double getShape() {
        return this.shape;
    }

    @Deprecated
    public double getBeta() {
        return this.scale;
    }

    public double getScale() {
        return this.scale;
    }

    public double density(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        double d3 = d2 / this.scale;
        if (d3 <= this.minY || FastMath.log(d3) >= this.maxLogY) {
            double d4 = (d3 - this.shiftedShape) / this.shiftedShape;
            double d5 = this.shape * (FastMath.log1p(d4) - d4);
            double d6 = -d3 * 5.2421875 / this.shiftedShape + 4.7421875 + d5;
            return this.densityPrefactor2 / d2 * FastMath.exp(d6);
        }
        return this.densityPrefactor1 * FastMath.exp(-d3) * FastMath.pow(d3, this.shape - 1.0);
    }

    public double logDensity(double d2) {
        if (d2 < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d3 = d2 / this.scale;
        if (d3 <= this.minY || FastMath.log(d3) >= this.maxLogY) {
            double d4 = (d3 - this.shiftedShape) / this.shiftedShape;
            double d5 = this.shape * (FastMath.log1p(d4) - d4);
            double d6 = -d3 * 5.2421875 / this.shiftedShape + 4.7421875 + d5;
            return this.logDensityPrefactor2 - FastMath.log(d2) + d6;
        }
        return this.logDensityPrefactor1 - d3 + FastMath.log(d3) * (this.shape - 1.0);
    }

    public double cumulativeProbability(double d2) {
        double d3 = d2 <= 0.0 ? 0.0 : Gamma.regularizedGammaP(this.shape, d2 / this.scale);
        return d3;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        return this.shape * this.scale;
    }

    public double getNumericalVariance() {
        return this.shape * this.scale * this.scale;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        double d2;
        if (this.shape < 1.0) {
            double d3;
            while (true) {
                double d4;
                double d5;
                double d6 = this.random.nextDouble();
                double d7 = 1.0 + this.shape / Math.E;
                double d8 = d7 * d6;
                if (d5 <= 1.0) {
                    d3 = FastMath.pow(d8, 1.0 / this.shape);
                    d4 = this.random.nextDouble();
                    if (d4 > FastMath.exp(-d3)) continue;
                    return this.scale * d3;
                }
                d3 = -1.0 * FastMath.log((d7 - d8) / this.shape);
                d4 = this.random.nextDouble();
                if (!(d4 > FastMath.pow(d3, this.shape - 1.0))) break;
            }
            return this.scale * d3;
        }
        double d9 = this.shape - 0.3333333333333333;
        double d10 = 1.0 / (3.0 * FastMath.sqrt(d9));
        while (true) {
            double d11;
            double d12;
            if ((d2 = (1.0 + d10 * (d12 = this.random.nextGaussian())) * (1.0 + d10 * d12) * (1.0 + d10 * d12)) <= 0.0) {
                continue;
            }
            double d13 = d12;
            double d14 = d13 * d13;
            double d15 = this.random.nextDouble();
            if (d11 < 1.0 - d14 * 0.0331 * d14) {
                return this.scale * d9 * d2;
            }
            if (FastMath.log(d15) < d14 * 0.5 + d9 * (1.0 - d2 + FastMath.log(d2))) break;
        }
        return this.scale * d9 * d2;
    }
}

