/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.EnumeratedDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumeratedRealDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20130308L;
    protected final EnumeratedDistribution<Double> innerDistribution;

    public EnumeratedRealDistribution(double[] dArray, double[] dArray2) {
        this(new Well19937c(), dArray, dArray2);
    }

    public EnumeratedRealDistribution(RandomGenerator randomGenerator, double[] dArray, double[] dArray2) {
        super(randomGenerator);
        this.innerDistribution = new EnumeratedDistribution(randomGenerator, EnumeratedRealDistribution.createDistribution(dArray, dArray2));
    }

    public EnumeratedRealDistribution(RandomGenerator randomGenerator, double[] object) {
        super(randomGenerator);
        Object object2 = new HashMap<Double, Integer>();
        double[] dArray = object;
        int n = ((double[])object).length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d2 = dArray[i2];
            Integer n2 = (Integer)object2.get(d2);
            if (n2 == null) {
                n2 = 0;
            }
            object2.put(d2, n2 + 1);
        }
        int n3 = object2.size();
        double d3 = ((double[])object).length;
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        int n4 = 0;
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            dArray2[n4] = (Double)object2.getKey();
            dArray3[n4] = (double)((Integer)object2.getValue()).intValue() / d3;
            ++n4;
        }
        this.innerDistribution = new EnumeratedDistribution(randomGenerator, EnumeratedRealDistribution.createDistribution(dArray2, dArray3));
    }

    public EnumeratedRealDistribution(double[] dArray) {
        this(new Well19937c(), dArray);
    }

    private static List<Pair<Double, Double>> createDistribution(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
        ArrayList<Pair<Double, Double>> arrayList = new ArrayList<Pair<Double, Double>>(dArray.length);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            arrayList.add(new Pair<Double, Double>(dArray[i2], dArray2[i2]));
        }
        return arrayList;
    }

    @Override
    public double probability(double d2) {
        return this.innerDistribution.probability(d2);
    }

    @Override
    public double density(double d2) {
        return ((AbstractRealDistribution)this).probability(d2);
    }

    @Override
    public double cumulativeProbability(double d2) {
        double d3 = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            Pair<Double, Double> pair2;
            if (!(pair2.getKey() <= d2)) continue;
            d3 += pair.getValue().doubleValue();
        }
        return d3;
    }

    @Override
    public double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        double d3 = 0.0;
        double d4 = this.getSupportLowerBound();
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getValue() == 0.0) continue;
            d4 = pair.getKey();
            if (!((d3 += pair.getValue().doubleValue()) >= d2)) continue;
        }
        return d4;
    }

    @Override
    public double getNumericalMean() {
        double d2 = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            d2 += pair.getValue() * pair.getKey();
        }
        return d2;
    }

    @Override
    public double getNumericalVariance() {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            d2 += pair.getValue() * pair.getKey();
            d3 += pair.getValue() * pair.getKey() * pair.getKey();
        }
        double d4 = d2;
        return d3 - d4 * d4;
    }

    @Override
    public double getSupportLowerBound() {
        double d2 = Double.POSITIVE_INFINITY;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            Pair<Double, Double> pair2;
            if (!(pair2.getKey() < d2) || !(pair.getValue() > 0.0)) continue;
            d2 = pair.getKey();
        }
        return d2;
    }

    @Override
    public double getSupportUpperBound() {
        double d2 = Double.NEGATIVE_INFINITY;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            Pair<Double, Double> pair2;
            if (!(pair2.getKey() > d2) || !(pair.getValue() > 0.0)) continue;
            d2 = pair.getKey();
        }
        return d2;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public double sample() {
        return this.innerDistribution.sample();
    }
}

