/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractIntegerDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.EnumeratedDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumeratedIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20130308L;
    protected final EnumeratedDistribution<Integer> innerDistribution;

    public EnumeratedIntegerDistribution(int[] nArray, double[] dArray) {
        this(new Well19937c(), nArray, dArray);
    }

    public EnumeratedIntegerDistribution(RandomGenerator randomGenerator, int[] nArray, double[] dArray) {
        super(randomGenerator);
        this.innerDistribution = new EnumeratedDistribution(randomGenerator, EnumeratedIntegerDistribution.createDistribution(nArray, dArray));
    }

    public EnumeratedIntegerDistribution(RandomGenerator randomGenerator, int[] nArray) {
        super(randomGenerator);
        Object object;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = nArray2[i2];
            object = (Integer)hashMap.get(n2);
            if (object == null) {
                object = 0;
            }
            hashMap.put(n2, (Integer)object + 1);
        }
        int n3 = hashMap.size();
        double d2 = nArray.length;
        int[] nArray3 = new int[n3];
        object = new double[n3];
        int n4 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            nArray3[n4] = (Integer)entry.getKey();
            object[n4] = (double)((Integer)entry.getValue()).intValue() / d2;
            ++n4;
        }
        this.innerDistribution = new EnumeratedDistribution(randomGenerator, EnumeratedIntegerDistribution.createDistribution(nArray3, (double[])object));
    }

    public EnumeratedIntegerDistribution(int[] nArray) {
        this(new Well19937c(), nArray);
    }

    private static List<Pair<Integer, Double>> createDistribution(int[] nArray, double[] dArray) {
        if (nArray.length != dArray.length) {
            throw new DimensionMismatchException(dArray.length, nArray.length);
        }
        ArrayList<Pair<Integer, Double>> arrayList = new ArrayList<Pair<Integer, Double>>(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(new Pair<Integer, Double>(nArray[i2], dArray[i2]));
        }
        return arrayList;
    }

    @Override
    public double probability(int n) {
        return this.innerDistribution.probability(n);
    }

    @Override
    public double cumulativeProbability(int n) {
        double d2 = 0.0;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getKey() > n) continue;
            d2 += pair.getValue().doubleValue();
        }
        return d2;
    }

    @Override
    public double getNumericalMean() {
        double d2 = 0.0;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            d2 += pair.getValue() * (double)pair.getKey().intValue();
        }
        return d2;
    }

    @Override
    public double getNumericalVariance() {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            d2 += pair.getValue() * (double)pair.getKey().intValue();
            d3 += pair.getValue() * (double)pair.getKey().intValue() * (double)pair.getKey().intValue();
        }
        double d4 = d2;
        return d3 - d4 * d4;
    }

    @Override
    public int getSupportLowerBound() {
        int n = Integer.MAX_VALUE;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getKey() >= n || !(pair.getValue() > 0.0)) continue;
            n = pair.getKey();
        }
        return n;
    }

    @Override
    public int getSupportUpperBound() {
        int n = Integer.MIN_VALUE;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getKey() <= n || !(pair.getValue() > 0.0)) continue;
            n = pair.getKey();
        }
        return n;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public int sample() {
        return this.innerDistribution.sample();
    }
}

