/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotANumberException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotFiniteNumberException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumeratedDistribution<T>
implements Serializable {
    private static final long serialVersionUID = 20123308L;
    protected final RandomGenerator random;
    private final List<T> singletons;
    private final double[] probabilities;
    private final double[] cumulativeProbabilities;

    public EnumeratedDistribution(List<Pair<T, Double>> list) {
        this(new Well19937c(), list);
    }

    public EnumeratedDistribution(RandomGenerator object, List<Pair<T, Double>> list) {
        this.random = object;
        this.singletons = new ArrayList<T>(list.size());
        object = new double[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            double d2;
            Pair<T, Double> pair = list.get(i2);
            this.singletons.add(pair.getKey());
            double d3 = pair.getValue();
            if (d2 < 0.0) {
                throw new NotPositiveException(pair.getValue());
            }
            if (Double.isInfinite(d3)) {
                throw new NotFiniteNumberException(d3, new Object[0]);
            }
            if (Double.isNaN(d3)) {
                throw new NotANumberException();
            }
            object[i2] = d3;
        }
        this.probabilities = MathArrays.normalizeArray((double[])object, 1.0);
        this.cumulativeProbabilities = new double[this.probabilities.length];
        double d4 = 0.0;
        for (int i3 = 0; i3 < this.probabilities.length; ++i3) {
            this.cumulativeProbabilities[i3] = d4 += this.probabilities[i3];
        }
    }

    public void reseedRandomGenerator(long l) {
        this.random.setSeed(l);
    }

    double probability(T t) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.probabilities.length; ++i2) {
            if ((t != null || this.singletons.get(i2) != null) && (t == null || !t.equals(this.singletons.get(i2)))) continue;
            d2 += this.probabilities[i2];
        }
        return d2;
    }

    public List<Pair<T, Double>> getPmf() {
        ArrayList<Pair<T, Double>> arrayList = new ArrayList<Pair<T, Double>>(this.probabilities.length);
        for (int i2 = 0; i2 < this.probabilities.length; ++i2) {
            arrayList.add(new Pair<T, Double>(this.singletons.get(i2), this.probabilities[i2]));
        }
        return arrayList;
    }

    public T sample() {
        double d2 = this.random.nextDouble();
        int n = Arrays.binarySearch(this.cumulativeProbabilities, d2);
        if (n < 0) {
            n = -n - 1;
        }
        if (n >= 0 && n < this.probabilities.length && d2 < this.cumulativeProbabilities[n]) {
            return this.singletons.get(n);
        }
        return this.singletons.get(this.singletons.size() - 1);
    }

    public Object[] sample(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        Object[] objectArray = new Object[n];
        for (int i2 = 0; i2 < n; ++i2) {
            objectArray[i2] = this.sample();
        }
        return objectArray;
    }

    public T[] sample(int n, T[] objectArray) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        if (objectArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (objectArray.length < n) {
            Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            objectArray = objectArray2;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            objectArray[i2] = this.sample();
        }
        return objectArray;
    }
}

