/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.GammaDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;

public class ChiSquaredDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -8352658048349159782L;
    private final GammaDistribution gamma;
    private final double solverAbsoluteAccuracy;

    public ChiSquaredDistribution(double d2) {
        this(d2, 1.0E-9);
    }

    public ChiSquaredDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    public ChiSquaredDistribution(RandomGenerator randomGenerator, double d2) {
        this(randomGenerator, d2, 1.0E-9);
    }

    public ChiSquaredDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        this.gamma = new GammaDistribution(d2 / 2.0, 2.0);
        this.solverAbsoluteAccuracy = d3;
    }

    public double getDegreesOfFreedom() {
        return this.gamma.getShape() * 2.0;
    }

    public double density(double d2) {
        return this.gamma.density(d2);
    }

    public double logDensity(double d2) {
        return ((AbstractRealDistribution)this.gamma).logDensity(d2);
    }

    public double cumulativeProbability(double d2) {
        return this.gamma.cumulativeProbability(d2);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        return this.getDegreesOfFreedom();
    }

    public double getNumericalVariance() {
        return 2.0 * this.getDegreesOfFreedom();
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

