/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractIntegerDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.SaddlePointExpansion;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Beta;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class BinomialDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfTrials;
    private final double probabilityOfSuccess;

    public BinomialDistribution(int n, double d2) {
        this(new Well19937c(), n, d2);
    }

    public BinomialDistribution(RandomGenerator randomGenerator, int n, double d2) {
        super(randomGenerator);
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, n);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        this.probabilityOfSuccess = d2;
        this.numberOfTrials = n;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public double probability(int n) {
        double d2 = ((AbstractIntegerDistribution)this).logProbability(n);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return FastMath.exp(d2);
    }

    public double logProbability(int n) {
        if (this.numberOfTrials == 0) {
            if (n == 0) {
                return 0.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = n < 0 || n > this.numberOfTrials ? Double.NEGATIVE_INFINITY : SaddlePointExpansion.logBinomialProbability(n, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess);
        return d2;
    }

    public double cumulativeProbability(int n) {
        double d2 = n < 0 ? 0.0 : (n >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta(this.probabilityOfSuccess, (double)n + 1.0, this.numberOfTrials - n));
        return d2;
    }

    public double getNumericalMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    public double getNumericalVariance() {
        double d2 = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * d2 * (1.0 - d2);
    }

    public int getSupportLowerBound() {
        if (this.probabilityOfSuccess < 1.0) {
            return 0;
        }
        return this.numberOfTrials;
    }

    public int getSupportUpperBound() {
        if (this.probabilityOfSuccess > 0.0) {
            return this.numberOfTrials;
        }
        return 0;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

