/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

final class BetaDistribution$ChengBetaSampler {
    private BetaDistribution$ChengBetaSampler() {
    }

    static double sample(RandomGenerator randomGenerator, double d2, double d3) {
        double d4 = FastMath.min(d2, d3);
        double d5 = FastMath.max(d2, d3);
        if (d4 > 1.0) {
            return BetaDistribution$ChengBetaSampler.algorithmBB(randomGenerator, d2, d4, d5);
        }
        return BetaDistribution$ChengBetaSampler.algorithmBC(randomGenerator, d2, d5, d4);
    }

    private static double algorithmBB(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = d3 + d4;
        double d10 = FastMath.sqrt((d9 - 2.0) / (d3 * 2.0 * d4 - d9));
        double d11 = d3 + 1.0 / d10;
        do {
            double d12 = randomGenerator.nextDouble();
            double d13 = randomGenerator.nextDouble();
            double d14 = d10 * (FastMath.log(d12) - FastMath.log1p(-d12));
            d6 = d3 * FastMath.exp(d14);
            double d15 = d12;
            d8 = d11 * d14 - 1.3862944;
            double d16 = d3 + d8 - d6;
            double d17 = d15 * d15 * d13;
            if (d16 + 2.609438 >= d17 * 5.0 || d16 >= (d5 = FastMath.log(d17))) break;
            d7 = d9;
        } while (d8 + d7 * (FastMath.log(d7) - FastMath.log(d4 + d6)) < d5);
        d6 = FastMath.min(d6, Double.MAX_VALUE);
        if (Precision.equals(d3, d2)) {
            return d6 / (d4 + d6);
        }
        double d18 = d4;
        return d18 / (d18 + d6);
    }

    private static double algorithmBC(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        double d5;
        double d6 = d3 + d4;
        double d7 = 1.0 / d4;
        double d8 = d3 + 1.0 - d4;
        double d9 = d8 * (0.0138889 + d4 * 0.0416667) / (d3 * d7 - 0.777778);
        double d10 = 0.25 + (0.5 + 0.25 / d8) * d4;
        while (true) {
            double d11;
            double d12 = randomGenerator.nextDouble();
            double d13 = randomGenerator.nextDouble();
            double d14 = d12 * d13;
            double d15 = d12 * d14;
            if (d12 < 0.5) {
                if (d13 * 0.25 + d15 - d14 >= d9) {
                    continue;
                }
            } else {
                if (d15 <= 0.25) {
                    d11 = d7 * (FastMath.log(d12) - FastMath.log1p(-d12));
                    d5 = d3 * FastMath.exp(d11);
                    break;
                }
                if (d15 >= d10) continue;
            }
            d11 = d7 * (FastMath.log(d12) - FastMath.log1p(-d12));
            d5 = d3 * FastMath.exp(d11);
            double d16 = d6;
            if (d16 * (FastMath.log(d16) - FastMath.log(d4 + d5) + d11) - 1.3862944 >= FastMath.log(d15)) break;
        }
        d5 = FastMath.min(d5, Double.MAX_VALUE);
        if (Precision.equals(d3, d2)) {
            return d5 / (d4 + d5);
        }
        double d17 = d4;
        return d17 / (d17 + d5);
    }
}

