/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.IntegerDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomDataImpl;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public abstract class AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    private static final long serialVersionUID = -1146319659338487221L;
    @Deprecated
    protected final RandomDataImpl randomData = new RandomDataImpl();
    protected final RandomGenerator random;

    @Deprecated
    protected AbstractIntegerDistribution() {
        this.random = null;
    }

    protected AbstractIntegerDistribution(RandomGenerator randomGenerator) {
        this.random = randomGenerator;
    }

    public double cumulativeProbability(int n, int n2) {
        if (n2 < n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)n, n2, true);
        }
        return this.cumulativeProbability(n2) - this.cumulativeProbability(n);
    }

    public int inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        int n = this.getSupportLowerBound();
        if (d2 == 0.0) {
            return n;
        }
        if (n == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(n) >= d2) {
                return n;
            }
        } else {
            --n;
        }
        int n2 = this.getSupportUpperBound();
        if (d2 == 1.0) {
            return n2;
        }
        double d3 = this.getNumericalMean();
        double d4 = FastMath.sqrt(this.getNumericalVariance());
        boolean bl = !Double.isInfinite(d3) && !Double.isNaN(d3) && !Double.isInfinite(d4) && !Double.isNaN(d4) && d4 != 0.0;
        if (bl) {
            double d5;
            double d6;
            double d7 = FastMath.sqrt((1.0 - d2) / d2);
            double d8 = d3 - d7 * d4;
            if (d6 > (double)n) {
                n = (int)FastMath.ceil(d8) - 1;
            }
            d7 = 1.0 / d7;
            d8 = d3 + d7 * d4;
            if (d5 < (double)n2) {
                n2 = (int)FastMath.ceil(d8) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(d2, n, n2);
    }

    protected int solveInverseCumulativeProbability(double d2, int n, int n2) {
        while (n + 1 < n2) {
            double d3;
            int n3 = (n + n2) / 2;
            if (n3 < n || n3 > n2) {
                n3 = n + (n2 - n) / 2;
            }
            double d4 = this.checkedCumulativeProbability(n3);
            if (d3 >= d2) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        return n2;
    }

    public void reseedRandomGenerator(long l) {
        this.random.setSeed(l);
        this.randomData.reSeed(l);
    }

    public int sample() {
        AbstractIntegerDistribution abstractIntegerDistribution = this;
        return abstractIntegerDistribution.inverseCumulativeProbability(abstractIntegerDistribution.random.nextDouble());
    }

    public int[] sample(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        int[] nArray = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            nArray[i2] = this.sample();
        }
        return nArray;
    }

    private double checkedCumulativeProbability(int n) {
        double d2 = this.cumulativeProbability(n);
        if (Double.isNaN(d2)) {
            throw new MathInternalError(LocalizedFormats.DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, n);
        }
        return d2;
    }

    public double logProbability(int n) {
        return FastMath.log(this.probability(n));
    }
}

