/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.dfp;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.dfp.Dfp;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.dfp.DfpField;

public class DfpMath {
    private static final String POW_TRAP = "pow";

    private DfpMath() {
    }

    protected static Dfp[] split(DfpField dfpField, String string) {
        int n;
        Dfp[] dfpArray = new Dfp[2];
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = new char[string.length()];
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = string.charAt(n);
            if (cArray[n] >= '1' && cArray[n] <= '9') {
                bl = false;
            }
            if (cArray[n] == '.') {
                n3 += (400 - n3) % 4;
                bl = false;
            }
            if (n3 == dfpField.getRadixDigits() / 2 << 2) {
                n2 = n;
                break;
            }
            if (cArray[n] < '0' || cArray[n] > '9' || bl) continue;
            ++n3;
        }
        dfpArray[0] = dfpField.newDfp(new String(cArray, 0, n2));
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = string.charAt(n);
            if (cArray[n] < '0' || cArray[n] > '9' || n >= n2) continue;
            cArray[n] = 48;
        }
        dfpArray[1] = dfpField.newDfp(new String(cArray));
        return dfpArray;
    }

    protected static Dfp[] split(Dfp dfp) {
        Dfp[] dfpArray = new Dfp[2];
        Dfp dfp2 = dfp;
        Dfp dfp3 = dfp2.multiply(dfp2.power10K(dfp.getRadixDigits() / 2));
        dfpArray[0] = dfp.add(dfp3).subtract(dfp3);
        dfpArray[1] = dfp.subtract(dfpArray[0]);
        return dfpArray;
    }

    protected static Dfp[] splitMult(Dfp[] dfpArray, Dfp[] dfpArray2) {
        Dfp[] dfpArray3 = new Dfp[2];
        Dfp[] dfpArray4 = dfpArray3;
        dfpArray3[1] = dfpArray[0].getZero();
        dfpArray4[0] = dfpArray[0].multiply(dfpArray2[0]);
        if (dfpArray4[0].classify() == 1 || dfpArray4[0].equals(dfpArray4[1])) {
            return dfpArray4;
        }
        dfpArray4[1] = dfpArray[0].multiply(dfpArray2[1]).add(dfpArray[1].multiply(dfpArray2[0])).add(dfpArray[1].multiply(dfpArray2[1]));
        return dfpArray4;
    }

    protected static Dfp[] splitDiv(Dfp[] dfpArray, Dfp[] dfpArray2) {
        Dfp[] dfpArray3 = new Dfp[2];
        Dfp[] dfpArray4 = dfpArray3;
        dfpArray3[0] = dfpArray[0].divide(dfpArray2[0]);
        dfpArray4[1] = dfpArray[1].multiply(dfpArray2[0]).subtract(dfpArray[0].multiply(dfpArray2[1]));
        dfpArray4[1] = dfpArray4[1].divide(dfpArray2[0].multiply(dfpArray2[0]).add(dfpArray2[0].multiply(dfpArray2[1])));
        return dfpArray4;
    }

    protected static Dfp splitPow(Dfp[] dfpArray, int n) {
        int n2;
        boolean bl = false;
        Dfp[] dfpArray2 = new Dfp[2];
        Dfp[] dfpArray3 = new Dfp[2];
        Dfp[] dfpArray4 = dfpArray3;
        dfpArray3[0] = dfpArray[0].getOne();
        dfpArray4[1] = dfpArray[0].getZero();
        if (n == 0) {
            return dfpArray4[0].add(dfpArray4[1]);
        }
        if (n < 0) {
            bl = true;
            n = -n;
        }
        do {
            int n3;
            dfpArray2[0] = new Dfp(dfpArray[0]);
            dfpArray2[1] = new Dfp(dfpArray[1]);
            n2 = 1;
            while (true) {
                n3 = n2;
                if ((n2 <<= 1) > n) break;
                dfpArray2 = DfpMath.splitMult(dfpArray2, dfpArray2);
            }
            n2 = n3;
            dfpArray4 = DfpMath.splitMult(dfpArray4, dfpArray2);
        } while ((n -= n2) > 0);
        dfpArray4[0] = dfpArray4[0].add(dfpArray4[1]);
        if (bl) {
            dfpArray4[0] = dfpArray[0].getOne().divide(dfpArray4[0]);
        }
        return dfpArray4[0];
    }

    public static Dfp pow(Dfp dfp, int n) {
        int n2;
        boolean bl = false;
        Dfp dfp2 = dfp.getOne();
        if (n == 0) {
            return dfp2;
        }
        if (n < 0) {
            bl = true;
            n = -n;
        }
        do {
            int n3;
            Dfp dfp3;
            Dfp dfp4 = new Dfp(dfp);
            n2 = 1;
            do {
                dfp3 = new Dfp(dfp4);
                n3 = n2;
                Dfp dfp5 = dfp4;
                dfp4 = dfp5.multiply(dfp5);
            } while (n > (n2 <<= 1));
            dfp4 = dfp3;
            n2 = n3;
            dfp2 = dfp2.multiply(dfp4);
        } while ((n -= n2) > 0);
        if (bl) {
            dfp2 = dfp.getOne().divide(dfp2);
        }
        return dfp.newInstance(dfp2);
    }

    public static Dfp exp(Dfp dfp) {
        Dfp dfp2 = dfp.rint();
        Dfp dfp3 = dfp.subtract(dfp2);
        int n = dfp2.intValue();
        if (n > 0x7FFFFFFE) {
            return dfp.newInstance((byte)1, (byte)1);
        }
        if (n < -2147483646) {
            return dfp.newInstance();
        }
        dfp = DfpMath.splitPow(dfp.getField().getESplit(), n);
        Dfp dfp4 = DfpMath.expInternal(dfp3);
        return dfp.multiply(dfp4);
    }

    protected static Dfp expInternal(Dfp dfp) {
        Dfp dfp2 = dfp.getOne();
        Dfp dfp3 = dfp.getOne();
        Dfp dfp4 = dfp.getOne();
        Dfp dfp5 = new Dfp(dfp2);
        for (int i2 = 1; i2 < 90 && !(dfp2 = dfp2.add((dfp3 = dfp3.multiply(dfp)).multiply(dfp4 = dfp4.divide(i2)))).equals(dfp5); ++i2) {
            dfp5 = new Dfp(dfp2);
        }
        return dfp2;
    }

    public static Dfp log(Dfp dfp) {
        int n;
        block7: {
            block6: {
                n = 0;
                Dfp dfp2 = dfp;
                if (dfp2.equals(dfp2.getZero())) break block6;
                Dfp dfp3 = dfp;
                if (!dfp3.lessThan(dfp3.getZero()) && !dfp.isNaN()) break block7;
            }
            dfp.getField().setIEEEFlagsBits(1);
            Dfp dfp4 = dfp;
            return dfp.dotrap(1, "ln", dfp4, dfp4.newInstance((byte)1, (byte)3));
        }
        if (dfp.classify() == 1) {
            return dfp;
        }
        Dfp[] dfpArray = new Dfp(dfp);
        int n2 = dfpArray.log10K();
        dfpArray = dfpArray.divide(DfpMath.pow(dfp.newInstance(10000), n2));
        int n3 = dfpArray.floor().intValue();
        while (n3 > 2) {
            n3 >>= 1;
            ++n;
        }
        dfpArray = DfpMath.split((Dfp)dfpArray);
        Dfp[] dfpArray2 = new Dfp[2];
        Dfp[] dfpArray3 = dfpArray2;
        dfpArray2[0] = DfpMath.pow(dfp.getTwo(), n);
        dfpArray[0] = dfpArray[0].divide(dfpArray3[0]);
        dfpArray[1] = dfpArray[1].divide(dfpArray3[0]);
        dfpArray3[0] = dfp.newInstance("1.33333");
        while (dfpArray[0].add(dfpArray[1]).greaterThan(dfpArray3[0])) {
            dfpArray[0] = dfpArray[0].divide(2);
            dfpArray[1] = dfpArray[1].divide(2);
            ++n;
        }
        Dfp[] dfpArray4 = DfpMath.logInternal(dfpArray);
        dfpArray[0] = dfp.newInstance("" + (n + 4 * n2));
        dfpArray[1] = dfp.getZero();
        dfpArray3 = DfpMath.splitMult(dfp.getField().getLn2Split(), dfpArray);
        dfpArray4[0] = dfpArray4[0].add(dfpArray3[0]);
        dfpArray4[1] = dfpArray4[1].add(dfpArray3[1]);
        dfpArray[0] = dfp.newInstance("" + 4 * n2);
        dfpArray[1] = dfp.getZero();
        dfpArray3 = DfpMath.splitMult(dfp.getField().getLn5Split(), dfpArray);
        dfpArray4[0] = dfpArray4[0].add(dfpArray3[0]);
        dfpArray4[1] = dfpArray4[1].add(dfpArray3[1]);
        return dfp.newInstance(dfpArray4[0].add(dfpArray4[1]));
    }

    protected static Dfp[] logInternal(Dfp[] dfpArray) {
        Dfp dfp = dfpArray[0].divide(4).add(dfpArray[1].divide(4));
        Dfp dfp2 = dfp.add(dfpArray[0].newInstance("-0.25")).divide(dfp.add(dfpArray[0].newInstance("0.25")));
        Dfp dfp3 = new Dfp(dfp2);
        Dfp dfp4 = new Dfp(dfp2);
        Dfp dfp5 = new Dfp(dfp3);
        int n = 1;
        for (int i2 = 0; i2 < 10000; ++i2) {
            dfp4 = dfp4.multiply(dfp2);
            dfp = (dfp4 = dfp4.multiply(dfp2)).divide(n += 2);
            if ((dfp3 = dfp3.add(dfp)).equals(dfp5)) break;
            dfp5 = new Dfp(dfp3);
        }
        dfp3 = dfp3.multiply(dfpArray[0].getTwo());
        return DfpMath.split(dfp3);
    }

    public static Dfp pow(Dfp dfp, Dfp dfp2) {
        if (dfp.getField().getRadixDigits() != dfp2.getField().getRadixDigits()) {
            dfp.getField().setIEEEFlagsBits(1);
            Dfp dfp3 = dfp;
            Dfp dfp4 = dfp3.newInstance(dfp3.getZero());
            dfp3.newInstance(dfp3.getZero()).nans = (byte)3;
            return dfp.dotrap(1, POW_TRAP, dfp, dfp4);
        }
        Dfp dfp5 = dfp.getZero();
        Dfp dfp6 = dfp.getOne();
        Dfp dfp7 = dfp.getTwo();
        boolean bl = false;
        if (dfp2.equals(dfp5)) {
            return dfp.newInstance(dfp6);
        }
        if (dfp2.equals(dfp6)) {
            if (dfp.isNaN()) {
                dfp.getField().setIEEEFlagsBits(1);
                Dfp dfp8 = dfp;
                return dfp.dotrap(1, POW_TRAP, dfp8, dfp8);
            }
            return dfp;
        }
        if (dfp.isNaN() || dfp2.isNaN()) {
            dfp.getField().setIEEEFlagsBits(1);
            Dfp dfp9 = dfp;
            return dfp.dotrap(1, POW_TRAP, dfp9, dfp9.newInstance((byte)1, (byte)3));
        }
        if (dfp.equals(dfp5)) {
            if (Dfp.copysign(dfp6, dfp).greaterThan(dfp5)) {
                if (dfp2.greaterThan(dfp5)) {
                    return dfp.newInstance(dfp5);
                }
                Dfp dfp10 = dfp;
                return dfp10.newInstance(dfp10.newInstance((byte)1, (byte)1));
            }
            if (dfp2.classify() == 0 && dfp2.rint().equals(dfp2) && !dfp2.remainder(dfp7).equals(dfp5)) {
                if (dfp2.greaterThan(dfp5)) {
                    return dfp.newInstance(dfp5.negate());
                }
                Dfp dfp11 = dfp;
                return dfp11.newInstance(dfp11.newInstance((byte)-1, (byte)1));
            }
            if (dfp2.greaterThan(dfp5)) {
                return dfp.newInstance(dfp5);
            }
            Dfp dfp12 = dfp;
            return dfp12.newInstance(dfp12.newInstance((byte)1, (byte)1));
        }
        if (dfp.lessThan(dfp5)) {
            dfp = dfp.negate();
            bl = true;
        }
        if (dfp.greaterThan(dfp6) && dfp2.classify() == 1) {
            if (dfp2.greaterThan(dfp5)) {
                return dfp2;
            }
            return dfp.newInstance(dfp5);
        }
        if (dfp.lessThan(dfp6) && dfp2.classify() == 1) {
            if (dfp2.greaterThan(dfp5)) {
                return dfp.newInstance(dfp5);
            }
            return dfp.newInstance(Dfp.copysign(dfp2, dfp6));
        }
        if (dfp.equals(dfp6) && dfp2.classify() == 1) {
            dfp.getField().setIEEEFlagsBits(1);
            Dfp dfp13 = dfp;
            return dfp.dotrap(1, POW_TRAP, dfp13, dfp13.newInstance((byte)1, (byte)3));
        }
        if (dfp.classify() == 1) {
            if (bl) {
                if (dfp2.classify() == 0 && dfp2.rint().equals(dfp2) && !dfp2.remainder(dfp7).equals(dfp5)) {
                    if (dfp2.greaterThan(dfp5)) {
                        Dfp dfp14 = dfp;
                        return dfp14.newInstance(dfp14.newInstance((byte)-1, (byte)1));
                    }
                    return dfp.newInstance(dfp5.negate());
                }
                if (dfp2.greaterThan(dfp5)) {
                    Dfp dfp15 = dfp;
                    return dfp15.newInstance(dfp15.newInstance((byte)1, (byte)1));
                }
                return dfp.newInstance(dfp5);
            }
            if (dfp2.greaterThan(dfp5)) {
                return dfp;
            }
            return dfp.newInstance(dfp5);
        }
        if (bl && !dfp2.rint().equals(dfp2)) {
            dfp.getField().setIEEEFlagsBits(1);
            Dfp dfp16 = dfp;
            return dfp.dotrap(1, POW_TRAP, dfp16, dfp16.newInstance((byte)1, (byte)3));
        }
        if (dfp2.lessThan(dfp.newInstance(100000000)) && dfp2.greaterThan(dfp.newInstance(-100000000))) {
            Dfp dfp17 = dfp2.rint();
            int n = dfp17.intValue();
            if ((dfp17 = dfp2.subtract(dfp17)).unequal(dfp5)) {
                dfp17 = dfp17.multiply(DfpMath.log(dfp));
                Dfp dfp18 = dfp17.divide(dfp.getField().getLn2()).rint();
                dfp17 = dfp17.subtract(dfp18.multiply(dfp.getField().getLn2()));
                dfp6 = DfpMath.splitPow(DfpMath.split(dfp), n);
                dfp6 = dfp6.multiply(DfpMath.pow(dfp7, dfp18.intValue()));
                dfp6 = dfp6.multiply(DfpMath.exp(dfp17));
            } else {
                dfp6 = DfpMath.splitPow(DfpMath.split(dfp), n);
            }
        } else {
            dfp6 = DfpMath.exp(DfpMath.log(dfp).multiply(dfp2));
        }
        if (bl && dfp2.rint().equals(dfp2) && !dfp2.remainder(dfp7).equals(dfp5)) {
            dfp6 = dfp6.negate();
        }
        return dfp.newInstance(dfp6);
    }

    protected static Dfp sinInternal(Dfp[] object) {
        Dfp dfp;
        Dfp dfp2 = dfp = object[0].add(object[1]);
        Dfp dfp3 = dfp;
        dfp = dfp3.multiply(dfp3);
        Dfp dfp4 = dfp2;
        object = object[0].getOne();
        Dfp dfp5 = new Dfp(dfp2);
        for (int i2 = 3; i2 < 90; i2 += 2) {
            dfp4 = dfp4.multiply(dfp);
            if ((dfp2 = dfp2.add((dfp4 = dfp4.negate()).multiply((Dfp)(object = ((Dfp)object).divide((i2 - 1) * i2))))).equals(dfp5)) break;
            dfp5 = new Dfp(dfp2);
        }
        return dfp2;
    }

    protected static Dfp cosInternal(Dfp[] object) {
        Dfp dfp;
        Dfp dfp2 = dfp = object[0].getOne();
        Dfp dfp3 = dfp;
        object = object[0].add(object[1]);
        object = object.multiply((Dfp)object);
        Dfp dfp4 = new Dfp(dfp3);
        for (int i2 = 2; i2 < 90; i2 += 2) {
            dfp2 = dfp2.multiply((Dfp)object);
            if ((dfp3 = dfp3.add((dfp2 = dfp2.negate()).multiply(dfp = dfp.divide((i2 - 1) * i2)))).equals(dfp4)) break;
            dfp4 = new Dfp(dfp3);
        }
        return dfp3;
    }

    public static Dfp sin(Dfp dfp) {
        Object object = dfp.getField().getPi();
        Dfp[] dfpArray = dfp.getField().getZero();
        boolean bl = false;
        Dfp dfp2 = dfp.remainder(((Dfp)object).multiply(2));
        if (dfp2.lessThan((Dfp)dfpArray)) {
            dfp2 = dfp2.negate();
            bl = true;
        }
        if (dfp2.greaterThan(((Dfp)object).divide(2))) {
            dfp2 = ((Dfp)object).subtract(dfp2);
        }
        if (dfp2.lessThan(((Dfp)object).divide(4))) {
            object = DfpMath.sinInternal(DfpMath.split(dfp2));
        } else {
            object = new Dfp[2];
            dfpArray = dfp.getField().getPiSplit();
            object[0] = dfpArray[0].divide(2).subtract(dfp2);
            object[1] = dfpArray[1].divide(2);
            object = DfpMath.cosInternal((Dfp[])object);
        }
        if (bl) {
            object = ((Dfp)object).negate();
        }
        return dfp.newInstance((Dfp)object);
    }

    public static Dfp cos(Dfp dfp) {
        Object object = dfp.getField().getPi();
        Dfp[] dfpArray = dfp.getField().getZero();
        boolean bl = false;
        Dfp dfp2 = dfp.remainder(((Dfp)object).multiply(2));
        if (dfp2.lessThan((Dfp)dfpArray)) {
            dfp2 = dfp2.negate();
        }
        if (dfp2.greaterThan(((Dfp)object).divide(2))) {
            dfp2 = ((Dfp)object).subtract(dfp2);
            bl = true;
        }
        if (dfp2.lessThan(((Dfp)object).divide(4))) {
            Dfp[] dfpArray2 = new Dfp[2];
            object = dfpArray2;
            dfpArray2[0] = dfp2;
            object[1] = dfpArray;
            object = DfpMath.cosInternal((Dfp[])object);
        } else {
            object = new Dfp[2];
            dfpArray = dfp.getField().getPiSplit();
            object[0] = dfpArray[0].divide(2).subtract(dfp2);
            object[1] = dfpArray[1].divide(2);
            object = DfpMath.sinInternal((Dfp[])object);
        }
        if (bl) {
            object = ((Dfp)object).negate();
        }
        return dfp.newInstance((Dfp)object);
    }

    public static Dfp tan(Dfp dfp) {
        return DfpMath.sin(dfp).divide(DfpMath.cos(dfp));
    }

    protected static Dfp atanInternal(Dfp dfp) {
        Dfp dfp2 = new Dfp(dfp);
        Dfp dfp3 = new Dfp(dfp2);
        Dfp dfp4 = new Dfp(dfp2);
        for (int i2 = 3; i2 < 90; i2 += 2) {
            dfp3 = dfp3.multiply(dfp);
            dfp3 = dfp3.multiply(dfp);
            if ((dfp2 = dfp2.add((dfp3 = dfp3.negate()).divide(i2))).equals(dfp4)) break;
            dfp4 = new Dfp(dfp2);
        }
        return dfp2;
    }

    public static Dfp atan(Dfp dfp) {
        Object object = dfp.getField().getZero();
        Dfp dfp2 = dfp.getField().getOne();
        Dfp[] dfpArray = dfp.getField().getSqr2Split();
        Dfp[] dfpArray2 = dfp.getField().getPiSplit();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Dfp[] dfpArray3 = dfpArray[0].subtract(dfp2).add(dfpArray[1]);
        Dfp dfp3 = new Dfp(dfp);
        if (dfp3.lessThan((Dfp)object)) {
            bl2 = true;
            dfp3 = dfp3.negate();
        }
        if (dfp3.greaterThan(dfp2)) {
            bl = true;
            dfp3 = dfp2.divide(dfp3);
        }
        if (dfp3.greaterThan((Dfp)dfpArray3)) {
            object = new Dfp[2];
            bl3 = true;
            object[0] = dfpArray[0].subtract(dfp2);
            object[1] = dfpArray[1];
            dfpArray = DfpMath.split(dfp3);
            Dfp[] dfpArray4 = DfpMath.splitMult(dfpArray, (Dfp[])object);
            dfpArray3 = dfpArray4;
            dfpArray4[0] = dfpArray3[0].add(dfp2);
            dfpArray[0] = dfpArray[0].subtract((Dfp)object[0]);
            dfpArray[1] = dfpArray[1].subtract((Dfp)object[1]);
            dfpArray = DfpMath.splitDiv(dfpArray, dfpArray3);
            dfp3 = dfpArray[0].add(dfpArray[1]);
        }
        object = DfpMath.atanInternal(dfp3);
        if (bl3) {
            object = ((Dfp)object).add(dfpArray2[0].divide(8)).add(dfpArray2[1].divide(8));
        }
        if (bl) {
            object = dfpArray2[0].divide(2).subtract((Dfp)object).add(dfpArray2[1].divide(2));
        }
        if (bl2) {
            object = ((Dfp)object).negate();
        }
        return dfp.newInstance((Dfp)object);
    }

    public static Dfp asin(Dfp dfp) {
        Dfp dfp2 = dfp;
        Dfp dfp3 = dfp;
        return DfpMath.atan(dfp2.divide(dfp2.getOne().subtract(dfp3.multiply(dfp3)).sqrt()));
    }

    public static Dfp acos(Dfp dfp) {
        boolean bl = false;
        Dfp dfp2 = dfp;
        if (dfp2.lessThan(dfp2.getZero())) {
            bl = true;
        }
        Dfp dfp3 = dfp;
        Dfp dfp4 = dfp = Dfp.copysign(dfp3, dfp3.getOne());
        Dfp dfp5 = DfpMath.atan(dfp.getOne().subtract(dfp4.multiply(dfp4)).sqrt().divide(dfp));
        if (bl) {
            dfp5 = dfp.getField().getPi().subtract(dfp5);
        }
        return dfp.newInstance(dfp5);
    }
}

