/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.dfp;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.dfp.Dfp$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.dfp.DfpField;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.dfp.DfpField$RoundingMode;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.dfp.DfpMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dfp
implements RealFieldElement<Dfp> {
    public static final int RADIX = 10000;
    public static final int MIN_EXP = -32767;
    public static final int MAX_EXP = 32768;
    public static final int ERR_SCALE = 32760;
    public static final byte FINITE = 0;
    public static final byte INFINITE = 1;
    public static final byte SNAN = 2;
    public static final byte QNAN = 3;
    private static final String NAN_STRING = "NaN";
    private static final String POS_INFINITY_STRING = "Infinity";
    private static final String NEG_INFINITY_STRING = "-Infinity";
    private static final String ADD_TRAP = "add";
    private static final String MULTIPLY_TRAP = "multiply";
    private static final String DIVIDE_TRAP = "divide";
    private static final String SQRT_TRAP = "sqrt";
    private static final String ALIGN_TRAP = "align";
    private static final String TRUNC_TRAP = "trunc";
    private static final String NEXT_AFTER_TRAP = "nextAfter";
    private static final String LESS_THAN_TRAP = "lessThan";
    private static final String GREATER_THAN_TRAP = "greaterThan";
    private static final String NEW_INSTANCE_TRAP = "newInstance";
    protected int[] mant;
    protected byte sign;
    protected int exp;
    protected byte nans;
    private final DfpField field;

    protected Dfp(DfpField dfpField) {
        this.mant = new int[dfpField.getRadixDigits()];
        this.sign = 1;
        this.exp = 0;
        this.nans = 0;
        this.field = dfpField;
    }

    protected Dfp(DfpField dfpField, byte by) {
        this(dfpField, (long)by);
    }

    protected Dfp(DfpField dfpField, int n) {
        this(dfpField, (long)n);
    }

    protected Dfp(DfpField dfpField, long l) {
        this.mant = new int[dfpField.getRadixDigits()];
        this.nans = 0;
        this.field = dfpField;
        int n = 0;
        if (l == Long.MIN_VALUE) {
            n = 1;
            ++l;
        }
        if (l < 0L) {
            this.sign = (byte)-1;
            l = -l;
        } else {
            this.sign = 1;
        }
        this.exp = 0;
        while (l != 0L) {
            System.arraycopy(this.mant, this.mant.length - this.exp, this.mant, this.mant.length - 1 - this.exp, this.exp);
            this.mant[this.mant.length - 1] = (int)(l % 10000L);
            l /= 10000L;
            ++this.exp;
        }
        if (n != 0) {
            for (n = 0; n < this.mant.length - 1; ++n) {
                if (this.mant[n] == 0) continue;
                int n2 = n;
                this.mant[n2] = this.mant[n2] + 1;
                return;
            }
        }
    }

    protected Dfp(DfpField dfpField, double d2) {
        this.mant = new int[dfpField.getRadixDigits()];
        this.sign = 1;
        this.exp = 0;
        this.nans = 0;
        this.field = dfpField;
        long l = Double.doubleToLongBits(d2);
        long l2 = l & 0xFFFFFFFFFFFFFL;
        int n = (int)((l & 0x7FF0000000000000L) >> 52) - 1023;
        if (n == -1023) {
            if (d2 == 0.0) {
                if ((l & Long.MIN_VALUE) != 0L) {
                    this.sign = (byte)-1;
                }
                return;
            }
            ++n;
            while ((l2 & 0x10000000000000L) == 0L) {
                --n;
                l2 <<= 1;
            }
            l2 &= 0xFFFFFFFFFFFFFL;
        }
        if (n == 1024) {
            double d3 = d2;
            if (d3 != d3) {
                this.sign = 1;
                this.nans = (byte)3;
                return;
            }
            if (d2 < 0.0) {
                this.sign = (byte)-1;
                this.nans = 1;
                return;
            }
            this.sign = 1;
            this.nans = 1;
            return;
        }
        Dfp dfp = new Dfp(dfpField, l2);
        dfp = dfp.divide(new Dfp(dfpField, 0x10000000000000L)).add(dfpField.getOne());
        dfp = dfp.multiply(DfpMath.pow(dfpField.getTwo(), n));
        if ((l & Long.MIN_VALUE) != 0L) {
            dfp = dfp.negate();
        }
        System.arraycopy(dfp.mant, 0, this.mant, 0, this.mant.length);
        this.sign = dfp.sign;
        this.exp = dfp.exp;
        this.nans = dfp.nans;
    }

    public Dfp(Dfp dfp) {
        this.mant = (int[])dfp.mant.clone();
        this.sign = dfp.sign;
        this.exp = dfp.exp;
        this.nans = dfp.nans;
        this.field = dfp.field;
    }

    protected Dfp(DfpField dfpField, String string) {
        int n;
        int n2;
        String string2;
        this.mant = new int[dfpField.getRadixDigits()];
        this.sign = 1;
        this.exp = 0;
        this.nans = 0;
        this.field = dfpField;
        int n3 = 0;
        char[] cArray = new char[(this.getRadixDigits() << 2) + 8];
        if (string.equals(POS_INFINITY_STRING)) {
            this.sign = 1;
            this.nans = 1;
            return;
        }
        if (string.equals(NEG_INFINITY_STRING)) {
            this.sign = (byte)-1;
            this.nans = 1;
            return;
        }
        if (string.equals(NAN_STRING)) {
            this.sign = 1;
            this.nans = (byte)3;
            return;
        }
        int n4 = string.indexOf("e");
        if (n4 == -1) {
            n4 = string.indexOf("E");
        }
        int n5 = 0;
        if (n4 != -1) {
            string2 = string.substring(0, n4);
            string = string.substring(n4 + 1);
            n2 = 0;
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) == '-') {
                    n2 = 1;
                    continue;
                }
                if (string.charAt(n) < '0' || string.charAt(n) > '9') continue;
                n5 = n5 * 10 + string.charAt(n) - 48;
            }
            if (n2 != 0) {
                n5 = -n5;
            }
        } else {
            string2 = string;
        }
        if (string2.indexOf("-") != -1) {
            this.sign = (byte)-1;
        }
        n4 = 0;
        int n6 = 0;
        while (string2.charAt(n4) < '1' || string2.charAt(n4) > '9') {
            if (n3 != 0 && string2.charAt(n4) == '0') {
                --n6;
            }
            if (string2.charAt(n4) == '.') {
                n3 = 1;
            }
            if (++n4 != string2.length()) continue;
        }
        n2 = 4;
        cArray[0] = 48;
        cArray[1] = 48;
        cArray[2] = 48;
        cArray[3] = 48;
        n = 0;
        while (n4 != string2.length() && n2 != (this.mant.length << 2) + 4 + 1) {
            if (string2.charAt(n4) == '.') {
                n3 = 1;
                n6 = n;
                ++n4;
                continue;
            }
            if (string2.charAt(n4) < '0' || string2.charAt(n4) > '9') {
                ++n4;
                continue;
            }
            cArray[n2] = string2.charAt(n4);
            ++n2;
            ++n4;
            ++n;
        }
        if (n3 != 0 && n2 != 4) {
            while (--n2 != 4 && cArray[n2] == '0') {
                --n;
            }
        }
        if (n3 != 0 && n == 0) {
            n6 = 0;
        }
        if (n3 == 0) {
            n6 = n2 - 4;
        }
        for (n4 = n - 1 + 4; n4 > 4 && cArray[n4] == '0'; --n4) {
        }
        n3 = (400 - n6 - n5 % 4) % 4;
        n2 = 4 - n3;
        n6 += n3;
        while (n4 - n2 < this.mant.length << 2) {
            for (n3 = 0; n3 < 4; ++n3) {
                cArray[++n4] = 48;
            }
        }
        for (n3 = this.mant.length - 1; n3 >= 0; --n3) {
            this.mant[n3] = (cArray[n2] - 48) * 1000 + (cArray[n2 + 1] - 48) * 100 + (cArray[n2 + 2] - 48) * 10 + (cArray[n2 + 3] - 48);
            n2 += 4;
        }
        this.exp = (n6 + n5) / 4;
        if (n2 < cArray.length) {
            this.round((cArray[n2] - 48) * 1000);
        }
    }

    protected Dfp(DfpField dfpField, byte by, byte by2) {
        this.field = dfpField;
        this.mant = new int[dfpField.getRadixDigits()];
        this.sign = by;
        this.exp = 0;
        this.nans = by2;
    }

    public Dfp newInstance() {
        return new Dfp(this.getField());
    }

    public Dfp newInstance(byte by) {
        return new Dfp(this.getField(), by);
    }

    public Dfp newInstance(int n) {
        return new Dfp(this.getField(), n);
    }

    public Dfp newInstance(long l) {
        return new Dfp(this.getField(), l);
    }

    public Dfp newInstance(double d2) {
        return new Dfp(this.getField(), d2);
    }

    public Dfp newInstance(Dfp dfp) {
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this;
            Dfp dfp3 = dfp2.newInstance(dfp2.getZero());
            dfp2.newInstance(dfp2.getZero()).nans = (byte)3;
            return this.dotrap(1, NEW_INSTANCE_TRAP, dfp, dfp3);
        }
        return new Dfp(dfp);
    }

    public Dfp newInstance(String string) {
        return new Dfp(this.field, string);
    }

    public Dfp newInstance(byte by, byte by2) {
        return this.field.newDfp(by, by2);
    }

    public DfpField getField() {
        return this.field;
    }

    public int getRadixDigits() {
        return this.field.getRadixDigits();
    }

    public Dfp getZero() {
        return this.field.getZero();
    }

    public Dfp getOne() {
        return this.field.getOne();
    }

    public Dfp getTwo() {
        return this.field.getTwo();
    }

    protected void shiftLeft() {
        for (int i2 = this.mant.length - 1; i2 > 0; --i2) {
            this.mant[i2] = this.mant[i2 - 1];
        }
        this.mant[0] = 0;
        --this.exp;
    }

    protected void shiftRight() {
        for (int i2 = 0; i2 < this.mant.length - 1; ++i2) {
            this.mant[i2] = this.mant[i2 + 1];
        }
        this.mant[this.mant.length - 1] = 0;
        ++this.exp;
    }

    protected int align(int n) {
        int n2;
        int n3 = 0;
        boolean bl = false;
        int n4 = n2 = this.exp - n;
        if (n2 < 0) {
            n4 = -n4;
        }
        if (n2 == 0) {
            return 0;
        }
        if (n4 > this.mant.length + 1) {
            Arrays.fill(this.mant, 0);
            this.exp = n;
            this.field.setIEEEFlagsBits(16);
            Dfp dfp = this;
            this.dotrap(16, ALIGN_TRAP, dfp, dfp);
            return 0;
        }
        for (n = 0; n < n4; ++n) {
            if (n2 < 0) {
                if (n3 != 0) {
                    bl = true;
                }
                n3 = this.mant[0];
                this.shiftRight();
                continue;
            }
            this.shiftLeft();
        }
        if (bl) {
            this.field.setIEEEFlagsBits(16);
            Dfp dfp = this;
            this.dotrap(16, ALIGN_TRAP, dfp, dfp);
        }
        return n3;
    }

    public boolean lessThan(Dfp dfp) {
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this;
            Dfp dfp3 = dfp2.newInstance(dfp2.getZero());
            dfp2.newInstance(dfp2.getZero()).nans = (byte)3;
            this.dotrap(1, LESS_THAN_TRAP, dfp, dfp3);
            return false;
        }
        if (this.isNaN() || dfp.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp4 = this;
            this.dotrap(1, LESS_THAN_TRAP, dfp, dfp4.newInstance(dfp4.getZero()));
            return false;
        }
        return Dfp.compare(this, dfp) < 0;
    }

    public boolean greaterThan(Dfp dfp) {
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this;
            Dfp dfp3 = dfp2.newInstance(dfp2.getZero());
            dfp2.newInstance(dfp2.getZero()).nans = (byte)3;
            this.dotrap(1, GREATER_THAN_TRAP, dfp, dfp3);
            return false;
        }
        if (this.isNaN() || dfp.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp4 = this;
            this.dotrap(1, GREATER_THAN_TRAP, dfp, dfp4.newInstance(dfp4.getZero()));
            return false;
        }
        return Dfp.compare(this, dfp) > 0;
    }

    public boolean negativeOrNull() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this;
            this.dotrap(1, LESS_THAN_TRAP, dfp, dfp.newInstance(this.getZero()));
            return false;
        }
        return this.sign < 0 || this.mant[this.mant.length - 1] == 0 && !this.isInfinite();
    }

    public boolean strictlyNegative() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this;
            this.dotrap(1, LESS_THAN_TRAP, dfp, dfp.newInstance(this.getZero()));
            return false;
        }
        return this.sign < 0 && (this.mant[this.mant.length - 1] != 0 || this.isInfinite());
    }

    public boolean positiveOrNull() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this;
            this.dotrap(1, LESS_THAN_TRAP, dfp, dfp.newInstance(this.getZero()));
            return false;
        }
        return this.sign > 0 || this.mant[this.mant.length - 1] == 0 && !this.isInfinite();
    }

    public boolean strictlyPositive() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this;
            this.dotrap(1, LESS_THAN_TRAP, dfp, dfp.newInstance(this.getZero()));
            return false;
        }
        return this.sign > 0 && (this.mant[this.mant.length - 1] != 0 || this.isInfinite());
    }

    @Override
    public Dfp abs() {
        Dfp dfp = this;
        Dfp dfp2 = dfp.newInstance(dfp);
        dfp.newInstance(dfp).sign = 1;
        return dfp2;
    }

    public boolean isInfinite() {
        return this.nans == 1;
    }

    public boolean isNaN() {
        return this.nans == 3 || this.nans == 2;
    }

    public boolean isZero() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this;
            this.dotrap(1, LESS_THAN_TRAP, dfp, dfp.newInstance(this.getZero()));
            return false;
        }
        return this.mant[this.mant.length - 1] == 0 && !this.isInfinite();
    }

    public boolean equals(Object object) {
        if (object instanceof Dfp) {
            object = (Dfp)object;
            if (this.isNaN() || ((Dfp)object).isNaN() || this.field.getRadixDigits() != ((Dfp)object).field.getRadixDigits()) {
                return false;
            }
            return Dfp.compare(this, (Dfp)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return 17 + (this.isZero() ? 0 : this.sign << 8) + (this.nans << 16) + this.exp + Arrays.hashCode(this.mant);
    }

    public boolean unequal(Dfp dfp) {
        if (this.isNaN() || dfp.isNaN() || this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            return false;
        }
        return this.greaterThan(dfp) || this.lessThan(dfp);
    }

    private static int compare(Dfp dfp, Dfp dfp2) {
        if (dfp.mant[dfp.mant.length - 1] == 0 && dfp2.mant[dfp2.mant.length - 1] == 0 && dfp.nans == 0 && dfp2.nans == 0) {
            return 0;
        }
        if (dfp.sign != dfp2.sign) {
            if (dfp.sign == -1) {
                return -1;
            }
            return 1;
        }
        if (dfp.nans == 1 && dfp2.nans == 0) {
            return dfp.sign;
        }
        if (dfp.nans == 0 && dfp2.nans == 1) {
            return -dfp2.sign;
        }
        if (dfp.nans == 1 && dfp2.nans == 1) {
            return 0;
        }
        if (dfp2.mant[dfp2.mant.length - 1] != 0 && dfp.mant[dfp2.mant.length - 1] != 0) {
            if (dfp.exp < dfp2.exp) {
                return -dfp.sign;
            }
            if (dfp.exp > dfp2.exp) {
                return dfp.sign;
            }
        }
        for (int i2 = dfp.mant.length - 1; i2 >= 0; --i2) {
            if (dfp.mant[i2] > dfp2.mant[i2]) {
                return dfp.sign;
            }
            if (dfp.mant[i2] >= dfp2.mant[i2]) continue;
            return -dfp.sign;
        }
        return 0;
    }

    @Override
    public Dfp rint() {
        return this.trunc(DfpField$RoundingMode.ROUND_HALF_EVEN);
    }

    @Override
    public Dfp floor() {
        return this.trunc(DfpField$RoundingMode.ROUND_FLOOR);
    }

    @Override
    public Dfp ceil() {
        return this.trunc(DfpField$RoundingMode.ROUND_CEIL);
    }

    @Override
    public Dfp remainder(Dfp dfp) {
        Dfp dfp2 = this;
        dfp = dfp2.subtract(dfp2.divide(dfp).rint().multiply(dfp));
        if (dfp.mant[this.mant.length - 1] == 0) {
            dfp.sign = this.sign;
        }
        return dfp;
    }

    protected Dfp trunc(DfpField$RoundingMode object) {
        boolean bl = false;
        if (this.isNaN()) {
            Dfp dfp = this;
            return dfp.newInstance(dfp);
        }
        if (this.nans == 1) {
            Dfp dfp = this;
            return dfp.newInstance(dfp);
        }
        if (this.mant[this.mant.length - 1] == 0) {
            Dfp dfp = this;
            return dfp.newInstance(dfp);
        }
        if (this.exp < 0) {
            this.field.setIEEEFlagsBits(16);
            Dfp dfp = this;
            Dfp dfp2 = dfp.newInstance(dfp.getZero());
            dfp2 = this.dotrap(16, TRUNC_TRAP, this, dfp2);
            return dfp2;
        }
        if (this.exp >= this.mant.length) {
            Dfp dfp = this;
            return dfp.newInstance(dfp);
        }
        Dfp dfp = this;
        Dfp dfp3 = dfp.newInstance(dfp);
        for (int i2 = 0; i2 < this.mant.length - dfp3.exp; ++i2) {
            bl |= dfp3.mant[i2] != 0;
            dfp3.mant[i2] = 0;
        }
        if (bl) {
            switch (Dfp$1.$SwitchMap$org$apache$commons$math3$dfp$DfpField$RoundingMode[((Enum)object).ordinal()]) {
                case 1: {
                    if (dfp3.sign != -1) break;
                    dfp3 = dfp3.add(this.newInstance(-1));
                    break;
                }
                case 2: {
                    if (dfp3.sign != 1) break;
                    dfp3 = dfp3.add(this.getOne());
                    break;
                }
                default: {
                    Dfp dfp4 = this.newInstance("0.5");
                    object = this.subtract(dfp3);
                    this.subtract(dfp3).sign = 1;
                    if (((Dfp)object).greaterThan(dfp4)) {
                        Dfp dfp5 = this;
                        object = dfp5.newInstance(dfp5.getOne());
                        dfp5.newInstance(dfp5.getOne()).sign = this.sign;
                        dfp3 = dfp3.add((Dfp)object);
                    }
                    if (!((Dfp)object).equals(dfp4) || dfp3.exp <= 0 || (dfp3.mant[this.mant.length - dfp3.exp] & 1) == 0) break;
                    Dfp dfp6 = this;
                    object = dfp6.newInstance(dfp6.getOne());
                    dfp6.newInstance(dfp6.getOne()).sign = this.sign;
                    dfp3 = dfp3.add((Dfp)object);
                }
            }
            this.field.setIEEEFlagsBits(16);
            dfp3 = this.dotrap(16, TRUNC_TRAP, this, dfp3);
            return dfp3;
        }
        return dfp3;
    }

    public int intValue() {
        int n = 0;
        Dfp dfp = this.rint();
        if (dfp.greaterThan(this.newInstance(Integer.MAX_VALUE))) {
            return Integer.MAX_VALUE;
        }
        if (dfp.lessThan(this.newInstance(Integer.MIN_VALUE))) {
            return Integer.MIN_VALUE;
        }
        for (int i2 = this.mant.length - 1; i2 >= this.mant.length - dfp.exp; --i2) {
            n = n * 10000 + dfp.mant[i2];
        }
        if (dfp.sign == -1) {
            n = -n;
        }
        return n;
    }

    public int log10K() {
        return this.exp - 1;
    }

    public Dfp power10K(int n) {
        Dfp dfp = this;
        Dfp dfp2 = dfp.newInstance(dfp.getOne());
        dfp.newInstance(dfp.getOne()).exp = n + 1;
        return dfp2;
    }

    public int intLog10() {
        if (this.mant[this.mant.length - 1] > 1000) {
            return (this.exp << 2) - 1;
        }
        if (this.mant[this.mant.length - 1] > 100) {
            return (this.exp << 2) - 2;
        }
        if (this.mant[this.mant.length - 1] > 10) {
            return (this.exp << 2) - 3;
        }
        return (this.exp << 2) - 4;
    }

    public Dfp power10(int n) {
        Dfp dfp = this;
        Dfp dfp2 = dfp.newInstance(dfp.getOne());
        dfp2.exp = n >= 0 ? n / 4 + 1 : (n + 1) / 4;
        switch ((n % 4 + 4) % 4) {
            case 0: {
                break;
            }
            case 1: {
                dfp2 = dfp2.multiply(10);
                break;
            }
            case 2: {
                dfp2 = dfp2.multiply(100);
                break;
            }
            default: {
                dfp2 = dfp2.multiply(1000);
            }
        }
        return dfp2;
    }

    protected int complement(int n) {
        int n2;
        n = 10000 - n;
        for (n2 = 0; n2 < this.mant.length; ++n2) {
            this.mant[n2] = 10000 - this.mant[n2] - 1;
        }
        n2 = n / 10000;
        n -= n2 * 10000;
        for (int i2 = 0; i2 < this.mant.length; ++i2) {
            int n3 = this.mant[i2] + n2;
            n2 = n3 / 10000;
            this.mant[i2] = n3 - n2 * 10000;
        }
        return n;
    }

    @Override
    public Dfp add(Dfp dfp) {
        int n;
        int n2;
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this;
            Dfp dfp3 = dfp2.newInstance(dfp2.getZero());
            dfp2.newInstance(dfp2.getZero()).nans = (byte)3;
            return this.dotrap(1, ADD_TRAP, dfp, dfp3);
        }
        if (this.nans != 0 || dfp.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (dfp.isNaN()) {
                return dfp;
            }
            if (this.nans == 1 && dfp.nans == 0) {
                return this;
            }
            if (dfp.nans == 1 && this.nans == 0) {
                return dfp;
            }
            if (dfp.nans == 1 && this.nans == 1 && this.sign == dfp.sign) {
                return dfp;
            }
            if (dfp.nans == 1 && this.nans == 1 && this.sign != dfp.sign) {
                this.field.setIEEEFlagsBits(1);
                Dfp dfp4 = this;
                Dfp dfp5 = dfp4.newInstance(dfp4.getZero());
                dfp4.newInstance(dfp4.getZero()).nans = (byte)3;
                dfp5 = this.dotrap(1, ADD_TRAP, dfp, dfp5);
                return dfp5;
            }
        }
        Dfp dfp6 = this;
        Dfp dfp7 = dfp6.newInstance(dfp6);
        Dfp dfp8 = this.newInstance(dfp);
        Dfp dfp9 = this;
        Dfp dfp10 = dfp9.newInstance(dfp9.getZero());
        byte by = dfp7.sign;
        byte by2 = dfp8.sign;
        dfp7.sign = 1;
        dfp8.sign = 1;
        byte by3 = by2;
        if (Dfp.compare(dfp7, dfp8) > 0) {
            by3 = by;
        }
        if (dfp8.mant[this.mant.length - 1] == 0) {
            dfp8.exp = dfp7.exp;
        }
        if (dfp7.mant[this.mant.length - 1] == 0) {
            dfp7.exp = dfp8.exp;
        }
        int n3 = 0;
        int n4 = 0;
        if (dfp7.exp < dfp8.exp) {
            n3 = dfp7.align(dfp8.exp);
        } else {
            n4 = dfp8.align(dfp7.exp);
        }
        if (by != by2) {
            if (by == by3) {
                n4 = dfp8.complement(n4);
            } else {
                n3 = dfp7.complement(n3);
            }
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.mant.length; ++n2) {
            n = dfp7.mant[n2] + dfp8.mant[n2] + n5;
            n5 = n / 10000;
            dfp10.mant[n2] = n - n5 * 10000;
        }
        dfp10.exp = dfp7.exp;
        dfp10.sign = by3;
        if (n5 != 0 && by == by2) {
            n2 = dfp10.mant[0];
            dfp10.shiftRight();
            dfp10.mant[this.mant.length - 1] = n5;
            n = dfp10.round(n2);
            if (n != 0) {
                dfp10 = this.dotrap(n, ADD_TRAP, dfp, dfp10);
            }
        }
        for (n2 = 0; n2 < this.mant.length && dfp10.mant[this.mant.length - 1] == 0; ++n2) {
            dfp10.shiftLeft();
            if (n2 != 0) continue;
            dfp10.mant[0] = n3 + n4;
            n3 = 0;
            n4 = 0;
        }
        if (dfp10.mant[this.mant.length - 1] == 0) {
            dfp10.exp = 0;
            if (by != by2) {
                dfp10.sign = 1;
            }
        }
        if ((n2 = dfp10.round(n3 + n4)) != 0) {
            dfp10 = this.dotrap(n2, ADD_TRAP, dfp, dfp10);
        }
        return dfp10;
    }

    @Override
    public Dfp negate() {
        Dfp dfp = this;
        Dfp dfp2 = dfp.newInstance(dfp);
        dfp.newInstance(dfp).sign = -dfp2.sign;
        return dfp2;
    }

    @Override
    public Dfp subtract(Dfp dfp) {
        return this.add(dfp.negate());
    }

    protected int round(int n) {
        int n2;
        switch (this.field.getRoundingMode()) {
            case ROUND_DOWN: {
                int n3 = 0;
                break;
            }
            case ROUND_UP: {
                n2 = n != 0 ? 1 : 0;
                break;
            }
            case ROUND_HALF_UP: {
                n2 = n >= 5000 ? 1 : 0;
                break;
            }
            case ROUND_HALF_DOWN: {
                n2 = n > 5000 ? 1 : 0;
                break;
            }
            case ROUND_HALF_EVEN: {
                n2 = n > 5000 || n == 5000 && (this.mant[0] & 1) == 1 ? 1 : 0;
                break;
            }
            case ROUND_HALF_ODD: {
                n2 = n > 5000 || n == 5000 && (this.mant[0] & 1) == 0 ? 1 : 0;
                break;
            }
            case ROUND_CEIL: {
                n2 = this.sign == 1 && n != 0 ? 1 : 0;
                break;
            }
            default: {
                int n3 = n2 = this.sign == -1 && n != 0 ? 1 : 0;
            }
        }
        if (n2 != 0) {
            n2 = 1;
            for (int i2 = 0; i2 < this.mant.length; ++i2) {
                int n4 = this.mant[i2] + n2;
                n2 = n4 / 10000;
                this.mant[i2] = n4 - n2 * 10000;
            }
            if (n2 != 0) {
                this.shiftRight();
                this.mant[this.mant.length - 1] = n2;
            }
        }
        if (this.exp < -32767) {
            this.field.setIEEEFlagsBits(8);
            return 8;
        }
        if (this.exp > 32768) {
            this.field.setIEEEFlagsBits(4);
            return 4;
        }
        if (n != 0) {
            this.field.setIEEEFlagsBits(16);
            return 16;
        }
        return 0;
    }

    @Override
    public Dfp multiply(Dfp dfp) {
        int n;
        int n2;
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this;
            Dfp dfp3 = dfp2.newInstance(dfp2.getZero());
            dfp2.newInstance(dfp2.getZero()).nans = (byte)3;
            return this.dotrap(1, MULTIPLY_TRAP, dfp, dfp3);
        }
        Dfp dfp4 = this;
        Dfp dfp5 = dfp4.newInstance(dfp4.getZero());
        if (this.nans != 0 || dfp.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (dfp.isNaN()) {
                return dfp;
            }
            if (this.nans == 1 && dfp.nans == 0 && dfp.mant[this.mant.length - 1] != 0) {
                Dfp dfp6 = this;
                dfp5 = dfp6.newInstance(dfp6);
                dfp6.newInstance(dfp6).sign = (byte)(this.sign * dfp.sign);
                return dfp5;
            }
            if (dfp.nans == 1 && this.nans == 0 && this.mant[this.mant.length - 1] != 0) {
                dfp5 = this.newInstance(dfp);
                this.newInstance(dfp).sign = (byte)(this.sign * dfp.sign);
                return dfp5;
            }
            if (dfp.nans == 1 && this.nans == 1) {
                Dfp dfp7 = this;
                dfp5 = dfp7.newInstance(dfp7);
                dfp7.newInstance(dfp7).sign = (byte)(this.sign * dfp.sign);
                return dfp5;
            }
            if (dfp.nans == 1 && this.nans == 0 && this.mant[this.mant.length - 1] == 0 || this.nans == 1 && dfp.nans == 0 && dfp.mant[this.mant.length - 1] == 0) {
                this.field.setIEEEFlagsBits(1);
                Dfp dfp8 = this;
                dfp5 = dfp8.newInstance(dfp8.getZero());
                dfp8.newInstance(dfp8.getZero()).nans = (byte)3;
                dfp5 = this.dotrap(1, MULTIPLY_TRAP, dfp, dfp5);
                return dfp5;
            }
        }
        int[] nArray = new int[this.mant.length << 1];
        for (n2 = 0; n2 < this.mant.length; ++n2) {
            n = 0;
            for (int i2 = 0; i2 < this.mant.length; ++i2) {
                int n3 = this.mant[n2] * dfp.mant[i2];
                n = (n3 += nArray[n2 + i2] + n) / 10000;
                nArray[n2 + i2] = n3 - n * 10000;
            }
            nArray[n2 + this.mant.length] = n;
        }
        n2 = (this.mant.length << 1) - 1;
        for (n = (this.mant.length << 1) - 1; n >= 0; --n) {
            if (nArray[n] == 0) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < this.mant.length; ++n) {
            dfp5.mant[this.mant.length - n - 1] = nArray[n2 - n];
        }
        dfp5.exp = this.exp + dfp.exp + n2 - 2 * this.mant.length + 1;
        dfp5.sign = (byte)(this.sign == dfp.sign ? 1 : -1);
        if (dfp5.mant[this.mant.length - 1] == 0) {
            dfp5.exp = 0;
        }
        if ((n = n2 > this.mant.length - 1 ? dfp5.round(nArray[n2 - this.mant.length]) : dfp5.round(0)) != 0) {
            dfp5 = this.dotrap(n, MULTIPLY_TRAP, dfp, dfp5);
        }
        return dfp5;
    }

    @Override
    public Dfp multiply(int n) {
        if (n >= 0 && n < 10000) {
            return this.multiplyFast(n);
        }
        Dfp dfp = this;
        return dfp.multiply(dfp.newInstance(n));
    }

    private Dfp multiplyFast(int n) {
        int n2;
        int n3;
        Dfp dfp = this;
        Dfp dfp2 = dfp.newInstance(dfp);
        if (this.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (this.nans == 1 && n != 0) {
                Dfp dfp3 = this;
                dfp2 = dfp3.newInstance(dfp3);
                return dfp2;
            }
            if (this.nans == 1 && n == 0) {
                this.field.setIEEEFlagsBits(1);
                Dfp dfp4 = this;
                dfp2 = dfp4.newInstance(dfp4.getZero());
                dfp4.newInstance(dfp4.getZero()).nans = (byte)3;
                Dfp dfp5 = this;
                dfp2 = this.dotrap(1, MULTIPLY_TRAP, dfp5.newInstance(dfp5.getZero()), dfp2);
                return dfp2;
            }
        }
        if (n < 0 || n >= 10000) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp6 = this;
            dfp2 = dfp6.newInstance(dfp6.getZero());
            dfp6.newInstance(dfp6.getZero()).nans = (byte)3;
            Dfp dfp7 = dfp2;
            dfp2 = this.dotrap(1, MULTIPLY_TRAP, dfp7, dfp7);
            return dfp2;
        }
        int n4 = 0;
        for (n3 = 0; n3 < this.mant.length; ++n3) {
            n2 = this.mant[n3] * n + n4;
            n4 = n2 / 10000;
            dfp2.mant[n3] = n2 - n4 * 10000;
        }
        n3 = 0;
        if (n4 != 0) {
            n3 = dfp2.mant[0];
            dfp2.shiftRight();
            dfp2.mant[this.mant.length - 1] = n4;
        }
        if (dfp2.mant[this.mant.length - 1] == 0) {
            dfp2.exp = 0;
        }
        if ((n2 = dfp2.round(n3)) != 0) {
            Dfp dfp8 = dfp2;
            dfp2 = this.dotrap(n2, MULTIPLY_TRAP, dfp8, dfp8);
        }
        return dfp2;
    }

    @Override
    public Dfp divide(Dfp dfp) {
        int n;
        int n2 = 0;
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this;
            Dfp dfp3 = dfp2.newInstance(dfp2.getZero());
            dfp2.newInstance(dfp2.getZero()).nans = (byte)3;
            return this.dotrap(1, DIVIDE_TRAP, dfp, dfp3);
        }
        Dfp dfp4 = this;
        Dfp dfp5 = dfp4.newInstance(dfp4.getZero());
        if (this.nans != 0 || dfp.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (dfp.isNaN()) {
                return dfp;
            }
            if (this.nans == 1 && dfp.nans == 0) {
                Dfp dfp6 = this;
                dfp5 = dfp6.newInstance(dfp6);
                dfp6.newInstance(dfp6).sign = (byte)(this.sign * dfp.sign);
                return dfp5;
            }
            if (dfp.nans == 1 && this.nans == 0) {
                Dfp dfp7 = this;
                dfp5 = dfp7.newInstance(dfp7.getZero());
                dfp7.newInstance(dfp7.getZero()).sign = (byte)(this.sign * dfp.sign);
                return dfp5;
            }
            if (dfp.nans == 1 && this.nans == 1) {
                this.field.setIEEEFlagsBits(1);
                Dfp dfp8 = this;
                dfp5 = dfp8.newInstance(dfp8.getZero());
                dfp8.newInstance(dfp8.getZero()).nans = (byte)3;
                dfp5 = this.dotrap(1, DIVIDE_TRAP, dfp, dfp5);
                return dfp5;
            }
        }
        if (dfp.mant[this.mant.length - 1] == 0) {
            this.field.setIEEEFlagsBits(2);
            Dfp dfp9 = this;
            dfp5 = dfp9.newInstance(dfp9.getZero());
            dfp9.newInstance(dfp9.getZero()).sign = (byte)(this.sign * dfp.sign);
            dfp5.nans = 1;
            dfp5 = this.dotrap(2, DIVIDE_TRAP, dfp, dfp5);
            return dfp5;
        }
        int[] nArray = new int[this.mant.length + 1];
        int[] nArray2 = new int[this.mant.length + 2];
        int[] nArray3 = new int[this.mant.length + 1];
        nArray[this.mant.length] = 0;
        nArray2[this.mant.length] = 0;
        nArray2[this.mant.length + 1] = 0;
        nArray3[this.mant.length] = 0;
        for (n = 0; n < this.mant.length; ++n) {
            nArray[n] = this.mant[n];
            nArray2[n] = 0;
            nArray3[n] = 0;
        }
        int n3 = 0;
        for (int i2 = this.mant.length + 1; i2 >= 0; --i2) {
            n = nArray[this.mant.length] * 10000 + nArray[this.mant.length - 1];
            int n4 = n / (dfp.mant[this.mant.length - 1] + 1);
            int n5 = (n + 1) / dfp.mant[this.mant.length - 1];
            boolean bl = false;
            while (!bl) {
                int n6;
                int n7;
                n2 = (n4 + n5) / 2;
                n = 0;
                for (n7 = 0; n7 < this.mant.length + 1; ++n7) {
                    n6 = n7 < this.mant.length ? dfp.mant[n7] : 0;
                    n6 = n6 * n2 + n;
                    n = n6 / 10000;
                    nArray3[n7] = n6 - n * 10000;
                }
                n = 1;
                for (n7 = 0; n7 < this.mant.length + 1; ++n7) {
                    n6 = 9999 - nArray3[n7] + nArray[n7] + n;
                    n = n6 / 10000;
                    nArray3[n7] = n6 - n * 10000;
                }
                if (n == 0) {
                    n5 = n2 - 1;
                    continue;
                }
                n = nArray3[this.mant.length] * 10000 + nArray3[this.mant.length - 1];
                if ((n /= dfp.mant[this.mant.length - 1] + 1) >= 2) {
                    n4 = n2 + n;
                    continue;
                }
                bl = false;
                for (n7 = this.mant.length - 1; n7 >= 0; --n7) {
                    if (dfp.mant[n7] > nArray3[n7]) {
                        bl = true;
                    }
                    if (dfp.mant[n7] < nArray3[n7]) break;
                }
                if (nArray3[this.mant.length] != 0) {
                    bl = false;
                }
                if (bl) continue;
                n4 = n2 + 1;
            }
            nArray2[i2] = n2;
            if (n2 != 0 || n3 != 0) {
                ++n3;
            }
            if (this.field.getRoundingMode() == DfpField$RoundingMode.ROUND_DOWN && n3 == this.mant.length || n3 > this.mant.length) break;
            nArray[0] = 0;
            for (n = 0; n < this.mant.length; ++n) {
                nArray[n + 1] = nArray3[n];
            }
        }
        int n8 = this.mant.length;
        for (n = this.mant.length + 1; n >= 0; --n) {
            if (nArray2[n] == 0) continue;
            n8 = n;
            break;
        }
        for (n = 0; n < this.mant.length; ++n) {
            dfp5.mant[this.mant.length - n - 1] = nArray2[n8 - n];
        }
        dfp5.exp = this.exp - dfp.exp + n8 - this.mant.length;
        dfp5.sign = (byte)(this.sign == dfp.sign ? 1 : -1);
        if (dfp5.mant[this.mant.length - 1] == 0) {
            dfp5.exp = 0;
        }
        if ((n8 = n8 > this.mant.length - 1 ? dfp5.round(nArray2[n8 - this.mant.length]) : dfp5.round(0)) != 0) {
            dfp5 = this.dotrap(n8, DIVIDE_TRAP, dfp, dfp5);
        }
        return dfp5;
    }

    @Override
    public Dfp divide(int n) {
        int n2;
        int n3;
        if (this.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (this.nans == 1) {
                Dfp dfp = this;
                return dfp.newInstance(dfp);
            }
        }
        if (n == 0) {
            this.field.setIEEEFlagsBits(2);
            Dfp dfp = this;
            Dfp dfp2 = dfp.newInstance(dfp.getZero());
            dfp.newInstance(dfp.getZero()).sign = this.sign;
            dfp2.nans = 1;
            dfp2 = this.dotrap(2, DIVIDE_TRAP, this.getZero(), dfp2);
            return dfp2;
        }
        if (n < 0 || n >= 10000) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this;
            Dfp dfp3 = dfp.newInstance(dfp.getZero());
            dfp.newInstance(dfp.getZero()).nans = (byte)3;
            Dfp dfp4 = dfp3;
            dfp3 = this.dotrap(1, DIVIDE_TRAP, dfp4, dfp4);
            return dfp3;
        }
        Dfp dfp = this;
        Dfp dfp5 = dfp.newInstance(dfp);
        int n4 = 0;
        for (n3 = this.mant.length - 1; n3 >= 0; --n3) {
            n2 = n4 * 10000 + dfp5.mant[n3];
            int n5 = n2 / n;
            n4 = n2 - n5 * n;
            dfp5.mant[n3] = n5;
        }
        if (dfp5.mant[this.mant.length - 1] == 0) {
            dfp5.shiftLeft();
            n3 = n4 * 10000;
            n2 = n3 / n;
            n4 = n3 - n2 * n;
            dfp5.mant[0] = n2;
        }
        if ((n3 = dfp5.round(n4 * 10000 / n)) != 0) {
            Dfp dfp6 = dfp5;
            dfp5 = this.dotrap(n3, DIVIDE_TRAP, dfp6, dfp6);
        }
        return dfp5;
    }

    @Override
    public Dfp reciprocal() {
        return this.field.getOne().divide(this);
    }

    @Override
    public Dfp sqrt() {
        if (this.nans == 0 && this.mant[this.mant.length - 1] == 0) {
            Dfp dfp = this;
            return dfp.newInstance(dfp);
        }
        if (this.nans != 0) {
            if (this.nans == 1 && this.sign == 1) {
                Dfp dfp = this;
                return dfp.newInstance(dfp);
            }
            if (this.nans == 3) {
                Dfp dfp = this;
                return dfp.newInstance(dfp);
            }
            if (this.nans == 2) {
                this.field.setIEEEFlagsBits(1);
                Dfp dfp = this;
                Dfp dfp2 = dfp.newInstance(dfp);
                dfp2 = this.dotrap(1, SQRT_TRAP, null, dfp2);
                return dfp2;
            }
        }
        if (this.sign == -1) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this;
            Dfp dfp3 = dfp.newInstance(dfp);
            dfp.newInstance(dfp).nans = (byte)3;
            dfp3 = this.dotrap(1, SQRT_TRAP, null, dfp3);
            return dfp3;
        }
        Dfp dfp = this;
        Dfp dfp4 = dfp.newInstance(dfp);
        if (dfp4.exp < -1 || dfp4.exp > 1) {
            dfp4.exp = this.exp / 2;
        }
        switch (dfp4.mant[this.mant.length - 1] / 2000) {
            case 0: {
                dfp4.mant[this.mant.length - 1] = dfp4.mant[this.mant.length - 1] / 2 + 1;
                break;
            }
            case 2: {
                dfp4.mant[this.mant.length - 1] = 1500;
                break;
            }
            case 3: {
                dfp4.mant[this.mant.length - 1] = 2200;
                break;
            }
            default: {
                dfp4.mant[this.mant.length - 1] = 3000;
            }
        }
        this.newInstance(dfp4);
        Dfp dfp5 = this.getZero();
        this.getZero();
        while (dfp4.unequal(dfp5)) {
            Dfp dfp6 = this.newInstance(dfp4);
            this.newInstance(dfp4).sign = (byte)-1;
            dfp6 = dfp6.add(this.divide(dfp4));
            dfp6 = dfp6.divide(2);
            Dfp dfp7 = dfp5;
            dfp5 = dfp4;
            if (!(dfp4 = dfp4.add(dfp6)).equals(dfp7) && dfp6.mant[this.mant.length - 1] != 0) continue;
        }
        return dfp4;
    }

    public String toString() {
        if (this.nans != 0) {
            if (this.nans == 1) {
                if (this.sign < 0) {
                    return NEG_INFINITY_STRING;
                }
                return POS_INFINITY_STRING;
            }
            return NAN_STRING;
        }
        if (this.exp > this.mant.length || this.exp < -1) {
            return this.dfp2sci();
        }
        return this.dfp2string();
    }

    protected String dfp2sci() {
        int n;
        int n2;
        char[] cArray = new char[this.mant.length << 2];
        char[] cArray2 = new char[(this.mant.length << 2) + 20];
        int n3 = 0;
        for (n2 = this.mant.length - 1; n2 >= 0; --n2) {
            cArray[n3++] = (char)(this.mant[n2] / 1000 + 48);
            cArray[n3++] = (char)(this.mant[n2] / 100 % 10 + 48);
            cArray[n3++] = (char)(this.mant[n2] / 10 % 10 + 48);
            cArray[n3++] = (char)(this.mant[n2] % 10 + 48);
        }
        for (n3 = 0; n3 < cArray.length && cArray[n3] == '0'; ++n3) {
        }
        int n4 = n3;
        n2 = 0;
        if (this.sign == -1) {
            ++n2;
            cArray2[0] = 45;
        }
        if (n3 != cArray.length) {
            cArray2[n2++] = cArray[n3++];
            cArray2[n2++] = 46;
            while (n3 < cArray.length) {
                cArray2[n2++] = cArray[n3++];
            }
        } else {
            cArray2[n2++] = 48;
            cArray2[n2++] = 46;
            cArray2[n2++] = 48;
            cArray2[n2++] = 101;
            cArray2[n2] = 48;
            return new String(cArray2, 0, 5);
        }
        cArray2[n2++] = 101;
        n4 = n = (this.exp << 2) - n4 - 1;
        if (n < 0) {
            n4 = -n;
        }
        for (n3 = 1000000000; n3 > n4; n3 /= 10) {
        }
        if (n < 0) {
            cArray2[n2++] = 45;
        }
        while (n3 > 0) {
            cArray2[n2++] = (char)(n4 / n3 + 48);
            n4 %= n3;
            n3 /= 10;
        }
        return new String(cArray2, 0, n2);
    }

    protected String dfp2string() {
        char[] cArray = new char[(this.mant.length << 2) + 20];
        int n = 1;
        int n2 = this.exp;
        boolean bl = false;
        cArray[0] = 32;
        if (n2 <= 0) {
            ++n;
            cArray[1] = 48;
            ++n;
            cArray[2] = 46;
            bl = true;
        }
        while (n2 < 0) {
            cArray[n++] = 48;
            cArray[n++] = 48;
            cArray[n++] = 48;
            cArray[n++] = 48;
            ++n2;
        }
        for (int i2 = this.mant.length - 1; i2 >= 0; --i2) {
            cArray[n++] = (char)(this.mant[i2] / 1000 + 48);
            cArray[n++] = (char)(this.mant[i2] / 100 % 10 + 48);
            cArray[n++] = (char)(this.mant[i2] / 10 % 10 + 48);
            cArray[n++] = (char)(this.mant[i2] % 10 + 48);
            if (--n2 != 0) continue;
            cArray[n++] = 46;
            bl = true;
        }
        while (n2 > 0) {
            cArray[n++] = 48;
            cArray[n++] = 48;
            cArray[n++] = 48;
            cArray[n++] = 48;
            --n2;
        }
        if (!bl) {
            cArray[n++] = 46;
        }
        n2 = 1;
        while (cArray[n2] == '0') {
            ++n2;
        }
        if (cArray[n2] == '.') {
            --n2;
        }
        while (cArray[n - 1] == '0') {
            --n;
        }
        if (this.sign < 0) {
            cArray[--n2] = 45;
        }
        return new String(cArray, n2, n - n2);
    }

    public Dfp dotrap(int n, String string, Dfp dfp, Dfp dfp2) {
        Dfp dfp3 = dfp2;
        switch (n) {
            case 1: {
                Dfp dfp4 = this;
                dfp3 = dfp4.newInstance(dfp4.getZero());
                dfp4.newInstance(dfp4.getZero()).sign = dfp2.sign;
                dfp3.nans = (byte)3;
                break;
            }
            case 2: {
                if (this.nans == 0 && this.mant[this.mant.length - 1] != 0) {
                    Dfp dfp5 = this;
                    dfp3 = dfp5.newInstance(dfp5.getZero());
                    dfp5.newInstance(dfp5.getZero()).sign = (byte)(this.sign * dfp.sign);
                    dfp3.nans = 1;
                }
                if (this.nans == 0 && this.mant[this.mant.length - 1] == 0) {
                    Dfp dfp6 = this;
                    dfp3 = dfp6.newInstance(dfp6.getZero());
                    dfp6.newInstance(dfp6.getZero()).nans = (byte)3;
                }
                if (this.nans == 1 || this.nans == 3) {
                    Dfp dfp7 = this;
                    dfp3 = dfp7.newInstance(dfp7.getZero());
                    dfp7.newInstance(dfp7.getZero()).nans = (byte)3;
                }
                if (this.nans != 1 && this.nans != 2) break;
                Dfp dfp8 = this;
                dfp3 = dfp8.newInstance(dfp8.getZero());
                dfp8.newInstance(dfp8.getZero()).nans = (byte)3;
                break;
            }
            case 8: {
                if (dfp2.exp + this.mant.length < -32767) {
                    Dfp dfp9 = this;
                    dfp3 = dfp9.newInstance(dfp9.getZero());
                    dfp9.newInstance(dfp9.getZero()).sign = dfp2.sign;
                } else {
                    dfp3 = this.newInstance(dfp2);
                }
                dfp2.exp += 32760;
                break;
            }
            case 4: {
                dfp2.exp -= 32760;
                Dfp dfp10 = this;
                dfp3 = dfp10.newInstance(dfp10.getZero());
                dfp10.newInstance(dfp10.getZero()).sign = dfp2.sign;
                dfp3.nans = 1;
                break;
            }
            default: {
                dfp3 = dfp2;
            }
        }
        return this.trap(n, string, dfp, dfp3, dfp2);
    }

    protected Dfp trap(int n, String string, Dfp dfp, Dfp dfp2, Dfp dfp3) {
        return dfp2;
    }

    public int classify() {
        return this.nans;
    }

    public static Dfp copysign(Dfp dfp, Dfp dfp2) {
        Dfp dfp3 = dfp;
        dfp = dfp3.newInstance(dfp3);
        dfp3.newInstance(dfp3).sign = dfp2.sign;
        return dfp;
    }

    public Dfp nextAfter(Dfp dfp) {
        Dfp dfp2;
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp3 = this;
            Dfp dfp4 = dfp3.newInstance(dfp3.getZero());
            dfp3.newInstance(dfp3.getZero()).nans = (byte)3;
            return this.dotrap(1, NEXT_AFTER_TRAP, dfp, dfp4);
        }
        boolean bl = false;
        if (this.lessThan(dfp)) {
            bl = true;
        }
        if (Dfp.compare(this, dfp) == 0) {
            return this.newInstance(dfp);
        }
        Dfp dfp5 = this;
        if (dfp5.lessThan(dfp5.getZero())) {
            boolean bl2 = bl = !bl;
        }
        if (bl) {
            Dfp dfp6 = this;
            dfp2 = dfp6.newInstance(dfp6.getOne());
            dfp6.newInstance(dfp6.getOne()).exp = this.exp - this.mant.length + 1;
            dfp2.sign = this.sign;
            Dfp dfp7 = this;
            if (dfp7.equals(dfp7.getZero())) {
                dfp2.exp = -32767 - this.mant.length;
            }
            dfp2 = this.add(dfp2);
        } else {
            Dfp dfp8 = this;
            dfp2 = dfp8.newInstance(dfp8.getOne());
            dfp8.newInstance(dfp8.getOne()).exp = this.exp;
            dfp2.sign = this.sign;
            dfp2.exp = this.equals(dfp2) ? this.exp - this.mant.length : this.exp - this.mant.length + 1;
            Dfp dfp9 = this;
            if (dfp9.equals(dfp9.getZero())) {
                dfp2.exp = -32767 - this.mant.length;
            }
            dfp2 = this.subtract(dfp2);
        }
        if (dfp2.classify() == 1 && this.classify() != 1) {
            this.field.setIEEEFlagsBits(16);
            dfp2 = this.dotrap(16, NEXT_AFTER_TRAP, dfp, dfp2);
        }
        if (dfp2.equals(this.getZero())) {
            Dfp dfp10 = this;
            if (!dfp10.equals(dfp10.getZero())) {
                this.field.setIEEEFlagsBits(16);
                dfp2 = this.dotrap(16, NEXT_AFTER_TRAP, dfp, dfp2);
            }
        }
        return dfp2;
    }

    public double toDouble() {
        if (this.isInfinite()) {
            Dfp dfp = this;
            if (dfp.lessThan(dfp.getZero())) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (this.isNaN()) {
            return Double.NaN;
        }
        Object object = this;
        boolean bl = false;
        Dfp dfp = this;
        int n = Dfp.compare(dfp, dfp.getZero());
        if (n == 0) {
            if (this.sign < 0) {
                return -0.0;
            }
            return 0.0;
        }
        if (n < 0) {
            object = this.negate();
            bl = true;
        }
        if ((n = (int)((double)((Dfp)object).intLog10() * 3.32)) < 0) {
            --n;
        }
        Dfp dfp2 = DfpMath.pow(this.getTwo(), n);
        while (dfp2.lessThan((Dfp)object) || dfp2.equals(object)) {
            dfp2 = dfp2.multiply(2);
            ++n;
        }
        object = ((Dfp)object).divide(DfpMath.pow(this.getTwo(), --n));
        if (n > -1023) {
            object = ((Dfp)object).subtract(this.getOne());
        }
        if (n < -1074) {
            return 0.0;
        }
        if (n > 1023) {
            if (bl) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        object = ((Dfp)object).multiply(this.newInstance(0x10000000000000L)).rint();
        object = ((Dfp)object).toString();
        long l = Long.parseLong((String)(object = ((String)object).substring(0, ((String)object).length() - 1)));
        if (l == 0x10000000000000L) {
            l = 0L;
            ++n;
        }
        if (n <= -1023) {
            --n;
        }
        while (n < -1023) {
            ++n;
            l >>>= 1;
        }
        long l2 = l | (long)n + 1023L << 52;
        double d2 = Double.longBitsToDouble(l2);
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    public double[] toSplitDouble() {
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = Double.longBitsToDouble(Double.doubleToLongBits(this.toDouble()) & 0xFFFFFFFFC0000000L);
        Dfp dfp = this;
        dArray2[1] = dfp.subtract(dfp.newInstance(dArray2[0])).toDouble();
        return dArray2;
    }

    @Override
    public double getReal() {
        return this.toDouble();
    }

    @Override
    public Dfp add(double d2) {
        Dfp dfp = this;
        return dfp.add(dfp.newInstance(d2));
    }

    @Override
    public Dfp subtract(double d2) {
        Dfp dfp = this;
        return dfp.subtract(dfp.newInstance(d2));
    }

    @Override
    public Dfp multiply(double d2) {
        Dfp dfp = this;
        return dfp.multiply(dfp.newInstance(d2));
    }

    @Override
    public Dfp divide(double d2) {
        Dfp dfp = this;
        return dfp.divide(dfp.newInstance(d2));
    }

    @Override
    public Dfp remainder(double d2) {
        Dfp dfp = this;
        return dfp.remainder(dfp.newInstance(d2));
    }

    @Override
    public long round() {
        return FastMath.round(this.toDouble());
    }

    @Override
    public Dfp signum() {
        if (this.isNaN() || this.isZero()) {
            return this;
        }
        Dfp dfp = this;
        return dfp.newInstance(dfp.sign > 0 ? 1 : -1);
    }

    @Override
    public Dfp copySign(Dfp dfp) {
        if (this.sign >= 0 && dfp.sign >= 0 || this.sign < 0 && dfp.sign < 0) {
            return this;
        }
        return this.negate();
    }

    @Override
    public Dfp copySign(double d2) {
        long l = Double.doubleToLongBits(d2);
        if (this.sign >= 0 && l >= 0L || this.sign < 0 && l < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public Dfp scalb(int n) {
        Dfp dfp = this;
        return dfp.multiply(DfpMath.pow(dfp.getTwo(), n));
    }

    @Override
    public Dfp hypot(Dfp dfp) {
        Dfp dfp2 = this;
        Dfp dfp3 = dfp;
        return dfp2.multiply(dfp2).add(dfp3.multiply(dfp3)).sqrt();
    }

    @Override
    public Dfp cbrt() {
        return this.rootN(3);
    }

    @Override
    public Dfp rootN(int n) {
        if (this.sign >= 0) {
            Dfp dfp = this;
            return DfpMath.pow(dfp, dfp.getOne().divide(n));
        }
        return DfpMath.pow(this.negate(), this.getOne().divide(n)).negate();
    }

    @Override
    public Dfp pow(double d2) {
        Dfp dfp = this;
        return DfpMath.pow(dfp, dfp.newInstance(d2));
    }

    @Override
    public Dfp pow(int n) {
        return DfpMath.pow(this, n);
    }

    @Override
    public Dfp pow(Dfp dfp) {
        return DfpMath.pow(this, dfp);
    }

    @Override
    public Dfp exp() {
        return DfpMath.exp(this);
    }

    @Override
    public Dfp expm1() {
        return DfpMath.exp(this).subtract(this.getOne());
    }

    @Override
    public Dfp log() {
        return DfpMath.log(this);
    }

    @Override
    public Dfp log1p() {
        Dfp dfp = this;
        return DfpMath.log(dfp.add(dfp.getOne()));
    }

    @Deprecated
    public int log10() {
        return this.intLog10();
    }

    @Override
    public Dfp cos() {
        return DfpMath.cos(this);
    }

    @Override
    public Dfp sin() {
        return DfpMath.sin(this);
    }

    @Override
    public Dfp tan() {
        return DfpMath.tan(this);
    }

    @Override
    public Dfp acos() {
        return DfpMath.acos(this);
    }

    @Override
    public Dfp asin() {
        return DfpMath.asin(this);
    }

    @Override
    public Dfp atan() {
        return DfpMath.atan(this);
    }

    @Override
    public Dfp atan2(Dfp dfp) {
        Dfp dfp2 = dfp;
        Dfp dfp3 = this;
        Dfp dfp4 = dfp2.multiply(dfp2).add(dfp3.multiply(dfp3)).sqrt();
        if (dfp.sign >= 0) {
            return this.getTwo().multiply(this.divide(dfp4.add(dfp)).atan());
        }
        dfp = this.getTwo().multiply(this.divide(dfp4.subtract(dfp)).atan());
        dfp4 = this.newInstance(dfp.sign <= 0 ? -Math.PI : Math.PI);
        return dfp4.subtract(dfp);
    }

    @Override
    public Dfp cosh() {
        return DfpMath.exp(this).add(DfpMath.exp(this.negate())).divide(2);
    }

    @Override
    public Dfp sinh() {
        return DfpMath.exp(this).subtract(DfpMath.exp(this.negate())).divide(2);
    }

    @Override
    public Dfp tanh() {
        Dfp dfp = DfpMath.exp(this);
        Dfp dfp2 = DfpMath.exp(this.negate());
        return dfp.subtract(dfp2).divide(dfp.add(dfp2));
    }

    @Override
    public Dfp acosh() {
        Dfp dfp = this;
        return dfp.multiply(dfp).subtract(this.getOne()).sqrt().add(this).log();
    }

    @Override
    public Dfp asinh() {
        Dfp dfp = this;
        return dfp.multiply(dfp).add(this.getOne()).sqrt().add(this).log();
    }

    @Override
    public Dfp atanh() {
        return this.getOne().add(this).divide(this.getOne().subtract(this)).log().divide(2);
    }

    public Dfp linearCombination(Dfp[] dfpArray, Dfp[] dfpArray2) {
        if (dfpArray.length != dfpArray2.length) {
            throw new DimensionMismatchException(dfpArray.length, dfpArray2.length);
        }
        Dfp dfp = this.getZero();
        for (int i2 = 0; i2 < dfpArray.length; ++i2) {
            dfp = dfp.add(dfpArray[i2].multiply(dfpArray2[i2]));
        }
        return dfp;
    }

    public Dfp linearCombination(double[] dArray, Dfp[] dfpArray) {
        if (dArray.length != dfpArray.length) {
            throw new DimensionMismatchException(dArray.length, dfpArray.length);
        }
        Dfp dfp = this.getZero();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dfp = dfp.add(dfpArray[i2].multiply(dArray[i2]));
        }
        return dfp;
    }

    @Override
    public Dfp linearCombination(Dfp dfp, Dfp dfp2, Dfp dfp3, Dfp dfp4) {
        return dfp.multiply(dfp2).add(dfp3.multiply(dfp4));
    }

    @Override
    public Dfp linearCombination(double d2, Dfp dfp, double d3, Dfp dfp2) {
        return dfp.multiply(d2).add(dfp2.multiply(d3));
    }

    @Override
    public Dfp linearCombination(Dfp dfp, Dfp dfp2, Dfp dfp3, Dfp dfp4, Dfp dfp5, Dfp dfp6) {
        return dfp.multiply(dfp2).add(dfp3.multiply(dfp4)).add(dfp5.multiply(dfp6));
    }

    @Override
    public Dfp linearCombination(double d2, Dfp dfp, double d3, Dfp dfp2, double d4, Dfp dfp3) {
        return dfp.multiply(d2).add(dfp2.multiply(d3)).add(dfp3.multiply(d4));
    }

    @Override
    public Dfp linearCombination(Dfp dfp, Dfp dfp2, Dfp dfp3, Dfp dfp4, Dfp dfp5, Dfp dfp6, Dfp dfp7, Dfp dfp8) {
        return dfp.multiply(dfp2).add(dfp3.multiply(dfp4)).add(dfp5.multiply(dfp6)).add(dfp7.multiply(dfp8));
    }

    @Override
    public Dfp linearCombination(double d2, Dfp dfp, double d3, Dfp dfp2, double d4, Dfp dfp3, double d5, Dfp dfp4) {
        return dfp.multiply(d2).add(dfp2.multiply(d3)).add(dfp3.multiply(d4)).add(dfp4.multiply(d5));
    }
}

