/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.complex;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public class RootsOfUnity
implements Serializable {
    private static final long serialVersionUID = 20120201L;
    private int omegaCount = 0;
    private double[] omegaReal = null;
    private double[] omegaImaginaryCounterClockwise = null;
    private double[] omegaImaginaryClockwise = null;
    private boolean isCounterClockWise = true;

    public synchronized boolean isCounterClockWise() {
        if (this.omegaCount == 0) {
            throw new MathIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
        }
        return this.isCounterClockWise;
    }

    public synchronized void computeRoots(int n) {
        if (n == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.CANNOT_COMPUTE_0TH_ROOT_OF_UNITY, new Object[0]);
        }
        this.isCounterClockWise = n > 0;
        if ((n = FastMath.abs(n)) == this.omegaCount) {
            return;
        }
        double d2 = Math.PI * 2 / (double)n;
        double d3 = FastMath.cos(d2);
        double d4 = FastMath.sin(d2);
        this.omegaReal = new double[n];
        this.omegaImaginaryCounterClockwise = new double[n];
        this.omegaImaginaryClockwise = new double[n];
        this.omegaReal[0] = 1.0;
        this.omegaImaginaryCounterClockwise[0] = 0.0;
        this.omegaImaginaryClockwise[0] = 0.0;
        for (int i2 = 1; i2 < n; ++i2) {
            this.omegaReal[i2] = this.omegaReal[i2 - 1] * d3 - this.omegaImaginaryCounterClockwise[i2 - 1] * d4;
            this.omegaImaginaryCounterClockwise[i2] = this.omegaReal[i2 - 1] * d4 + this.omegaImaginaryCounterClockwise[i2 - 1] * d3;
            this.omegaImaginaryClockwise[i2] = -this.omegaImaginaryCounterClockwise[i2];
        }
        this.omegaCount = n;
    }

    public synchronized double getReal(int n) {
        if (this.omegaCount == 0) {
            throw new MathIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
        }
        if (n < 0 || n >= this.omegaCount) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, (Number)n, 0, this.omegaCount - 1);
        }
        return this.omegaReal[n];
    }

    public synchronized double getImaginary(int n) {
        if (this.omegaCount == 0) {
            throw new MathIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
        }
        if (n < 0 || n >= this.omegaCount) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, (Number)n, 0, this.omegaCount - 1);
        }
        if (this.isCounterClockWise) {
            return this.omegaImaginaryCounterClockwise[n];
        }
        return this.omegaImaginaryClockwise[n];
    }

    public synchronized int getNumberOfRoots() {
        return this.omegaCount;
    }
}

