/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.complex;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.Serializable;

public final class Quaternion
implements Serializable {
    public static final Quaternion IDENTITY = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    public static final Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);
    private static final long serialVersionUID = 20092012L;
    private final double q0;
    private final double q1;
    private final double q2;
    private final double q3;

    public Quaternion(double d2, double d3, double d4, double d5) {
        this.q0 = d2;
        this.q1 = d3;
        this.q2 = d4;
        this.q3 = d5;
    }

    public Quaternion(double d2, double[] dArray) {
        if (dArray.length != 3) {
            throw new DimensionMismatchException(dArray.length, 3);
        }
        this.q0 = d2;
        this.q1 = dArray[0];
        this.q2 = dArray[1];
        this.q3 = dArray[2];
    }

    public Quaternion(double[] dArray) {
        this(0.0, dArray);
    }

    public final Quaternion getConjugate() {
        return new Quaternion(this.q0, -this.q1, -this.q2, -this.q3);
    }

    public static Quaternion multiply(Quaternion quaternion, Quaternion quaternion2) {
        double d2 = quaternion.getQ0();
        double d3 = quaternion.getQ1();
        double d4 = quaternion.getQ2();
        double d5 = quaternion.getQ3();
        double d6 = quaternion2.getQ0();
        double d7 = quaternion2.getQ1();
        double d8 = quaternion2.getQ2();
        double d9 = quaternion2.getQ3();
        double d10 = d2 * d6 - d3 * d7 - d4 * d8 - d5 * d9;
        double d11 = d2 * d7 + d3 * d6 + d4 * d9 - d5 * d8;
        double d12 = d2 * d8 - d3 * d9 + d4 * d6 + d5 * d7;
        double d13 = d2 * d9 + d3 * d8 - d4 * d7 + d5 * d6;
        return new Quaternion(d10, d11, d12, d13);
    }

    public final Quaternion multiply(Quaternion quaternion) {
        return Quaternion.multiply(this, quaternion);
    }

    public static Quaternion add(Quaternion quaternion, Quaternion quaternion2) {
        return new Quaternion(quaternion.getQ0() + quaternion2.getQ0(), quaternion.getQ1() + quaternion2.getQ1(), quaternion.getQ2() + quaternion2.getQ2(), quaternion.getQ3() + quaternion2.getQ3());
    }

    public final Quaternion add(Quaternion quaternion) {
        return Quaternion.add(this, quaternion);
    }

    public static Quaternion subtract(Quaternion quaternion, Quaternion quaternion2) {
        return new Quaternion(quaternion.getQ0() - quaternion2.getQ0(), quaternion.getQ1() - quaternion2.getQ1(), quaternion.getQ2() - quaternion2.getQ2(), quaternion.getQ3() - quaternion2.getQ3());
    }

    public final Quaternion subtract(Quaternion quaternion) {
        return Quaternion.subtract(this, quaternion);
    }

    public static double dotProduct(Quaternion quaternion, Quaternion quaternion2) {
        return quaternion.getQ0() * quaternion2.getQ0() + quaternion.getQ1() * quaternion2.getQ1() + quaternion.getQ2() * quaternion2.getQ2() + quaternion.getQ3() * quaternion2.getQ3();
    }

    public final double dotProduct(Quaternion quaternion) {
        return Quaternion.dotProduct(this, quaternion);
    }

    public final double getNorm() {
        return FastMath.sqrt(this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3);
    }

    public final Quaternion normalize() {
        double d2;
        double d3 = this.getNorm();
        if (d2 < Precision.SAFE_MIN) {
            throw new ZeroException((Localizable)LocalizedFormats.NORM, d3);
        }
        return new Quaternion(this.q0 / d3, this.q1 / d3, this.q2 / d3, this.q3 / d3);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Quaternion) {
            return this.q0 == ((Quaternion)(object = (Quaternion)object)).getQ0() && this.q1 == ((Quaternion)object).getQ1() && this.q2 == ((Quaternion)object).getQ2() && this.q3 == ((Quaternion)object).getQ3();
        }
        return false;
    }

    public final int hashCode() {
        int n = 17;
        double[] dArray = new double[]{this.q0, this.q1, this.q2, this.q3};
        int cfr_ignored_0 = dArray.length;
        for (int i2 = 0; i2 < 4; ++i2) {
            double d2 = dArray[i2];
            int n2 = MathUtils.hash(d2);
            n = n * 31 + n2;
        }
        return n;
    }

    public final boolean equals(Quaternion quaternion, double d2) {
        return Precision.equals(this.q0, quaternion.getQ0(), d2) && Precision.equals(this.q1, quaternion.getQ1(), d2) && Precision.equals(this.q2, quaternion.getQ2(), d2) && Precision.equals(this.q3, quaternion.getQ3(), d2);
    }

    public final boolean isUnitQuaternion(double d2) {
        return Precision.equals(this.getNorm(), 1.0, d2);
    }

    public final boolean isPureQuaternion(double d2) {
        return FastMath.abs(this.getQ0()) <= d2;
    }

    public final Quaternion getPositivePolarForm() {
        if (this.getQ0() < 0.0) {
            Quaternion quaternion = this.normalize();
            return new Quaternion(-quaternion.getQ0(), -quaternion.getQ1(), -quaternion.getQ2(), -quaternion.getQ3());
        }
        return this.normalize();
    }

    public final Quaternion getInverse() {
        double d2;
        double d3 = this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
        if (d2 < Precision.SAFE_MIN) {
            throw new ZeroException((Localizable)LocalizedFormats.NORM, d3);
        }
        return new Quaternion(this.q0 / d3, -this.q1 / d3, -this.q2 / d3, -this.q3 / d3);
    }

    public final double getQ0() {
        return this.q0;
    }

    public final double getQ1() {
        return this.q1;
    }

    public final double getQ2() {
        return this.q2;
    }

    public final double getQ3() {
        return this.q3;
    }

    public final double getScalarPart() {
        return this.getQ0();
    }

    public final double[] getVectorPart() {
        return new double[]{this.getQ1(), this.getQ2(), this.getQ3()};
    }

    public final Quaternion multiply(double d2) {
        return new Quaternion(d2 * this.q0, d2 * this.q1, d2 * this.q2, d2 * this.q3);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.q0).append(" ").append(this.q1).append(" ").append(this.q2).append(" ").append(this.q3).append("]");
        return stringBuilder.toString();
    }
}

