/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.complex;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class ComplexUtils {
    private ComplexUtils() {
    }

    public static Complex polar2Complex(double d2, double d3) {
        if (d2 < 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_COMPLEX_MODULE, d2);
        }
        return new Complex(d2 * FastMath.cos(d3), d2 * FastMath.sin(d3));
    }

    public static Complex[] convertToComplex(double[] dArray) {
        Complex[] complexArray = new Complex[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            complexArray[i2] = new Complex(dArray[i2], 0.0);
        }
        return complexArray;
    }
}

