/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.complex;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathParseException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CompositeFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class ComplexFormat {
    private static final String DEFAULT_IMAGINARY_CHARACTER = "i";
    private final String imaginaryCharacter;
    private final NumberFormat imaginaryFormat;
    private final NumberFormat realFormat;

    public ComplexFormat() {
        this.imaginaryCharacter = DEFAULT_IMAGINARY_CHARACTER;
        this.realFormat = this.imaginaryFormat = CompositeFormat.getDefaultNumberFormat();
    }

    public ComplexFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.IMAGINARY_FORMAT, new Object[0]);
        }
        this.imaginaryCharacter = DEFAULT_IMAGINARY_CHARACTER;
        this.imaginaryFormat = numberFormat;
        this.realFormat = numberFormat;
    }

    public ComplexFormat(NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (numberFormat2 == null) {
            throw new NullArgumentException(LocalizedFormats.IMAGINARY_FORMAT, new Object[0]);
        }
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.REAL_FORMAT, new Object[0]);
        }
        this.imaginaryCharacter = DEFAULT_IMAGINARY_CHARACTER;
        this.imaginaryFormat = numberFormat2;
        this.realFormat = numberFormat;
    }

    public ComplexFormat(String string) {
        this(string, CompositeFormat.getDefaultNumberFormat());
    }

    public ComplexFormat(String string, NumberFormat numberFormat) {
        NumberFormat numberFormat2 = numberFormat;
        this(string, numberFormat2, numberFormat2);
    }

    public ComplexFormat(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (string == null) {
            throw new NullArgumentException();
        }
        if (string.length() == 0) {
            throw new NoDataException();
        }
        if (numberFormat2 == null) {
            throw new NullArgumentException(LocalizedFormats.IMAGINARY_FORMAT, new Object[0]);
        }
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.REAL_FORMAT, new Object[0]);
        }
        this.imaginaryCharacter = string;
        this.imaginaryFormat = numberFormat2;
        this.realFormat = numberFormat;
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public String format(Complex complex) {
        return this.format(complex, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Double d2) {
        return this.format(new Complex(d2, 0.0), new StringBuffer(), new FieldPosition(0)).toString();
    }

    public StringBuffer format(Complex serializable, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        double d2;
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        double d3 = serializable.getReal();
        CompositeFormat.formatDouble(d3, this.getRealFormat(), stringBuffer, fieldPosition);
        double d4 = serializable.getImaginary();
        if (d2 < 0.0) {
            stringBuffer.append(" - ");
            serializable = this.formatImaginary(-d4, new StringBuffer(), fieldPosition);
            stringBuffer.append((StringBuffer)serializable);
            stringBuffer.append(this.getImaginaryCharacter());
        } else if (d4 > 0.0 || Double.isNaN(d4)) {
            stringBuffer.append(" + ");
            serializable = this.formatImaginary(d4, new StringBuffer(), fieldPosition);
            stringBuffer.append((StringBuffer)serializable);
            stringBuffer.append(this.getImaginaryCharacter());
        }
        return stringBuffer;
    }

    private StringBuffer formatImaginary(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        CompositeFormat.formatDouble(d2, this.getImaginaryFormat(), stringBuffer, fieldPosition);
        if (stringBuffer.toString().equals("1")) {
            stringBuffer.setLength(0);
        }
        return stringBuffer;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Complex) {
            object = this.format((Complex)object, stringBuffer, fieldPosition);
        } else if (object instanceof Number) {
            object = this.format(new Complex(((Number)object).doubleValue(), 0.0), stringBuffer, fieldPosition);
        } else {
            throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_FORMAT_INSTANCE_AS_COMPLEX, object.getClass().getName());
        }
        return object;
    }

    public String getImaginaryCharacter() {
        return this.imaginaryCharacter;
    }

    public NumberFormat getImaginaryFormat() {
        return this.imaginaryFormat;
    }

    public static ComplexFormat getInstance() {
        return ComplexFormat.getInstance(Locale.getDefault());
    }

    public static ComplexFormat getInstance(Locale cloneable) {
        cloneable = CompositeFormat.getDefaultNumberFormat(cloneable);
        return new ComplexFormat((NumberFormat)cloneable);
    }

    public static ComplexFormat getInstance(String string, Locale cloneable) {
        cloneable = CompositeFormat.getDefaultNumberFormat(cloneable);
        return new ComplexFormat(string, (NumberFormat)cloneable);
    }

    public NumberFormat getRealFormat() {
        return this.realFormat;
    }

    public Complex parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Complex complex = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), Complex.class);
        }
        return complex;
    }

    public Complex parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number = CompositeFormat.parseNumber(string, this.getRealFormat(), parsePosition);
        if (number == null) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c2 = CompositeFormat.parseNextCharacter(string, parsePosition);
        switch (c2) {
            case '\u0000': {
                return new Complex(number.doubleValue(), 0.0);
            }
            case '-': {
                n2 = -1;
                break;
            }
            case '+': {
                n2 = 1;
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number2 = CompositeFormat.parseNumber(string, this.getRealFormat(), parsePosition);
        if (number2 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (!CompositeFormat.parseFixedstring(string, this.getImaginaryCharacter(), parsePosition)) {
            return null;
        }
        return new Complex(number.doubleValue(), number2.doubleValue() * (double)n2);
    }
}

