/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.complex;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.ComplexField;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Complex
implements FieldElement<Complex>,
Serializable {
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex NaN = new Complex(Double.NaN, Double.NaN);
    public static final Complex INF = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    private static final long serialVersionUID = -6195664516687396620L;
    private final double imaginary;
    private final double real;
    private final transient boolean isNaN;
    private final transient boolean isInfinite;

    public Complex(double d2) {
        this(d2, 0.0);
    }

    public Complex(double d2, double d3) {
        this.real = d2;
        this.imaginary = d3;
        this.isNaN = Double.isNaN(d2) || Double.isNaN(d3);
        this.isInfinite = !this.isNaN && (Double.isInfinite(d2) || Double.isInfinite(d3));
    }

    public double abs() {
        double d2;
        if (this.isNaN) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        if (FastMath.abs(this.real) < FastMath.abs(this.imaginary)) {
            double d3;
            if (this.imaginary == 0.0) {
                return FastMath.abs(this.real);
            }
            double d4 = d3 = this.real / this.imaginary;
            return FastMath.abs(this.imaginary) * FastMath.sqrt(1.0 + d4 * d4);
        }
        if (this.real == 0.0) {
            return FastMath.abs(this.imaginary);
        }
        double d5 = d2 = this.imaginary / this.real;
        return FastMath.abs(this.real) * FastMath.sqrt(1.0 + d5 * d5);
    }

    @Override
    public Complex add(Complex complex) {
        MathUtils.checkNotNull(complex);
        if (this.isNaN || complex.isNaN) {
            return NaN;
        }
        Complex complex2 = this;
        return complex2.createComplex(complex2.real + complex.getReal(), this.imaginary + complex.getImaginary());
    }

    @Override
    public Complex add(double d2) {
        if (this.isNaN || Double.isNaN(d2)) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(complex.real + d2, this.imaginary);
    }

    public Complex conjugate() {
        if (this.isNaN) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(complex.real, -this.imaginary);
    }

    @Override
    public Complex divide(Complex complex) {
        MathUtils.checkNotNull(complex);
        if (this.isNaN || complex.isNaN) {
            return NaN;
        }
        double d2 = complex.getReal();
        double d3 = complex.getImaginary();
        if (d2 == 0.0 && d3 == 0.0) {
            return NaN;
        }
        if (complex.isInfinite() && !this.isInfinite()) {
            return ZERO;
        }
        if (FastMath.abs(d2) < FastMath.abs(d3)) {
            double d4 = d2 / d3;
            double d5 = d2 * d4 + d3;
            Complex complex2 = this;
            return complex2.createComplex((complex2.real * d4 + this.imaginary) / d5, (this.imaginary * d4 - this.real) / d5);
        }
        double d6 = d3 / d2;
        double d7 = d3 * d6 + d2;
        Complex complex3 = this;
        return complex3.createComplex((complex3.imaginary * d6 + this.real) / d7, (this.imaginary - this.real * d6) / d7);
    }

    @Override
    public Complex divide(double d2) {
        if (this.isNaN || Double.isNaN(d2)) {
            return NaN;
        }
        if (d2 == 0.0) {
            return NaN;
        }
        if (Double.isInfinite(d2)) {
            if (!this.isInfinite()) {
                return ZERO;
            }
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(complex.real / d2, this.imaginary / d2);
    }

    @Override
    public Complex reciprocal() {
        double d2;
        if (this.isNaN) {
            return NaN;
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return INF;
        }
        if (this.isInfinite) {
            return ZERO;
        }
        if (FastMath.abs(this.real) < FastMath.abs(this.imaginary)) {
            double d3 = this.real / this.imaginary;
            double d4 = 1.0 / (this.real * d3 + this.imaginary);
            return this.createComplex(d4 * d3, -d4);
        }
        double d5 = this.imaginary / this.real;
        double d6 = d2 = 1.0 / (this.imaginary * d5 + this.real);
        return this.createComplex(d6, -d6 * d5);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Complex) {
            object = (Complex)object;
            if (((Complex)object).isNaN) {
                return this.isNaN;
            }
            return MathUtils.equals(this.real, ((Complex)object).real) && MathUtils.equals(this.imaginary, ((Complex)object).imaginary);
        }
        return false;
    }

    public static boolean equals(Complex complex, Complex complex2, int n) {
        return Precision.equals(complex.real, complex2.real, n) && Precision.equals(complex.imaginary, complex2.imaginary, n);
    }

    public static boolean equals(Complex complex, Complex complex2) {
        return Complex.equals(complex, complex2, 1);
    }

    public static boolean equals(Complex complex, Complex complex2, double d2) {
        return Precision.equals(complex.real, complex2.real, d2) && Precision.equals(complex.imaginary, complex2.imaginary, d2);
    }

    public static boolean equalsWithRelativeTolerance(Complex complex, Complex complex2, double d2) {
        return Precision.equalsWithRelativeTolerance(complex.real, complex2.real, d2) && Precision.equalsWithRelativeTolerance(complex.imaginary, complex2.imaginary, d2);
    }

    public int hashCode() {
        if (this.isNaN) {
            return 7;
        }
        return 37 * (17 * MathUtils.hash(this.imaginary) + MathUtils.hash(this.real));
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public double getReal() {
        return this.real;
    }

    public boolean isNaN() {
        return this.isNaN;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    @Override
    public Complex multiply(Complex complex) {
        MathUtils.checkNotNull(complex);
        if (this.isNaN || complex.isNaN) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(complex.real) || Double.isInfinite(complex.imaginary)) {
            return INF;
        }
        Complex complex2 = this;
        return complex2.createComplex(complex2.real * complex.real - this.imaginary * complex.imaginary, this.real * complex.imaginary + this.imaginary * complex.real);
    }

    @Override
    public Complex multiply(int n) {
        if (this.isNaN) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary)) {
            return INF;
        }
        Complex complex = this;
        return complex.createComplex(complex.real * (double)n, this.imaginary * (double)n);
    }

    @Override
    public Complex multiply(double d2) {
        if (this.isNaN || Double.isNaN(d2)) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(d2)) {
            return INF;
        }
        Complex complex = this;
        return complex.createComplex(complex.real * d2, this.imaginary * d2);
    }

    @Override
    public Complex negate() {
        if (this.isNaN) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(-complex.real, -this.imaginary);
    }

    @Override
    public Complex subtract(Complex complex) {
        MathUtils.checkNotNull(complex);
        if (this.isNaN || complex.isNaN) {
            return NaN;
        }
        Complex complex2 = this;
        return complex2.createComplex(complex2.real - complex.getReal(), this.imaginary - complex.getImaginary());
    }

    @Override
    public Complex subtract(double d2) {
        if (this.isNaN || Double.isNaN(d2)) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(complex.real - d2, this.imaginary);
    }

    public Complex acos() {
        if (this.isNaN) {
            return NaN;
        }
        Complex complex = this;
        return complex.add(complex.sqrt1z().multiply(I)).log().multiply(I.negate());
    }

    public Complex asin() {
        if (this.isNaN) {
            return NaN;
        }
        return this.sqrt1z().add(this.multiply(I)).log().multiply(I.negate());
    }

    public Complex atan() {
        if (this.isNaN) {
            return NaN;
        }
        return this.add(I).divide(I.subtract(this)).log().multiply(I.divide(this.createComplex(2.0, 0.0)));
    }

    public Complex cos() {
        if (this.isNaN) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(FastMath.cos(complex.real) * FastMath.cosh(this.imaginary), -FastMath.sin(this.real) * FastMath.sinh(this.imaginary));
    }

    public Complex cosh() {
        if (this.isNaN) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(FastMath.cosh(complex.real) * FastMath.cos(this.imaginary), FastMath.sinh(this.real) * FastMath.sin(this.imaginary));
    }

    public Complex exp() {
        if (this.isNaN) {
            return NaN;
        }
        double d2 = FastMath.exp(this.real);
        return this.createComplex(d2 * FastMath.cos(this.imaginary), d2 * FastMath.sin(this.imaginary));
    }

    public Complex log() {
        if (this.isNaN) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(FastMath.log(complex.abs()), FastMath.atan2(this.imaginary, this.real));
    }

    public Complex pow(Complex complex) {
        MathUtils.checkNotNull(complex);
        return this.log().multiply(complex).exp();
    }

    public Complex pow(double d2) {
        return this.log().multiply(d2).exp();
    }

    public Complex sin() {
        if (this.isNaN) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(FastMath.sin(complex.real) * FastMath.cosh(this.imaginary), FastMath.cos(this.real) * FastMath.sinh(this.imaginary));
    }

    public Complex sinh() {
        if (this.isNaN) {
            return NaN;
        }
        Complex complex = this;
        return complex.createComplex(FastMath.sinh(complex.real) * FastMath.cos(this.imaginary), FastMath.cosh(this.real) * FastMath.sin(this.imaginary));
    }

    public Complex sqrt() {
        if (this.isNaN) {
            return NaN;
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return this.createComplex(0.0, 0.0);
        }
        double d2 = FastMath.sqrt((FastMath.abs(this.real) + this.abs()) / 2.0);
        if (this.real >= 0.0) {
            return this.createComplex(d2, this.imaginary / (d2 * 2.0));
        }
        Complex complex = this;
        return complex.createComplex(FastMath.abs(complex.imaginary) / (d2 * 2.0), FastMath.copySign(1.0, this.imaginary) * d2);
    }

    public Complex sqrt1z() {
        Complex complex = this;
        return this.createComplex(1.0, 0.0).subtract(complex.multiply(complex)).sqrt();
    }

    public Complex tan() {
        if (this.isNaN || Double.isInfinite(this.real)) {
            return NaN;
        }
        if (this.imaginary > 20.0) {
            return this.createComplex(0.0, 1.0);
        }
        if (this.imaginary < -20.0) {
            return this.createComplex(0.0, -1.0);
        }
        double d2 = 2.0 * this.real;
        double d3 = 2.0 * this.imaginary;
        double d4 = FastMath.cos(d2) + FastMath.cosh(d3);
        return this.createComplex(FastMath.sin(d2) / d4, FastMath.sinh(d3) / d4);
    }

    public Complex tanh() {
        if (this.isNaN || Double.isInfinite(this.imaginary)) {
            return NaN;
        }
        if (this.real > 20.0) {
            return this.createComplex(1.0, 0.0);
        }
        if (this.real < -20.0) {
            return this.createComplex(-1.0, 0.0);
        }
        double d2 = 2.0 * this.real;
        double d3 = 2.0 * this.imaginary;
        double d4 = FastMath.cosh(d2) + FastMath.cos(d3);
        return this.createComplex(FastMath.sinh(d2) / d4, FastMath.sin(d3) / d4);
    }

    public double getArgument() {
        return FastMath.atan2(this.getImaginary(), this.getReal());
    }

    public List<Complex> nthRoot(int n) {
        if (n <= 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.CANNOT_COMPUTE_NTH_ROOT_FOR_NEGATIVE_N, n);
        }
        ArrayList<Complex> arrayList = new ArrayList<Complex>();
        if (this.isNaN) {
            arrayList.add(NaN);
            return arrayList;
        }
        if (this.isInfinite()) {
            arrayList.add(INF);
            return arrayList;
        }
        double d2 = FastMath.pow(this.abs(), 1.0 / (double)n);
        double d3 = this.getArgument() / (double)n;
        double d4 = Math.PI * 2 / (double)n;
        double d5 = d3;
        for (int i2 = 0; i2 < n; ++i2) {
            double d6 = d2 * FastMath.cos(d5);
            double d7 = d2 * FastMath.sin(d5);
            arrayList.add(this.createComplex(d6, d7));
            d5 += d4;
        }
        return arrayList;
    }

    protected Complex createComplex(double d2, double d3) {
        return new Complex(d2, d3);
    }

    public static Complex valueOf(double d2, double d3) {
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return NaN;
        }
        return new Complex(d2, d3);
    }

    public static Complex valueOf(double d2) {
        if (Double.isNaN(d2)) {
            return NaN;
        }
        return new Complex(d2);
    }

    protected final Object readResolve() {
        Complex complex = this;
        return complex.createComplex(complex.real, this.imaginary);
    }

    public ComplexField getField() {
        return ComplexField.getInstance();
    }

    public String toString() {
        return "(" + this.real + ", " + this.imaginary + ")";
    }
}

