/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AllowedSolution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BrentSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoBracketingException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnivariateSolverUtils {
    private UnivariateSolverUtils() {
    }

    public static double solve(UnivariateFunction univariateFunction, double d2, double d3) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        BrentSolver brentSolver = new BrentSolver();
        return brentSolver.solve(Integer.MAX_VALUE, univariateFunction, d2, d3);
    }

    public static double solve(UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        BrentSolver brentSolver = new BrentSolver(d4);
        return brentSolver.solve(Integer.MAX_VALUE, univariateFunction, d2, d3);
    }

    public static double forceSide(int n, UnivariateFunction univariateFunction, BracketedUnivariateSolver<UnivariateFunction> bracketedUnivariateSolver, double d2, double d3, double d4, AllowedSolution allowedSolution) {
        if (allowedSolution == AllowedSolution.ANY_SIDE) {
            return d2;
        }
        double d5 = FastMath.max(bracketedUnivariateSolver.getAbsoluteAccuracy(), FastMath.abs(d2 * bracketedUnivariateSolver.getRelativeAccuracy()));
        double d6 = FastMath.max(d3, d2 - d5);
        double d7 = univariateFunction.value(d6);
        double d8 = FastMath.min(d4, d2 + d5);
        double d9 = univariateFunction.value(d8);
        int n2 = n - 2;
        while (n2 > 0) {
            if (d7 >= 0.0 && d9 <= 0.0 || d7 <= 0.0 && d9 >= 0.0) {
                return bracketedUnivariateSolver.solve(n2, univariateFunction, d6, d8, d2, allowedSolution);
            }
            boolean bl = false;
            boolean bl2 = false;
            if (d7 < d9) {
                if (d7 >= 0.0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            } else if (d7 > d9) {
                if (d7 <= 0.0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            } else {
                bl = true;
                bl2 = true;
            }
            if (bl) {
                d6 = FastMath.max(d3, d6 - d5);
                d7 = univariateFunction.value(d6);
                --n2;
            }
            if (!bl2) continue;
            d8 = FastMath.min(d4, d8 + d5);
            d9 = univariateFunction.value(d8);
            --n2;
        }
        throw new NoBracketingException((Localizable)LocalizedFormats.FAILED_BRACKETING, d6, d8, d7, d9, new Object[]{n - n2, n, d2, d3, d4});
    }

    public static double[] bracket(UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        return UnivariateSolverUtils.bracket(univariateFunction, d2, d3, d4, 1.0, 1.0, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateFunction univariateFunction, double d2, double d3, double d4, int n) {
        return UnivariateSolverUtils.bracket(univariateFunction, d2, d3, d4, 1.0, 1.0, n);
    }

    public static double[] bracket(UnivariateFunction univariateFunction, double d2, double d3, double d4, double d5, double d6, int n) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        if (d5 <= 0.0) {
            throw new NotStrictlyPositiveException(d5);
        }
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INVALID_MAX_ITERATIONS, n);
        }
        UnivariateSolverUtils.verifySequence(d3, d2, d4);
        double d7 = d2;
        double d8 = d2;
        double d9 = Double.NaN;
        double d10 = Double.NaN;
        double d11 = 0.0;
        for (int i2 = 0; i2 < n && (d7 > d3 || d8 < d4); ++i2) {
            double d12 = d7;
            double d13 = d9;
            double d14 = d8;
            double d15 = d10;
            d11 = d6 * d11 + d5;
            d7 = FastMath.max(d2 - d11, d3);
            d8 = FastMath.min(d2 + d11, d4);
            d9 = univariateFunction.value(d7);
            d10 = univariateFunction.value(d8);
            if (i2 == 0) {
                if (!(d9 * d10 <= 0.0)) continue;
                return new double[]{d7, d8};
            }
            if (d9 * d13 <= 0.0) {
                return new double[]{d7, d12};
            }
            if (!(d10 * d15 <= 0.0)) continue;
            return new double[]{d14, d8};
        }
        throw new NoBracketingException(d7, d8, d9, d10);
    }

    public static double midpoint(double d2, double d3) {
        return (d2 + d3) * 0.5;
    }

    public static boolean isBracketing(UnivariateFunction univariateFunction, double d2, double d3) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        double d4 = univariateFunction.value(d2);
        double d5 = univariateFunction.value(d3);
        return d4 >= 0.0 && d5 <= 0.0 || d4 <= 0.0 && d5 >= 0.0;
    }

    public static boolean isSequence(double d2, double d3, double d4) {
        return d2 < d3 && d3 < d4;
    }

    public static void verifyInterval(double d2, double d3) {
        if (d2 >= d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d2, d3, false);
        }
    }

    public static void verifySequence(double d2, double d3, double d4) {
        UnivariateSolverUtils.verifyInterval(d2, d3);
        UnivariateSolverUtils.verifyInterval(d3, d4);
    }

    public static void verifyBracketing(UnivariateFunction univariateFunction, double d2, double d3) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        UnivariateSolverUtils.verifyInterval(d2, d3);
        if (!UnivariateSolverUtils.isBracketing(univariateFunction, d2, d3)) {
            throw new NoBracketingException(d2, d3, univariateFunction.value(d2), univariateFunction.value(d3));
        }
    }
}

